/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.backend.javascript.spi.GeneratedBy;
import org.teavm.classlib.java.lang.MathNativeGenerator;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.interop.Import;

public final class TMath
extends TObject {
    public static final double E = Math.E;
    public static final double PI = Math.PI;

    private TMath() {
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="math", name="sin")
    public static native double sin(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="math", name="cos")
    public static native double cos(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="math", name="tan")
    public static native double tan(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="math", name="asin")
    public static native double asin(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="math", name="acos")
    public static native double acos(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="math", name="atan")
    public static native double atan(double var0);

    public static double toRadians(double angdeg) {
        return angdeg * Math.PI / 180.0;
    }

    public static double toDegrees(double angrad) {
        return angrad * 180.0 / Math.PI;
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="math", name="exp")
    public static native double exp(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="math", name="log")
    public static native double log(double var0);

    public static double log10(double a) {
        return TMath.log(a) / 2.302585092994046;
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="math", name="sqrt")
    public static native double sqrt(double var0);

    public static double cbrt(double a) {
        return a > 0.0 ? TMath.pow(a, 0.3333333333333333) : -TMath.pow(-a, 0.3333333333333333);
    }

    public static double IEEEremainder(double f1, double f2) {
        int n = (int)(f1 / f2);
        return f1 - (double)n * f2;
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="math", name="ceil")
    public static native double ceil(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="math", name="floor")
    public static native double floor(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="math", name="pow")
    public static native double pow(double var0, double var2);

    public static double rint(double a) {
        return TMath.round(a);
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="math", name="atan2")
    public static native double atan2(double var0, double var2);

    public static int round(float a) {
        return (int)(a + TMath.signum(a) * 0.5f);
    }

    public static long round(double a) {
        return (long)(a + TMath.signum(a) * 0.5);
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="math", name="random")
    public static native double random();

    public static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static int max(int a, int b) {
        return a > b ? a : b;
    }

    public static long min(long a, long b) {
        return a < b ? a : b;
    }

    public static long max(long a, long b) {
        return a > b ? a : b;
    }

    public static double min(double a, double b) {
        return a < b ? a : b;
    }

    public static double max(double a, double b) {
        return a > b ? a : b;
    }

    public static float min(float a, float b) {
        return a < b ? a : b;
    }

    public static float max(float a, float b) {
        return a > b ? a : b;
    }

    public static int abs(int n) {
        return n > 0 ? n : -n;
    }

    public static long abs(long n) {
        return n > 0L ? n : -n;
    }

    public static float abs(float n) {
        return n > 0.0f ? n : -n;
    }

    public static double abs(double n) {
        return n > 0.0 ? n : -n;
    }

    public static double ulp(double d) {
        return TMath.pow(2.0, TMath.getExponent(d) - 52);
    }

    public static float ulp(float d) {
        return (float)TMath.pow(2.0, TMath.getExponent(d) - 23);
    }

    public static double signum(double d) {
        return d > 0.0 ? 1.0 : (d < 0.0 ? -1.0 : d);
    }

    public static float signum(float d) {
        return d > 0.0f ? 1.0f : (d < 0.0f ? -1.0f : d);
    }

    public static double sinh(double x) {
        double e = TMath.exp(x);
        return (e - 1.0 / e) / 2.0;
    }

    public static double cosh(double x) {
        double e = TMath.exp(x);
        return (e + 1.0 / e) / 2.0;
    }

    public static double tanh(double x) {
        double e = TMath.exp(x);
        return (e - 1.0 / e) / (e + 1.0 / e);
    }

    public static double hypot(double x, double y) {
        return x * x + y * y;
    }

    public static double expm1(double x) {
        return TMath.exp(x) - 1.0;
    }

    public static double log1p(double x) {
        return TMath.log(x + 1.0);
    }

    public static float copySign(float magnitude, float sign) {
        if (sign == 0.0f || sign == 0.0f) {
            return sign;
        }
        return sign > 0.0f == magnitude > 0.0f ? magnitude : -magnitude;
    }

    public static double copySign(double magnitude, double sign) {
        if (sign == 0.0 || sign == 0.0) {
            return sign;
        }
        return sign > 0.0 == magnitude > 0.0 ? magnitude : -magnitude;
    }

    public static int getExponent(double d) {
        d = TMath.abs(d);
        int exp = 0;
        double[] exponents = ExponentConstants.exponents;
        double[] negativeExponents = ExponentConstants.negativeExponents;
        double[] negativeExponents2 = ExponentConstants.negativeExponents2;
        if (d > 1.0) {
            int expBit = 1 << exponents.length - 1;
            for (int i = exponents.length - 1; i >= 0; --i) {
                if (d >= exponents[i]) {
                    d *= negativeExponents[i];
                    exp |= expBit;
                }
                expBit >>>= 1;
            }
        } else if (d < 1.0) {
            int expBit = 1 << negativeExponents.length - 1;
            int offset = 0;
            if (d < Double.MIN_NORMAL) {
                d *= 4.503599627370496E15;
                offset = 52;
            }
            for (int i = negativeExponents2.length - 1; i >= 0; --i) {
                if (d < negativeExponents2[i]) {
                    d *= exponents[i];
                    exp |= expBit;
                }
                expBit >>>= 1;
            }
            exp = -(exp + offset);
        }
        return exp;
    }

    public static int getExponent(float f) {
        f = TMath.abs(f);
        int exp = 0;
        float[] exponents = FloatExponents.exponents;
        float[] negativeExponents = FloatExponents.negativeExponents;
        float[] negativeExponents2 = FloatExponents.negativeExponents2;
        if (f > 1.0f) {
            int expBit = 1 << exponents.length - 1;
            for (int i = exponents.length - 1; i >= 0; --i) {
                if (f >= exponents[i]) {
                    f *= negativeExponents[i];
                    exp |= expBit;
                }
                expBit >>>= 1;
            }
        } else if (f < 1.0f) {
            int expBit = 1 << negativeExponents.length - 1;
            int offset = 0;
            if ((double)f < 1.1754943508222875E-38) {
                f *= 8388608.0f;
                offset = 23;
            }
            for (int i = negativeExponents2.length - 1; i >= 0; --i) {
                if (f < negativeExponents2[i]) {
                    f *= exponents[i];
                    exp |= expBit;
                }
                expBit >>>= 1;
            }
            exp = -(exp + offset);
        }
        return exp;
    }

    public static double nextAfter(double start, double direction) {
        if (start == direction) {
            return direction;
        }
        return direction > start ? start + TMath.ulp(start) : start - TMath.ulp(start);
    }

    public static float nextAfter(float start, double direction) {
        if ((double)start == direction) {
            return start;
        }
        return direction > (double)start ? start + TMath.ulp(start) : start - TMath.ulp(start);
    }

    public static double nextUp(double d) {
        return d + TMath.ulp(d);
    }

    public static float nextUp(float d) {
        return d + TMath.ulp(d);
    }

    private static class FloatExponents {
        public static float[] exponents = new float[]{2.0f, 4.0f, 16.0f, 256.0f, 65536.0f, 4.2949673E9f, 1.8446744E19f};
        public static float[] negativeExponents = new float[]{0.5f, 0.25f, 0.0625f, 0.00390625f, 1.5258789E-5f, 2.3283064E-10f, 5.421011E-20f};
        public static float[] negativeExponents2 = new float[]{1.0f, 0.5f, 0.125f, 0.0078125f, 3.0517578E-5f, 4.656613E-10f, 1.0842022E-19f};

        private FloatExponents() {
        }
    }

    private static class ExponentConstants {
        public static double[] exponents = new double[]{2.0, 4.0, 16.0, 256.0, 65536.0, 4.294967296E9, 1.8446744073709552E19, 3.402823669209385E38, 1.157920892373162E77, 1.3407807929942597E154};
        public static double[] negativeExponents = new double[]{0.5, 0.25, 0.0625, 0.00390625, 1.52587890625E-5, 2.3283064365386963E-10, 5.421010862427522E-20, 2.938735877055719E-39, 8.636168555094445E-78, 7.458340731200207E-155};
        public static double[] negativeExponents2 = new double[]{1.0, 0.5, 0.125, 0.0078125, 3.0517578125E-5, 4.656612873077393E-10, 1.0842021724855044E-19, 5.877471754111438E-39, 1.727233711018889E-77, 1.4916681462400413E-154};

        private ExponentConstants() {
        }
    }
}

