/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.Arrays;
import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.lang.TIllegalArgumentException;
import org.teavm.classlib.java.lang.TIndexOutOfBoundsException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.util.TAbstractList;
import org.teavm.classlib.java.util.TArrays;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.interop.Rename;

public class TArrayList<E>
extends TAbstractList<E>
implements TCloneable,
TSerializable {
    private E[] array;
    private int size;

    public TArrayList() {
        this(10);
    }

    public TArrayList(int initialCapacity) {
        this.array = new Object[initialCapacity];
    }

    public TArrayList(TCollection<? extends E> c) {
        this(c.size());
        TIterator iter = c.iterator();
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = iter.next();
        }
        this.size = this.array.length;
    }

    public void trimToSize() {
        this.array = Arrays.copyOf(this.array, this.size);
    }

    public void ensureCapacity(int minCapacity) {
        if (this.array.length < minCapacity) {
            int newLength = this.array.length < 0x3FFFFFFF ? Math.max(minCapacity, Math.max(this.array.length * 2, 5)) : Integer.MAX_VALUE;
            this.array = TArrays.copyOf(this.array, newLength);
        }
    }

    @Override
    public E get(int index) {
        this.checkIndex(index);
        return this.array[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Rename(value="clone")
    public TObject clone0() {
        return new TArrayList<E>(this);
    }

    @Override
    public E set(int index, E element) {
        this.checkIndex(index);
        E old = this.array[index];
        this.array[index] = element;
        return old;
    }

    @Override
    public void add(int index, E element) {
        this.checkIndexForAdd(index);
        this.ensureCapacity(this.size + 1);
        for (int i = this.size; i > index; --i) {
            this.array[i] = this.array[i - 1];
        }
        this.array[index] = element;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public E remove(int index) {
        this.checkIndex(index);
        E old = this.array[index];
        --this.size;
        for (int i = index; i < this.size; ++i) {
            this.array[i] = this.array[i + 1];
        }
        this.array[this.size] = null;
        ++this.modCount;
        return old;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        Arrays.fill(this.array, 0, this.size, null);
        this.size = 0;
    }

    @Override
    public boolean addAll(int index, TCollection<? extends E> c) {
        this.checkIndexForAdd(index);
        if (c.isEmpty()) {
            return false;
        }
        this.ensureCapacity(this.size + c.size());
        int gap = c.size();
        for (int i = this.size - 1; i >= index; --i) {
            this.array[i + gap] = this.array[i];
        }
        this.size += gap;
        TIterator iter = c.iterator();
        for (int i = 0; i < gap; ++i) {
            this.array[index++] = iter.next();
        }
        ++this.modCount;
        return true;
    }

    @Override
    protected void removeRange(int start, int end) {
        if (start > end) {
            throw new TIllegalArgumentException();
        }
        if (start < 0 || end > this.size) {
            throw new TIndexOutOfBoundsException();
        }
        if (start == end) {
            return;
        }
        for (int i = end; i < this.size; ++i) {
            this.array[start++] = this.array[end++];
        }
        Arrays.fill(this.array, start, end, null);
        this.size -= end - start;
        ++this.modCount;
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new TIndexOutOfBoundsException();
        }
    }

    private void checkIndexForAdd(int index) {
        if (index < 0 || index > this.size) {
            throw new TIndexOutOfBoundsException();
        }
    }
}

