/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.gradle.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.teavm.backend.wasm.disasm.Disassembler;
import org.teavm.backend.wasm.disasm.DisassemblyHTMLWriter;
import org.teavm.backend.wasm.disasm.DisassemblyTextWriter;
import org.teavm.backend.wasm.disasm.DisassemblyWriter;

public abstract class DisasmWebAssemblyTask
extends DefaultTask {
    public DisasmWebAssemblyTask() {
        this.getHtml().convention((Object)false);
    }

    @InputFile
    public abstract RegularFileProperty getInputFile();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Input
    public abstract Property<Boolean> getHtml();

    @TaskAction
    public void disassemble() throws IOException {
        File file = ((RegularFile)this.getInputFile().get()).getAsFile();
        byte[] bytes = Files.readAllBytes(file.toPath());
        FileOutputStream output = new FileOutputStream(((RegularFile)this.getOutputFile().get()).getAsFile());
        PrintWriter writer = new PrintWriter(output);
        Boolean html = (Boolean)this.getHtml().get();
        DisassemblyHTMLWriter disassemblyWriter = html != false ? new DisassemblyHTMLWriter(writer) : new DisassemblyTextWriter(writer);
        disassemblyWriter.setWithAddress(true);
        if (html.booleanValue()) {
            disassemblyWriter.write("<html><body><pre>").eol();
        }
        Disassembler disassembler = new Disassembler((DisassemblyWriter)disassemblyWriter);
        disassembler.disassemble(bytes);
        if (html.booleanValue()) {
            disassemblyWriter.write("</pre></body></html>").eol();
        }
    }
}

