/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.gradle;

import groovy.lang.Closure;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.teavm.gradle.TeaVMTestsImpl;
import org.teavm.gradle.api.TeaVMBaseExtension;
import org.teavm.gradle.api.TeaVMLibraries;
import org.teavm.gradle.api.TeaVMTests;

class TeaVMBaseExtensionImpl
implements TeaVMBaseExtension {
    protected Project project;
    private Provider<Properties> properties;
    private TeaVMTestsImpl tests;
    private TeaVMLibraries libs = new TeaVMLibraries(){

        @Override
        public Dependency getJso() {
            return TeaVMBaseExtensionImpl.this.project.getDependencies().create((Object)"org.teavm:teavm-jso:0.12.3");
        }

        @Override
        public Dependency getJsoApis() {
            return TeaVMBaseExtensionImpl.this.project.getDependencies().create((Object)"org.teavm:teavm-jso-apis:0.12.3");
        }

        @Override
        public Dependency getInterop() {
            return TeaVMBaseExtensionImpl.this.project.getDependencies().create((Object)"org.teavm:teavm-interop:0.12.3");
        }

        @Override
        public Dependency getMetaprogramming() {
            return TeaVMBaseExtensionImpl.this.project.getDependencies().create((Object)"org.teavm:teavm-metaprogramming-api:0.12.3");
        }
    };

    @Inject
    TeaVMBaseExtensionImpl(Project project, ObjectFactory objectFactory) {
        this.project = project;
        this.properties = project.provider(() -> {
            Properties result = new Properties();
            for (Project p = project; p != null; p = p.getParent()) {
                File dir = p.getProjectDir();
                this.append(result, new File(dir, "teavm-local.properties"));
                this.append(result, new File(dir, "teavm.properties"));
            }
            return result;
        });
        this.tests = new TeaVMTestsImpl(objectFactory);
        this.tests.configure(this);
    }

    private void append(Properties target, File source) throws IOException {
        if (!source.isFile()) {
            return;
        }
        Properties props = new Properties();
        try (FileReader input = new FileReader(source, StandardCharsets.UTF_8);){
            props.load(input);
        }
        this.append(target, props);
    }

    private void append(Properties target, Properties source) {
        for (String key : source.stringPropertyNames()) {
            if (target.containsKey(key)) continue;
            target.setProperty(key, source.getProperty(key));
        }
    }

    @Override
    public TeaVMLibraries getLibs() {
        return this.libs;
    }

    @Override
    public Provider<String> property(String name) {
        String gradleName = "teavm." + name;
        return this.project.getProviders().systemProperty(gradleName).orElse(this.properties.map(p -> {
            String result = p.getProperty(name);
            if (result != null) {
                return result;
            }
            return (String)this.project.getRootProject().getProviders().gradleProperty(gradleName).getOrElse(null);
        }));
    }

    @Override
    public TeaVMTests getTests() {
        return this.tests;
    }

    @Override
    public void tests(Action<TeaVMTests> config) {
        config.execute((Object)this.tests);
    }

    @Override
    public void tests(Closure<?> config) {
        config.rehydrate((Object)this.getTests(), config.getOwner(), config.getThisObject()).call();
    }
}

