/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import org.teavm.backend.javascript.TeaVMJavaScriptHost;
import org.teavm.backend.javascript.spi.Injector;
import org.teavm.backend.javascript.spi.MethodContributor;
import org.teavm.backend.wasm.gc.TeaVMWasmGCHost;
import org.teavm.dependency.DependencyListener;
import org.teavm.jso.JSExceptions;
import org.teavm.jso.JSObject;
import org.teavm.jso.impl.DynamicGenerator;
import org.teavm.jso.impl.DynamicInjector;
import org.teavm.jso.impl.GeneratorAnnotationInstaller;
import org.teavm.jso.impl.JS;
import org.teavm.jso.impl.JSAliasRenderer;
import org.teavm.jso.impl.JSBodyGenerator;
import org.teavm.jso.impl.JSBodyRepository;
import org.teavm.jso.impl.JSDependencyListener;
import org.teavm.jso.impl.JSExceptionsDependencyListener;
import org.teavm.jso.impl.JSExceptionsGenerator;
import org.teavm.jso.impl.JSExportedMethodAsFunction;
import org.teavm.jso.impl.JSObjectClassTransformer;
import org.teavm.jso.impl.JSWrapper;
import org.teavm.jso.impl.JSWrapperDependency;
import org.teavm.jso.impl.JSWrapperGenerator;
import org.teavm.jso.impl.wasmgc.WasmGCJso;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.MethodReference;
import org.teavm.platform.plugin.PlatformPlugin;
import org.teavm.vm.TeaVMPluginUtil;
import org.teavm.vm.spi.After;
import org.teavm.vm.spi.RendererListener;
import org.teavm.vm.spi.TeaVMHost;
import org.teavm.vm.spi.TeaVMPlugin;

@After(value={PlatformPlugin.class})
public class JSOPlugin
implements TeaVMPlugin {
    public void install(TeaVMHost host) {
        TeaVMJavaScriptHost jsHost = (TeaVMJavaScriptHost)host.getExtension(TeaVMJavaScriptHost.class);
        TeaVMWasmGCHost wasmGCHost = (TeaVMWasmGCHost)host.getExtension(TeaVMWasmGCHost.class);
        if (jsHost == null && wasmGCHost == null) {
            return;
        }
        JSBodyRepository repository = new JSBodyRepository();
        host.registerService(JSBodyRepository.class, (Object)repository);
        JSObjectClassTransformer classTransformer = new JSObjectClassTransformer(repository);
        host.add((ClassHolderTransformer)classTransformer);
        JSDependencyListener dependencyListener = new JSDependencyListener(repository);
        host.add((DependencyListener)dependencyListener);
        host.add((DependencyListener)new JSExceptionsDependencyListener());
        JSWrapperDependency wrapperDependency = new JSWrapperDependency();
        host.add((DependencyListener)wrapperDependency);
        TeaVMPluginUtil.handleNatives((TeaVMHost)host, JS.class);
        if (jsHost != null) {
            this.installForJS(jsHost);
        }
        if (wasmGCHost != null) {
            classTransformer.setClassFilter(n -> !n.startsWith("java."));
            classTransformer.forWasmGC();
            WasmGCJso.install(host, wasmGCHost, repository);
        }
    }

    private void installForJS(TeaVMJavaScriptHost jsHost) {
        JSAliasRenderer aliasRenderer = new JSAliasRenderer();
        jsHost.add((RendererListener)aliasRenderer);
        jsHost.addGeneratorProvider(new GeneratorAnnotationInstaller<JSBodyGenerator>(new JSBodyGenerator(), DynamicGenerator.class.getName()));
        jsHost.addInjectorProvider(new GeneratorAnnotationInstaller<JSBodyGenerator>(new JSBodyGenerator(), DynamicInjector.class.getName()));
        jsHost.addVirtualMethods((MethodContributor)aliasRenderer);
        jsHost.addForcedFunctionMethods((MethodContributor)new JSExportedMethodAsFunction());
        JSExceptionsGenerator exceptionsGenerator = new JSExceptionsGenerator();
        jsHost.add(new MethodReference(JSExceptions.class, "getJavaException", new Class[]{JSObject.class, Throwable.class}), (Injector)exceptionsGenerator);
        jsHost.add(new MethodReference(JSExceptions.class, "getJSException", new Class[]{Throwable.class, JSObject.class}), (Injector)exceptionsGenerator);
        JSWrapperGenerator wrapperGenerator = new JSWrapperGenerator();
        jsHost.add(new MethodReference(JSWrapper.class, "directJavaToJs", new Class[]{Object.class, JSObject.class}), (Injector)wrapperGenerator);
        jsHost.add(new MethodReference(JSWrapper.class, "directJsToJava", new Class[]{JSObject.class, Object.class}), (Injector)wrapperGenerator);
        jsHost.add(new MethodReference(JSWrapper.class, "dependencyJavaToJs", new Class[]{Object.class, JSObject.class}), (Injector)wrapperGenerator);
        jsHost.add(new MethodReference(JSWrapper.class, "dependencyJsToJava", new Class[]{JSObject.class, Object.class}), (Injector)wrapperGenerator);
        jsHost.add(new MethodReference(JSWrapper.class, "marshallJavaToJs", new Class[]{Object.class, JSObject.class}), (Injector)wrapperGenerator);
        jsHost.add(new MethodReference(JSWrapper.class, "unmarshallJavaFromJs", new Class[]{JSObject.class, Object.class}), (Injector)wrapperGenerator);
        jsHost.add(new MethodReference(JSWrapper.class, "isJava", new Class[]{Object.class, Boolean.TYPE}), (Injector)wrapperGenerator);
        jsHost.add(new MethodReference(JSWrapper.class, "isJava", new Class[]{JSObject.class, Boolean.TYPE}), (Injector)wrapperGenerator);
        jsHost.add(new MethodReference(JSWrapper.class, "wrapperToJs", new Class[]{JSWrapper.class, JSObject.class}), (Injector)wrapperGenerator);
        jsHost.add(new MethodReference(JSWrapper.class, "jsToWrapper", new Class[]{JSObject.class, JSWrapper.class}), (Injector)wrapperGenerator);
    }
}

