/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl.wasmgc;

import org.teavm.interop.Import;
import org.teavm.jso.JSObject;
import org.teavm.jso.impl.wasmgc.WasmGCExceptionWrapper;

final class WasmGCJSRuntime {
    private WasmGCJSRuntime() {
    }

    static JSObject stringToJs(String str) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return WasmGCJSRuntime.emptyString();
        }
        JSObject jsStr = WasmGCJSRuntime.stringFromCharCode(str.charAt(0));
        for (int i = 1; i < str.length(); ++i) {
            jsStr = WasmGCJSRuntime.concatStrings(jsStr, WasmGCJSRuntime.stringFromCharCode(str.charAt(i)));
        }
        return jsStr;
    }

    static String jsToString(JSObject obj) {
        if (obj == null) {
            return null;
        }
        int length = WasmGCJSRuntime.stringLength(obj);
        if (length == 0) {
            return "";
        }
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = WasmGCJSRuntime.charAt(obj, i);
        }
        return new String(chars);
    }

    @Import(name="emptyString", module="teavmJso")
    static native JSObject emptyString();

    @Import(name="stringFromCharCode", module="teavmJso")
    static native JSObject stringFromCharCode(char var0);

    @Import(name="concatStrings", module="teavmJso")
    static native JSObject concatStrings(JSObject var0, JSObject var1);

    @Import(name="emptyArray", module="teavmJso")
    static native JSObject emptyArray();

    @Import(name="appendToArray", module="teavmJso")
    static native JSObject appendToArray(JSObject var0, JSObject var1);

    @Import(name="stringLength", module="teavmJso")
    static native int stringLength(JSObject var0);

    @Import(name="charAt", module="teavmJso")
    static native char charAt(JSObject var0, int var1);

    static native JSObject wrapObject(Object var0);

    static Throwable wrapException(JSObject obj) {
        return new WasmGCExceptionWrapper(obj);
    }

    static JSObject extractException(Throwable e) {
        return e instanceof WasmGCExceptionWrapper ? ((WasmGCExceptionWrapper)e).jsException : null;
    }
}

