/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.teavm.browserrunner.BrowserRunDescriptor;
import org.teavm.browserrunner.BrowserRunner;
import org.teavm.junit.AttachJavaScript;
import org.teavm.junit.TestRun;
import org.teavm.junit.TestRunStrategy;

class BrowserRunStrategy
implements TestRunStrategy {
    private File baseDir;
    private BrowserRunner runner;

    BrowserRunStrategy(File baseDir, String type, Function<String, Process> browserRunner) {
        this.baseDir = baseDir;
        this.runner = new BrowserRunner(baseDir, type, browserRunner, Boolean.parseBoolean(System.getProperty("teavm.junit.js.decodeStack", "true")));
    }

    @Override
    public void beforeAll() {
        this.runner.start();
    }

    @Override
    public void afterAll() {
        this.runner.stop();
    }

    @Override
    public void runTest(TestRun run) throws IOException {
        File testFile = new File(run.getBaseDirectory(), run.getFileName());
        String testPath = this.baseDir.getAbsoluteFile().toPath().relativize(testFile.toPath()).toString();
        BrowserRunDescriptor descriptor = new BrowserRunDescriptor(run.getFileName(), "tests/" + testPath, run.isModule(), (Collection)this.additionalJs(run).stream().map(p -> "resources/" + p).collect(Collectors.toList()), run.getArgument());
        this.runner.runTest(descriptor);
    }

    private Collection<String> additionalJs(TestRun run) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Method method = run.getMethod();
        AttachJavaScript attachAnnot = method.getAnnotation(AttachJavaScript.class);
        if (attachAnnot != null) {
            result.addAll(List.of(attachAnnot.value()));
        }
        for (Class<?> cls = method.getDeclaringClass(); cls != null; cls = cls.getSuperclass()) {
            AttachJavaScript classAttachAnnot = cls.getAnnotation(AttachJavaScript.class);
            if (classAttachAnnot == null) continue;
            result.addAll(List.of(attachAnnot.value()));
        }
        return result;
    }
}

