/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.teavm.backend.wasm.WasmRuntimeType;
import org.teavm.backend.wasm.WasmTarget;
import org.teavm.junit.BaseWebAssemblyPlatformSupport;
import org.teavm.junit.TeaVMTestConfiguration;
import org.teavm.junit.TestPlatform;
import org.teavm.junit.TestRunStrategy;
import org.teavm.junit.WasiRunStrategy;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ReferenceCache;

class WasiPlatformSupport
extends BaseWebAssemblyPlatformSupport {
    WasiPlatformSupport(ClassHolderSource classSource, ReferenceCache referenceCache) {
        super(classSource, referenceCache);
    }

    @Override
    TestRunStrategy createRunStrategy(File outputDir) {
        String wasiCommand = System.getProperty("teavm.junit.wasi.runner");
        if (wasiCommand != null) {
            return new WasiRunStrategy(wasiCommand);
        }
        return null;
    }

    @Override
    protected WasmRuntimeType getRuntimeType() {
        return WasmRuntimeType.WASI;
    }

    @Override
    TestPlatform getPlatform() {
        return TestPlatform.WASI;
    }

    @Override
    String getPath() {
        return "wasi";
    }

    @Override
    boolean isEnabled() {
        return Boolean.getBoolean("teavm.junit.wasi");
    }

    @Override
    List<TeaVMTestConfiguration<WasmTarget>> getConfigurations() {
        ArrayList<TeaVMTestConfiguration<WasmTarget>> configurations = new ArrayList<TeaVMTestConfiguration<WasmTarget>>();
        configurations.add(TeaVMTestConfiguration.WASM_DEFAULT);
        if (Boolean.getBoolean("teavm.junit.optimized")) {
            configurations.add(TeaVMTestConfiguration.WASM_OPTIMIZED);
        }
        return configurations;
    }
}

