/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.teavm.backend.wasm.WasmDebugInfoLevel;
import org.teavm.backend.wasm.WasmDebugInfoLocation;
import org.teavm.backend.wasm.WasmGCTarget;
import org.teavm.backend.wasm.debug.sourcemap.SourceMapBuilder;
import org.teavm.backend.wasm.disasm.Disassembler;
import org.teavm.backend.wasm.disasm.DisassemblyHTMLWriter;
import org.teavm.backend.wasm.disasm.DisassemblyWriter;
import org.teavm.browserrunner.BrowserRunner;
import org.teavm.debugging.information.SourceFileResolver;
import org.teavm.junit.BrowserRunStrategy;
import org.teavm.junit.CompilePostProcessor;
import org.teavm.junit.CompileResult;
import org.teavm.junit.ServeJS;
import org.teavm.junit.ServeJSList;
import org.teavm.junit.TeaVMTestConfiguration;
import org.teavm.junit.TestPlatform;
import org.teavm.junit.TestPlatformSupport;
import org.teavm.junit.TestRunStrategy;
import org.teavm.junit.TestUtil;
import org.teavm.junit.TestWasmGCEntryPoint;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.MethodReference;
import org.teavm.model.ReferenceCache;
import org.teavm.tooling.TeaVMSourceFilePolicy;
import org.teavm.tooling.sources.DefaultSourceFileResolver;
import org.teavm.tooling.sources.DirectorySourceFileProvider;
import org.teavm.tooling.sources.JarSourceFileProvider;
import org.teavm.tooling.sources.SourceFileProvider;
import org.teavm.vm.TeaVM;

class WebAssemblyGCPlatformSupport
extends TestPlatformSupport<WasmGCTarget> {
    private boolean disassembly;
    private List<SourceFileProvider> sourceFileProviders = new ArrayList<SourceFileProvider>();

    WebAssemblyGCPlatformSupport(ClassHolderSource classSource, ReferenceCache referenceCache, boolean disassembly) {
        super(classSource, referenceCache);
        this.disassembly = disassembly;
        String sourceDirs = System.getProperty("teavm.junit.sourceDirs");
        if (sourceDirs != null) {
            StringTokenizer tokenizer = new StringTokenizer(sourceDirs, Character.toString(File.pathSeparatorChar));
            while (tokenizer.hasMoreTokens()) {
                File file = new File(tokenizer.nextToken());
                if (file.isDirectory()) {
                    this.sourceFileProviders.add((SourceFileProvider)new DirectorySourceFileProvider(file));
                    continue;
                }
                if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
                this.sourceFileProviders.add((SourceFileProvider)new JarSourceFileProvider(file));
            }
        }
    }

    @Override
    String getExtension() {
        return ".wasm";
    }

    @Override
    TestRunStrategy createRunStrategy(File outputDir) {
        String runStrategyName = System.getProperty("teavm.junit.wasm.runner");
        return runStrategyName != null ? new BrowserRunStrategy(outputDir, "WASM_GC", BrowserRunner.pickBrowser((String)runStrategyName)) : null;
    }

    @Override
    CompileResult compile(Consumer<TeaVM> additionalProcessing, String baseName, TeaVMTestConfiguration<WasmGCTarget> configuration, File path, AnnotatedElement element) {
        SourceMapBuilder sourceMapBuilder = new SourceMapBuilder();
        File sourceMapFile = this.getOutputFile(path, baseName, configuration.getSuffix(), ".wasm.map");
        Supplier<WasmGCTarget> targetSupplier = () -> {
            WasmGCTarget target = new WasmGCTarget();
            target.setObfuscated(false);
            target.setStrict(true);
            target.setDebugInfo(true);
            target.setDebugInfoLevel(WasmDebugInfoLevel.DEOBFUSCATION);
            target.setDebugInfoLocation(WasmDebugInfoLocation.EMBEDDED);
            target.setSourceMapBuilder(sourceMapBuilder);
            target.setSourceMapLocation(this.getOutputSimpleNameFile(baseName, configuration.getSuffix(), ".wasm.map"));
            String sourceDirs = System.getProperty("teavm.junit.sourceDirs");
            if (sourceDirs != null) {
                ArrayList<File> dirs = new ArrayList<File>();
                StringTokenizer tokenizer = new StringTokenizer(sourceDirs, Character.toString(File.pathSeparatorChar));
                while (tokenizer.hasMoreTokens()) {
                    File dir = new File(tokenizer.nextToken());
                    if (!dir.isDirectory()) continue;
                    dirs.add(dir);
                }
            }
            return target;
        };
        CompilePostProcessor postBuild = (vm, file) -> {
            DefaultSourceFileResolver resolver = new DefaultSourceFileResolver(new File(path, "src"), this.sourceFileProviders);
            resolver.setSourceFilePolicy(TeaVMSourceFilePolicy.LINK_LOCAL_FILES);
            sourceMapBuilder.addSourceResolver((SourceFileResolver)resolver);
            try {
                resolver.open();
                try (OutputStreamWriter sourceMapOut = new OutputStreamWriter((OutputStream)new FileOutputStream(sourceMapFile), StandardCharsets.UTF_8);){
                    sourceMapBuilder.writeSourceMap((Writer)sourceMapOut);
                }
                resolver.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return this.compile(configuration, targetSupplier, TestWasmGCEntryPoint.class.getName(), path, ".wasm", postBuild, additionalProcessing, baseName);
    }

    @Override
    TestPlatform getPlatform() {
        return TestPlatform.WEBASSEMBLY_GC;
    }

    @Override
    String getPath() {
        return "wasm-gc";
    }

    @Override
    boolean isEnabled() {
        return Boolean.getBoolean("teavm.junit.wasm-gc");
    }

    @Override
    List<TeaVMTestConfiguration<WasmGCTarget>> getConfigurations() {
        ArrayList<TeaVMTestConfiguration<WasmGCTarget>> configurations = new ArrayList<TeaVMTestConfiguration<WasmGCTarget>>();
        configurations.add(TeaVMTestConfiguration.WASM_GC_DEFAULT);
        if (Boolean.getBoolean("teavm.junit.optimized")) {
            configurations.add(TeaVMTestConfiguration.WASM_GC_OPTIMIZED);
        }
        return configurations;
    }

    @Override
    boolean usesFileName() {
        return true;
    }

    @Override
    void additionalOutput(File outputPath, File outputPathForMethod, TeaVMTestConfiguration<?> configuration, MethodReference reference) {
        this.htmlOutput(outputPath, outputPathForMethod, configuration, reference, "teavm-run-test-wasm-gc.html");
        File testPath = this.getOutputFile(outputPath, "classTest", configuration.getSuffix(), this.getExtension() + "-runtime.js");
        File testDeobfuscatorPath = this.getOutputFile(outputPath, "classTest", configuration.getSuffix(), this.getExtension() + "-deobfuscator.wasm");
        try {
            TestUtil.resourceToFile("org/teavm/backend/wasm/wasm-gc-runtime.js", testPath, Map.of());
            TestUtil.resourceToFile("org/teavm/backend/wasm/deobfuscator.wasm", testDeobfuscatorPath, Map.of());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.disassembly) {
            this.writeDisassembly(outputPath, "classTest", configuration);
        }
    }

    @Override
    void additionalSingleTestOutput(File outputPathForMethod, TeaVMTestConfiguration<?> configuration, MethodReference reference) {
        this.htmlSingleTestOutput(outputPathForMethod, configuration, "teavm-run-test-wasm-gc.html");
        File testPath = this.getOutputFile(outputPathForMethod, "test", configuration.getSuffix(), this.getExtension() + "-runtime.js");
        File testDeobfuscatorPath = this.getOutputFile(outputPathForMethod, "test", configuration.getSuffix(), this.getExtension() + "-deobfuscator.wasm");
        try {
            TestUtil.resourceToFile("org/teavm/backend/wasm/wasm-gc-runtime.js", testPath, Map.of());
            TestUtil.resourceToFile("org/teavm/backend/wasm/deobfuscator.wasm", testDeobfuscatorPath, Map.of());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.disassembly) {
            this.writeDisassembly(outputPathForMethod, "test", configuration);
        }
    }

    private void writeDisassembly(File outputPath, String name, TeaVMTestConfiguration<?> configuration) {
        File binPath = this.getOutputFile(outputPath, name, configuration.getSuffix(), this.getExtension());
        File htmlPath = this.getOutputFile(outputPath, name, configuration.getSuffix(), ".wast.html");
        try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(htmlPath));){
            DisassemblyHTMLWriter disasmWriter = new DisassemblyHTMLWriter(new PrintWriter(writer));
            disasmWriter.setWithAddress(true);
            new Disassembler((DisassemblyWriter)disasmWriter).disassemble(Files.readAllBytes(binPath.toPath()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    void additionalOutputForAllConfigurations(File outputPath, Method method) {
        ServeJS single;
        ArrayList<ServeJS> annotations = new ArrayList<ServeJS>();
        ServeJSList list = method.getAnnotation(ServeJSList.class);
        if (list != null) {
            annotations.addAll(List.of(list.value()));
        }
        if ((single = method.getAnnotation(ServeJS.class)) != null) {
            annotations.add(single);
        }
        ClassLoader loader = WebAssemblyGCPlatformSupport.class.getClassLoader();
        for (ServeJS item : annotations) {
            File outputFile = new File(outputPath, item.as());
            try {
                InputStream input = loader.getResourceAsStream(item.from());
                try (FileOutputStream output = new FileOutputStream(outputFile);){
                    input.transferTo(output);
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

