/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.teavm.callgraph.CallGraph;
import org.teavm.dependency.DependencyAnalyzerFactory;
import org.teavm.dependency.PreciseDependencyAnalyzer;
import org.teavm.diagnostics.DefaultProblemTextConsumer;
import org.teavm.diagnostics.Problem;
import org.teavm.diagnostics.ProblemTextConsumer;
import org.teavm.junit.CompilePostProcessor;
import org.teavm.junit.CompileResult;
import org.teavm.junit.TeaVMTestConfiguration;
import org.teavm.junit.TeaVMTestRunner;
import org.teavm.junit.TestExceptionPlugin;
import org.teavm.junit.TestPlatform;
import org.teavm.junit.TestRunStrategy;
import org.teavm.junit.TestUtil;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReference;
import org.teavm.model.ReferenceCache;
import org.teavm.tooling.TeaVMProblemRenderer;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.DirectoryBuildTarget;
import org.teavm.vm.TeaVM;
import org.teavm.vm.TeaVMBuilder;
import org.teavm.vm.TeaVMTarget;
import org.teavm.vm.spi.TeaVMHost;

abstract class TestPlatformSupport<T extends TeaVMTarget> {
    private ClassHolderSource classSource;
    private ReferenceCache referenceCache;

    TestPlatformSupport(ClassHolderSource classSource, ReferenceCache referenceCache) {
        this.classSource = classSource;
        this.referenceCache = referenceCache;
    }

    abstract boolean isEnabled();

    abstract TestRunStrategy createRunStrategy(File var1);

    abstract TestPlatform getPlatform();

    abstract String getPath();

    abstract String getExtension();

    abstract List<TeaVMTestConfiguration<T>> getConfigurations();

    abstract CompileResult compile(Consumer<TeaVM> var1, String var2, TeaVMTestConfiguration<T> var3, File var4, AnnotatedElement var5);

    abstract boolean usesFileName();

    CompileResult compile(TeaVMTestConfiguration<T> configuration, Supplier<T> targetSupplier, String entryPoint, File path, String extension, CompilePostProcessor postBuild, Consumer<TeaVM> additionalProcessing, String baseName) {
        File outputFile;
        CompileResult result = new CompileResult();
        result.file = outputFile = this.getOutputFile(path, baseName, configuration.getSuffix(), extension);
        ClassLoader classLoader = TeaVMTestRunner.class.getClassLoader();
        TeaVMTarget target = (TeaVMTarget)targetSupplier.get();
        configuration.apply(target);
        DependencyAnalyzerFactory dependencyAnalyzerFactory = PreciseDependencyAnalyzer::new;
        try {
            TeaVM vm = new TeaVMBuilder(target).setClassLoader(classLoader).setClassSource((ClassReaderSource)this.classSource).setReferenceCache(this.referenceCache).setDependencyAnalyzerFactory(dependencyAnalyzerFactory).setStrict(true).build();
            configuration.apply(vm);
            additionalProcessing.accept(vm);
            vm.installPlugins();
            new TestExceptionPlugin().install((TeaVMHost)vm);
            vm.setEntryPoint(entryPoint);
            if (this.usesFileName()) {
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                vm.build((BuildTarget)new DirectoryBuildTarget(outputFile.getParentFile()), outputFile.getName());
            } else {
                outputFile.getParentFile().mkdirs();
                vm.build((BuildTarget)new DirectoryBuildTarget(outputFile), "");
            }
            if (!vm.getProblemProvider().getProblems().isEmpty()) {
                result.success = false;
                result.errorMessage = this.buildErrorMessage(vm);
            } else if (postBuild != null) {
                postBuild.process(vm, outputFile);
            }
            return result;
        }
        catch (Exception e) {
            result = new CompileResult();
            result.success = false;
            result.throwable = e;
            return result;
        }
    }

    protected final File getOutputFile(File path, String baseName, String suffix, String extension) {
        return new File(path, this.getOutputSimpleNameFile(baseName, suffix, extension));
    }

    protected final String getOutputSimpleNameFile(String baseName, String suffix, String extension) {
        StringBuilder simpleName = new StringBuilder();
        simpleName.append(baseName);
        if (!suffix.isEmpty()) {
            simpleName.append('-').append(suffix);
        }
        simpleName.append(extension);
        return simpleName.toString();
    }

    private String buildErrorMessage(TeaVM vm) {
        CallGraph cg = vm.getDependencyInfo().getCallGraph();
        DefaultProblemTextConsumer consumer = new DefaultProblemTextConsumer();
        StringBuilder sb = new StringBuilder();
        for (Problem problem : vm.getProblemProvider().getProblems()) {
            consumer.clear();
            problem.render((ProblemTextConsumer)consumer);
            sb.append(consumer.getText());
            TeaVMProblemRenderer.renderCallStack((CallGraph)cg, (CallLocation)problem.getLocation(), (StringBuilder)sb);
            sb.append("\n");
        }
        return sb.toString();
    }

    void additionalOutput(File outputPath, TeaVMTestConfiguration<?> configuration) {
    }

    void additionalOutput(File outputPath, File outputPathForMethod, TeaVMTestConfiguration<?> configuration, MethodReference reference) {
    }

    void additionalSingleTestOutput(File outputPathForMethod, TeaVMTestConfiguration<?> configuration, MethodReference reference) {
    }

    void additionalOutputForAllConfigurations(File outputPath, Method method) {
    }

    protected final void htmlOutput(File outputPath, File outputPathForMethod, TeaVMTestConfiguration<?> configuration, MethodReference reference, String template) {
        File testPath = this.getOutputFile(outputPath, "classTest", configuration.getSuffix(), this.getExtension());
        File htmlPath = this.getOutputFile(outputPathForMethod, "test", configuration.getSuffix(), ".html");
        Map<String, String> properties = Map.of("SCRIPT", "../" + testPath.getName(), "IDENTIFIER", reference.toString());
        try {
            TestUtil.resourceToFile(template, htmlPath, properties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void htmlSingleTestOutput(File outputPathForMethod, TeaVMTestConfiguration<?> configuration, String template) {
        File testPath = this.getOutputFile(outputPathForMethod, "test", configuration.getSuffix(), this.getExtension());
        File htmlPath = this.getOutputFile(outputPathForMethod, "test", configuration.getSuffix(), ".html");
        Map<String, String> properties = Map.of("SCRIPT", testPath.getName(), "IDENTIFIER", "");
        try {
            TestUtil.resourceToFile(template, htmlPath, properties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

