/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.teavm.backend.wasm.WasmRuntimeType;
import org.teavm.backend.wasm.WasmTarget;
import org.teavm.backend.wasm.disasm.Disassembler;
import org.teavm.backend.wasm.disasm.DisassemblyHTMLWriter;
import org.teavm.backend.wasm.disasm.DisassemblyWriter;
import org.teavm.browserrunner.BrowserRunner;
import org.teavm.junit.BaseWebAssemblyPlatformSupport;
import org.teavm.junit.BrowserRunStrategy;
import org.teavm.junit.TeaVMTestConfiguration;
import org.teavm.junit.TestPlatform;
import org.teavm.junit.TestRunStrategy;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.MethodReference;
import org.teavm.model.ReferenceCache;

class WebAssemblyPlatformSupport
extends BaseWebAssemblyPlatformSupport {
    private boolean disassembly;

    WebAssemblyPlatformSupport(ClassHolderSource classSource, ReferenceCache referenceCache, boolean disassembly) {
        super(classSource, referenceCache);
        this.disassembly = disassembly;
    }

    @Override
    TestRunStrategy createRunStrategy(File outputDir) {
        String runStrategyName = System.getProperty("teavm.junit.wasm.runner");
        return runStrategyName != null ? new BrowserRunStrategy(outputDir, "WASM", BrowserRunner.pickBrowser((String)runStrategyName)) : null;
    }

    @Override
    protected boolean exceptionsUsed() {
        return true;
    }

    @Override
    TestPlatform getPlatform() {
        return TestPlatform.WEBASSEMBLY;
    }

    @Override
    String getPath() {
        return "wasm";
    }

    @Override
    boolean isEnabled() {
        return Boolean.getBoolean("teavm.junit.wasm");
    }

    @Override
    List<TeaVMTestConfiguration<WasmTarget>> getConfigurations() {
        ArrayList<TeaVMTestConfiguration<WasmTarget>> configurations = new ArrayList<TeaVMTestConfiguration<WasmTarget>>();
        configurations.add(TeaVMTestConfiguration.WASM_DEFAULT);
        if (Boolean.getBoolean("teavm.junit.optimized")) {
            configurations.add(TeaVMTestConfiguration.WASM_OPTIMIZED);
        }
        return configurations;
    }

    @Override
    protected WasmRuntimeType getRuntimeType() {
        return WasmRuntimeType.TEAVM;
    }

    @Override
    void additionalOutput(File outputPath, File outputPathForMethod, TeaVMTestConfiguration<?> configuration, MethodReference reference) {
        this.htmlOutput(outputPath, outputPathForMethod, configuration, reference, "teavm-run-test-wasm.html");
    }

    @Override
    void additionalOutput(File outputPath, TeaVMTestConfiguration<?> configuration) {
        if (this.disassembly) {
            this.writeDisassembly(outputPath, "classTest", configuration);
        }
    }

    @Override
    void additionalSingleTestOutput(File outputPathForMethod, TeaVMTestConfiguration<?> configuration, MethodReference reference) {
        this.htmlSingleTestOutput(outputPathForMethod, configuration, "teavm-run-test-wasm.html");
        if (this.disassembly) {
            this.writeDisassembly(outputPathForMethod, "test", configuration);
        }
    }

    private void writeDisassembly(File outputPath, String name, TeaVMTestConfiguration<?> configuration) {
        File binPath = this.getOutputFile(outputPath, name, configuration.getSuffix(), this.getExtension());
        File htmlPath = this.getOutputFile(outputPath, name, configuration.getSuffix(), ".wast.html");
        try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(htmlPath));){
            DisassemblyHTMLWriter disasmWriter = new DisassemblyHTMLWriter(new PrintWriter(writer));
            disasmWriter.setWithAddress(true);
            new Disassembler((DisassemblyWriter)disasmWriter).disassemble(Files.readAllBytes(binPath.toPath()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

