/*
 *  Copyright 2016 Alexey Andreev.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.teavm.metaprogramming.impl;

import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.CallLocation;
import org.teavm.model.Variable;

class TopLevelVariableContext extends VariableContext {
    private Diagnostics diagnostics;

    TopLevelVariableContext(Diagnostics diagnostics) {
        super(null);
        this.diagnostics = diagnostics;
    }

    @Override
    public Variable emitVariable(ValueImpl<?> value, CallLocation location) {
        if (value.context != this) {
            diagnostics.error(location, "Can't get variable from another context");
        }
        return value.innerValue;
    }
}
