/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.util.HashSet;
import java.util.Set;
import org.teavm.backend.javascript.spi.GeneratedBy;
import org.teavm.interop.NoGcRoot;
import org.teavm.interop.NoSideEffects;
import org.teavm.model.AccessLevel;
import org.teavm.model.AnnotationContainer;
import org.teavm.model.AnnotationContainerReader;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.model.util.ModelUtils;
import org.teavm.platform.plugin.MetadataProviderNativeGenerator;
import org.teavm.platform.plugin.MetadataProviderRef;

class MetadataProviderTransformer
implements ClassHolderTransformer {
    private Set<MethodReference> metadataMethods = new HashSet<MethodReference>();

    MetadataProviderTransformer() {
    }

    void addMetadataMethod(MethodReference method) {
        this.metadataMethods.add(method);
    }

    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        int index = 0;
        for (MethodHolder method : cls.getMethods().toArray(new MethodHolder[0])) {
            if (!this.metadataMethods.contains(method.getReference())) continue;
            this.transformMetadataMethod(cls, method, context.getHierarchy(), index++);
        }
    }

    private void transformMetadataMethod(ClassHolder cls, MethodHolder method, ClassHierarchy hierarchy, int suffix) {
        FieldHolder field = new FieldHolder("$$metadata$$" + suffix);
        field.setType(method.getResultType());
        field.setLevel(AccessLevel.PRIVATE);
        field.getModifiers().add(ElementModifier.STATIC);
        field.getAnnotations().add(new AnnotationHolder(NoGcRoot.class.getName()));
        cls.addField(field);
        MethodHolder createMethod = new MethodHolder(method.getName() + "$$create", method.getSignature());
        createMethod.setLevel(AccessLevel.PRIVATE);
        createMethod.getModifiers().add(ElementModifier.NATIVE);
        createMethod.getModifiers().add(ElementModifier.STATIC);
        cls.addMethod(createMethod);
        AnnotationHolder genAnnot = new AnnotationHolder(GeneratedBy.class.getName());
        genAnnot.getValues().put("value", new AnnotationValue((ValueType)ValueType.object((String)MetadataProviderNativeGenerator.class.getName())));
        createMethod.getAnnotations().add(genAnnot);
        ModelUtils.copyAnnotations((AnnotationContainerReader)method.getAnnotations(), (AnnotationContainer)createMethod.getAnnotations());
        if (createMethod.getAnnotations().get(NoSideEffects.class.getName()) == null) {
            createMethod.getAnnotations().add(new AnnotationHolder(NoSideEffects.class.getName()));
        }
        AnnotationHolder refAnnot = new AnnotationHolder(MetadataProviderRef.class.getName());
        refAnnot.getValues().put("value", new AnnotationValue(method.getReference().toString()));
        createMethod.getAnnotations().add(refAnnot);
        method.getModifiers().remove(ElementModifier.NATIVE);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)hierarchy);
        pe.when(pe.getField(field.getReference(), field.getType()).isNull()).thenDo(() -> pe.setField(field.getReference(), pe.invoke(createMethod.getReference().getClassName(), createMethod.getReference().getName(), createMethod.getResultType(), new ValueEmitter[0])));
        pe.getField(field.getReference(), field.getType()).returnValue();
    }
}

