/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.platform.Platform;

public class ClassLookupDependencySupport
extends AbstractDependencyListener {
    private DependencyNode allClasses;

    public void started(DependencyAgent agent) {
        this.allClasses = agent.createNode();
    }

    public void classReached(DependencyAgent agent, String className, CallLocation location) {
        this.allClasses.propagate(agent.getType(className));
    }

    public void methodReached(DependencyAgent agent, MethodDependency method, CallLocation location) {
        MethodReference ref = method.getReference();
        if (ref.getClassName().equals(Platform.class.getName()) && ref.getName().equals("lookupClass")) {
            this.allClasses.addConsumer(type -> {
                ClassReader cls = agent.getClassSource().get(type.getName());
                if (cls == null) {
                    return;
                }
                MethodReader initMethod = cls.getMethod(new MethodDescriptor("<clinit>", new Class[]{Void.TYPE}));
                if (initMethod != null) {
                    agent.linkMethod(initMethod.getReference(), location).use();
                }
            });
        }
    }
}

