/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceArray;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.plugin.ResourceAccessor;

class ResourceProgramTransformer {
    private ClassReaderSource innerSource;
    private Program program;

    public ResourceProgramTransformer(ClassReaderSource innerSource, Program program) {
        this.innerSource = innerSource;
        this.program = program;
    }

    public void transformProgram() {
        for (int i = 0; i < this.program.basicBlockCount(); ++i) {
            this.transformBasicBlock(this.program.basicBlockAt(i));
        }
    }

    private void transformBasicBlock(BasicBlock block) {
        for (Instruction insn : block) {
            InvokeInstruction invoke;
            List<Instruction> replacement;
            if (!(insn instanceof InvokeInstruction) || (replacement = this.transformInvoke(invoke = (InvokeInstruction)insn)) == null) continue;
            insn.insertNextAll(replacement);
            insn.delete();
        }
    }

    private List<Instruction> transformInvoke(InvokeInstruction insn) {
        if (insn.getType() != InvocationType.VIRTUAL) {
            return null;
        }
        MethodReference method = insn.getMethod();
        if (method.getClassName().equals(ResourceArray.class.getName()) || method.getClassName().equals(ResourceMap.class.getName())) {
            if (method.getName().equals("keys")) {
                return this.transformKeys(insn);
            }
            InvokeInstruction accessInsn = new InvokeInstruction();
            accessInsn.setType(InvocationType.SPECIAL);
            ValueType[] types = new ValueType[method.getDescriptor().parameterCount() + 2];
            types[0] = ValueType.object((String)"java.lang.Object");
            System.arraycopy(method.getDescriptor().getSignature(), 0, types, 1, method.getDescriptor().parameterCount() + 1);
            accessInsn.setMethod(new MethodReference(ResourceAccessor.class.getName(), method.getName(), types));
            accessInsn.getArguments().add(insn.getInstance());
            accessInsn.getArguments().addAll(insn.getArguments());
            accessInsn.setReceiver(insn.getReceiver());
            return Arrays.asList(accessInsn);
        }
        ClassReader iface = this.innerSource.get(method.getClassName());
        if (iface == null || !this.innerSource.isSuperType(Resource.class.getName(), iface.getName()).orElse(false).booleanValue()) {
            return null;
        }
        if (method.getName().startsWith("get")) {
            if (method.getName().length() > 3) {
                return this.transformGetterInvocation(insn, this.getPropertyName(method.getName().substring(3)));
            }
        } else if (method.getName().startsWith("is")) {
            if (method.getName().length() > 2) {
                return this.transformGetterInvocation(insn, this.getPropertyName(method.getName().substring(2)));
            }
        } else if (method.getName().startsWith("set") && method.getName().length() > 3) {
            return this.transformSetterInvocation(insn, this.getPropertyName(method.getName().substring(3)));
        }
        return null;
    }

    private List<Instruction> transformKeys(InvokeInstruction insn) {
        Variable tmp = this.program.createVariable();
        InvokeInstruction keysInsn = new InvokeInstruction();
        keysInsn.setType(InvocationType.SPECIAL);
        keysInsn.setMethod(new MethodReference(ResourceAccessor.class, "keys", new Class[]{Object.class, Object.class}));
        keysInsn.getArguments().add(insn.getInstance());
        keysInsn.setReceiver(tmp);
        InvokeInstruction transformInsn = new InvokeInstruction();
        transformInsn.setType(InvocationType.SPECIAL);
        transformInsn.setMethod(new MethodReference(ResourceAccessor.class, "keysToStrings", new Class[]{Object.class, String[].class}));
        transformInsn.getArguments().add(tmp);
        transformInsn.setReceiver(insn.getReceiver());
        return Arrays.asList(keysInsn, transformInsn);
    }

    private List<Instruction> transformGetterInvocation(InvokeInstruction insn, String property) {
        if (insn.getReceiver() == null) {
            return Collections.emptyList();
        }
        ValueType type = insn.getMethod().getDescriptor().getResultType();
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    this.getAndCastProperty(insn, property, instructions, Boolean.TYPE);
                    return instructions;
                }
                case BYTE: {
                    this.getAndCastProperty(insn, property, instructions, Byte.TYPE);
                    return instructions;
                }
                case SHORT: {
                    this.getAndCastProperty(insn, property, instructions, Short.TYPE);
                    return instructions;
                }
                case INTEGER: {
                    this.getAndCastProperty(insn, property, instructions, Integer.TYPE);
                    return instructions;
                }
                case FLOAT: {
                    this.getAndCastProperty(insn, property, instructions, Float.TYPE);
                    return instructions;
                }
                case DOUBLE: {
                    this.getAndCastProperty(insn, property, instructions, Double.TYPE);
                    return instructions;
                }
            }
        } else if (type instanceof ValueType.Object) {
            switch (((ValueType.Object)type).getClassName()) {
                case "java.lang.String": {
                    Variable resultVar = insn.getProgram().createVariable();
                    this.getProperty(insn, property, instructions, resultVar);
                    InvokeInstruction castInvoke = new InvokeInstruction();
                    castInvoke.setType(InvocationType.SPECIAL);
                    castInvoke.setMethod(new MethodReference(ResourceAccessor.class, "castToString", new Class[]{Object.class, String.class}));
                    castInvoke.getArguments().add(resultVar);
                    castInvoke.setReceiver(insn.getReceiver());
                    instructions.add((Instruction)castInvoke);
                    return instructions;
                }
            }
            Variable resultVar = insn.getProgram().createVariable();
            this.getProperty(insn, property, instructions, resultVar);
            CastInstruction castInsn = new CastInstruction();
            castInsn.setReceiver(insn.getReceiver());
            castInsn.setTargetType(type);
            castInsn.setValue(resultVar);
            instructions.add((Instruction)castInsn);
            return instructions;
        }
        return null;
    }

    private void getProperty(InvokeInstruction insn, String property, List<Instruction> instructions, Variable resultVar) {
        Variable nameVar = this.program.createVariable();
        StringConstantInstruction nameInsn = new StringConstantInstruction();
        nameInsn.setConstant(property);
        nameInsn.setReceiver(nameVar);
        instructions.add((Instruction)nameInsn);
        InvokeInstruction accessorInvoke = new InvokeInstruction();
        accessorInvoke.setType(InvocationType.SPECIAL);
        accessorInvoke.setMethod(new MethodReference(ResourceAccessor.class, "getProperty", new Class[]{Object.class, String.class, Object.class}));
        accessorInvoke.getArguments().add(insn.getInstance());
        accessorInvoke.getArguments().add(nameVar);
        accessorInvoke.setReceiver(resultVar);
        instructions.add((Instruction)accessorInvoke);
    }

    private void getAndCastProperty(InvokeInstruction insn, String property, List<Instruction> instructions, Class<?> primitive) {
        Variable resultVar = this.program.createVariable();
        this.getProperty(insn, property, instructions, resultVar);
        InvokeInstruction castInvoke = new InvokeInstruction();
        castInvoke.setType(InvocationType.SPECIAL);
        String primitiveCapitalized = primitive.getName();
        primitiveCapitalized = Character.toUpperCase(primitiveCapitalized.charAt(0)) + primitiveCapitalized.substring(1);
        castInvoke.setMethod(new MethodReference(ResourceAccessor.class, "castTo" + primitiveCapitalized, new Class[]{Object.class, primitive}));
        castInvoke.getArguments().add(resultVar);
        castInvoke.setReceiver(insn.getReceiver());
        instructions.add((Instruction)castInvoke);
    }

    private List<Instruction> transformSetterInvocation(InvokeInstruction insn, String property) {
        ValueType type = insn.getMethod().getDescriptor().parameterType(0);
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    this.castAndSetProperty(insn, property, instructions, Boolean.TYPE);
                    return instructions;
                }
                case BYTE: {
                    this.castAndSetProperty(insn, property, instructions, Byte.TYPE);
                    return instructions;
                }
                case SHORT: {
                    this.castAndSetProperty(insn, property, instructions, Short.TYPE);
                    return instructions;
                }
                case INTEGER: {
                    this.castAndSetProperty(insn, property, instructions, Integer.TYPE);
                    return instructions;
                }
                case FLOAT: {
                    this.castAndSetProperty(insn, property, instructions, Float.TYPE);
                    return instructions;
                }
                case DOUBLE: {
                    this.castAndSetProperty(insn, property, instructions, Double.TYPE);
                    return instructions;
                }
            }
        } else if (type instanceof ValueType.Object) {
            switch (((ValueType.Object)type).getClassName()) {
                case "java.lang.String": {
                    Variable castVar = insn.getProgram().createVariable();
                    InvokeInstruction castInvoke = new InvokeInstruction();
                    castInvoke.setType(InvocationType.SPECIAL);
                    castInvoke.setMethod(new MethodReference(ResourceAccessor.class, "castFromString", new Class[]{String.class, Object.class}));
                    castInvoke.getArguments().add(insn.getArguments().get(0));
                    castInvoke.setReceiver(castVar);
                    instructions.add((Instruction)castInvoke);
                    this.setProperty(insn, property, instructions, castVar);
                    return instructions;
                }
            }
            this.setProperty(insn, property, instructions, (Variable)insn.getArguments().get(0));
            return instructions;
        }
        return null;
    }

    private void setProperty(InvokeInstruction insn, String property, List<Instruction> instructions, Variable valueVar) {
        Variable nameVar = this.program.createVariable();
        StringConstantInstruction nameInsn = new StringConstantInstruction();
        nameInsn.setConstant(property);
        nameInsn.setReceiver(nameVar);
        instructions.add((Instruction)nameInsn);
        InvokeInstruction accessorInvoke = new InvokeInstruction();
        accessorInvoke.setType(InvocationType.SPECIAL);
        accessorInvoke.setMethod(new MethodReference(ResourceAccessor.class, "put", new Class[]{Object.class, String.class, Object.class, Void.TYPE}));
        accessorInvoke.getArguments().add(insn.getInstance());
        accessorInvoke.getArguments().add(nameVar);
        accessorInvoke.getArguments().add(valueVar);
        instructions.add((Instruction)accessorInvoke);
    }

    private void castAndSetProperty(InvokeInstruction insn, String property, List<Instruction> instructions, Class<?> primitive) {
        Variable castVar = this.program.createVariable();
        InvokeInstruction castInvoke = new InvokeInstruction();
        castInvoke.setType(InvocationType.SPECIAL);
        String primitiveCapitalized = primitive.getName();
        primitiveCapitalized = Character.toUpperCase(primitiveCapitalized.charAt(0)) + primitiveCapitalized.substring(1);
        castInvoke.setMethod(new MethodReference(ResourceAccessor.class, "castFrom" + primitiveCapitalized, new Class[]{primitive, Object.class}));
        castInvoke.getArguments().add(insn.getArguments().get(0));
        castInvoke.setReceiver(castVar);
        instructions.add((Instruction)castInvoke);
        this.setProperty(insn, property, instructions, castVar);
    }

    private String getPropertyName(String name) {
        if (name.length() == 1) {
            return name.toLowerCase();
        }
        if (Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }
}

