/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import java.util.Arrays;
import org.teavm.hppc.ByteCollection;
import org.teavm.hppc.ByteLookupContainer;
import org.teavm.hppc.cursors.ByteCursor;
import org.teavm.hppc.predicates.BytePredicate;

abstract class AbstractByteCollection
implements ByteCollection {
    AbstractByteCollection() {
    }

    @Override
    public int removeAll(ByteLookupContainer c) {
        return this.removeAll(c::contains);
    }

    @Override
    public int retainAll(ByteLookupContainer c) {
        return this.removeAll((byte k) -> !c.contains(k));
    }

    @Override
    public int retainAll(BytePredicate predicate) {
        return this.removeAll((byte value) -> !predicate.apply(value));
    }

    @Override
    public byte[] toArray() {
        byte[] array = new byte[this.size()];
        int i = 0;
        for (ByteCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

