/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.IntBinaryOperator;
import org.teavm.hppc.AbstractIterator;
import org.teavm.hppc.AbstractObjectCollection;
import org.teavm.hppc.AbstractShortCollection;
import org.teavm.hppc.ObjectContainer;
import org.teavm.hppc.ShortCollection;
import org.teavm.hppc.ShortContainer;
import org.teavm.hppc.ShortLookupContainer;
import org.teavm.hppc.ShortObjectAssociativeContainer;
import org.teavm.hppc.ShortObjectHashMap;
import org.teavm.hppc.ShortObjectMap;
import org.teavm.hppc.comparators.ShortComparator;
import org.teavm.hppc.comparators.ShortObjectComparator;
import org.teavm.hppc.cursors.ObjectCursor;
import org.teavm.hppc.cursors.ShortCursor;
import org.teavm.hppc.cursors.ShortObjectCursor;
import org.teavm.hppc.predicates.ObjectPredicate;
import org.teavm.hppc.predicates.ShortObjectPredicate;
import org.teavm.hppc.predicates.ShortPredicate;
import org.teavm.hppc.procedures.ObjectProcedure;
import org.teavm.hppc.procedures.ShortObjectProcedure;
import org.teavm.hppc.procedures.ShortProcedure;
import org.teavm.hppc.sorting.QuickSort;

public class SortedIterationShortObjectHashMap<VType>
implements ShortObjectMap<VType> {
    public final ShortObjectHashMap<VType> delegate;
    public final int[] iterationOrder;

    public SortedIterationShortObjectHashMap(ShortObjectHashMap<VType> delegate, ShortComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationShortObjectHashMap(ShortObjectHashMap<VType> delegate, ShortObjectComparator<VType> comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        short[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != 0) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, ShortComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            short[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final ShortObjectComparator<VType> comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final short[] keys;
            final VType[] values;
            {
                this.keys = SortedIterationShortObjectHashMap.this.delegate.keys;
                this.values = SortedIterationShortObjectHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<ShortObjectCursor<VType>> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(short key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(ShortContainer container) {
        throw SortedIterationShortObjectHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        throw SortedIterationShortObjectHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ShortObjectPredicate<? super VType> predicate) {
        throw SortedIterationShortObjectHashMap.readOnlyException();
    }

    @Override
    public <T extends ShortObjectProcedure<? super VType>> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        short[] keys = this.delegate.keys;
        Object[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], (Object)values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ShortObjectPredicate<? super VType>> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        short[] keys = this.delegate.keys;
        Object[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], (Object)values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public ShortCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public ObjectContainer<VType> values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public VType get(short key) {
        return this.delegate.get(key);
    }

    @Override
    public VType getOrDefault(short key, VType defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public VType put(short key, VType value) {
        throw SortedIterationShortObjectHashMap.readOnlyException();
    }

    @Override
    public int putAll(ShortObjectAssociativeContainer<? extends VType> container) {
        throw SortedIterationShortObjectHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends ShortObjectCursor<? extends VType>> iterable) {
        throw SortedIterationShortObjectHashMap.readOnlyException();
    }

    @Override
    public VType remove(short key) {
        throw SortedIterationShortObjectHashMap.readOnlyException();
    }

    @Override
    public int indexOf(short key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public VType indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public VType indexReplace(int index, VType newValue) {
        throw SortedIterationShortObjectHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, short key, VType value) {
        throw SortedIterationShortObjectHashMap.readOnlyException();
    }

    @Override
    public VType indexRemove(int index) {
        throw SortedIterationShortObjectHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationShortObjectHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationShortObjectHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<ShortObjectCursor<VType>> {
        private final ShortObjectCursor<VType> cursor = new ShortObjectCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected ShortObjectCursor<VType> fetch() {
            if (this.index < SortedIterationShortObjectHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortObjectHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationShortObjectHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationShortObjectHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ShortObjectCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final SortedIterationShortObjectHashMap<VType> owner;

        private KeysContainer() {
            this.owner = SortedIterationShortObjectHashMap.this;
        }

        @Override
        public boolean contains(short e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationShortObjectHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationShortObjectHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            throw SortedIterationShortObjectHashMap.readOnlyException();
        }

        @Override
        public int removeAll(short e) {
            throw SortedIterationShortObjectHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractObjectCollection<VType> {
        private final SortedIterationShortObjectHashMap<VType> owner;

        private ValuesContainer() {
            this.owner = SortedIterationShortObjectHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(VType value) {
            for (ShortObjectCursor c : this.owner) {
                if (!Objects.equals(value, c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(VType e) {
            throw SortedIterationShortObjectHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ObjectPredicate<? super VType> predicate) {
            throw SortedIterationShortObjectHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationShortObjectHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationShortObjectHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor = new ObjectCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            if (this.index < SortedIterationShortObjectHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortObjectHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationShortObjectHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected ShortCursor fetch() {
            if (this.index < SortedIterationShortObjectHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortObjectHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationShortObjectHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }
}

