/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.teavm.hppc.AbstractIterator;
import org.teavm.hppc.AbstractObjectCollection;
import org.teavm.hppc.Accountable;
import org.teavm.hppc.BitMixer;
import org.teavm.hppc.BitUtil;
import org.teavm.hppc.BufferAllocationException;
import org.teavm.hppc.HashContainers;
import org.teavm.hppc.ObjectBufferVisualizer;
import org.teavm.hppc.ObjectContainer;
import org.teavm.hppc.ObjectLookupContainer;
import org.teavm.hppc.ObjectSet;
import org.teavm.hppc.Preallocable;
import org.teavm.hppc.RamUsageEstimator;
import org.teavm.hppc.WormUtil;
import org.teavm.hppc.cursors.ObjectCursor;
import org.teavm.hppc.predicates.ObjectPredicate;
import org.teavm.hppc.procedures.ObjectProcedure;

public class ObjectWormSet<KType>
extends AbstractObjectCollection<KType>
implements ObjectLookupContainer<KType>,
ObjectSet<KType>,
Preallocable,
Cloneable,
Accountable {
    public Object[] keys;
    public byte[] next;
    protected int size;
    protected int iterationSeed;

    public ObjectWormSet() {
        this(4);
    }

    public ObjectWormSet(int expectedElements) {
        if (expectedElements < 0) {
            throw new IllegalArgumentException("Invalid expectedElements=" + expectedElements);
        }
        this.iterationSeed = HashContainers.nextIterationSeed();
        this.ensureCapacity(expectedElements);
    }

    public ObjectWormSet(ObjectContainer<? extends KType> container) {
        this(container.size());
        this.addAll(container);
    }

    @SafeVarargs
    public static <KType> ObjectWormSet<KType> from(KType ... elements) {
        ObjectWormSet<KType> set = new ObjectWormSet<KType>(elements.length);
        set.addAll(elements);
        return set;
    }

    public ObjectWormSet<KType> clone() {
        try {
            ObjectWormSet cloneSet = (ObjectWormSet)super.clone();
            cloneSet.keys = (Object[])this.keys.clone();
            cloneSet.next = (byte[])this.next.clone();
            cloneSet.iterationSeed = HashContainers.nextIterationSeed();
            return cloneSet;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(KType key) {
        int hashIndex = this.hashMod(key);
        byte nextOffset = this.next[hashIndex];
        if (nextOffset <= 0) {
            return false;
        }
        return this.searchInChain(key, hashIndex, nextOffset) >= 0;
    }

    @Override
    public boolean add(KType key) {
        return this.add(key, false, true);
    }

    @SafeVarargs
    public final int addAll(KType ... elements) {
        this.ensureCapacity(elements.length);
        int count = 0;
        for (KType e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int addAll(ObjectContainer<? extends KType> container) {
        this.ensureCapacity(container.size());
        return this.addAll((Iterable<? extends ObjectCursor<? extends KType>>)container);
    }

    @Override
    public int addAll(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int count = 0;
        for (ObjectCursor<KType> objectCursor : iterable) {
            if (!this.add(objectCursor.value)) continue;
            ++count;
        }
        return count;
    }

    public boolean remove(KType key) {
        byte[] next = this.next;
        int hashIndex = this.hashMod(key);
        byte nextOffset = next[hashIndex];
        if (nextOffset <= 0) {
            return false;
        }
        int previousEntryIndex = this.searchInChainReturnPrevious(key, hashIndex, nextOffset);
        if (previousEntryIndex < 0) {
            return false;
        }
        int entryToRemoveIndex = previousEntryIndex == Integer.MAX_VALUE ? hashIndex : WormUtil.addOffset(previousEntryIndex, Math.abs(next[previousEntryIndex]), next.length);
        this.remove(entryToRemoveIndex, previousEntryIndex);
        return true;
    }

    @Override
    public int removeAll(KType key) {
        return this.remove(key) ? 1 : 0;
    }

    @Override
    public int removeAll(ObjectContainer<? super KType> other) {
        int size = this.size();
        if (other.size() >= size && other instanceof ObjectLookupContainer) {
            Object[] keys = this.keys;
            byte[] byArray = this.next;
            int capacity = byArray.length;
            int entryIndex = 0;
            while (entryIndex < capacity) {
                Object key;
                if (byArray[entryIndex] != 0 && other.contains(key = keys[entryIndex])) {
                    this.remove(key);
                    continue;
                }
                ++entryIndex;
            }
        } else {
            for (ObjectCursor<Object> objectCursor : other) {
                this.remove(objectCursor.value);
            }
        }
        return size - this.size();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        Object[] keys = this.keys;
        byte[] next = this.next;
        int capacity = next.length;
        int size = this.size();
        int entryIndex = 0;
        while (entryIndex < capacity) {
            Object key;
            if (next[entryIndex] != 0 && predicate.apply(key = keys[entryIndex])) {
                this.remove(key);
                continue;
            }
            ++entryIndex;
        }
        return size - this.size();
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
        Object[] keys = this.keys;
        byte[] next = this.next;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = next.length - 1;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            if (next[slot] != 0) {
                procedure.apply((Object)keys[slot]);
            }
            slot = slot + inc & mask;
        }
        return procedure;
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
        Object[] keys = this.keys;
        byte[] next = this.next;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = next.length - 1;
        int slot = seed & mask;
        for (int i = 0; i <= mask && (next[slot] == 0 || predicate.apply((Object)keys[slot])); ++i) {
            slot = slot + inc & mask;
        }
        return predicate;
    }

    @Override
    public Iterator<ObjectCursor<KType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public void clear() {
        Arrays.fill(this.next, (byte)0);
        this.size = 0;
        Arrays.fill(this.keys, null);
    }

    @Override
    public void release() {
        this.keys = null;
        this.next = null;
        this.size = 0;
        this.ensureCapacity(4);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        int size = this.size;
        ObjectSet set = (ObjectSet)o;
        if (size != set.size()) {
            return false;
        }
        Object[] keys = this.keys;
        byte[] next = this.next;
        int index = 0;
        int entryCount = 0;
        while (entryCount < size) {
            if (next[index] != 0) {
                if (!set.contains(keys[index])) {
                    return false;
                }
                ++entryCount;
            }
            ++index;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        int size = this.size;
        int index = 0;
        int entryCount = 0;
        while (entryCount < size) {
            if (this.next[index] != 0) {
                hashCode += BitMixer.mixPhi(this.keys[index]);
                ++entryCount;
            }
            ++index;
        }
        return hashCode;
    }

    protected int hashKey(KType key) {
        return BitMixer.mixPhi(key);
    }

    private int hashMod(KType key) {
        return this.hashKey(key) & this.next.length - 1;
    }

    public int indexOf(KType key) {
        int hashIndex = this.hashMod(key);
        byte nextOffset = this.next[hashIndex];
        if (nextOffset <= 0) {
            return ~hashIndex;
        }
        return this.searchInChain(key, hashIndex, nextOffset);
    }

    public boolean indexExists(int index) {
        assert (index < this.next.length);
        return index >= 0;
    }

    public KType indexGet(int index) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (this.next[index] != 0);
        return (KType)this.keys[index];
    }

    public KType indexReplace(int index, KType equivalentKey) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (this.next[index] != 0);
        assert (this.equals(this.keys[index], equivalentKey));
        Object previousKey = this.keys[index];
        this.keys[index] = equivalentKey;
        return (KType)previousKey;
    }

    public void indexInsert(int index, KType key) {
        assert (index < 0) : "The index must not point at an existing key.";
        if (this.next[index ^= 0xFFFFFFFF] == 0) {
            this.keys[index] = key;
            this.next[index] = 127;
            ++this.size;
        } else {
            this.add(key, true, true);
        }
    }

    public void indexRemove(int index) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (this.next[index] != 0);
        this.remove(index, Integer.MAX_VALUE);
    }

    @Override
    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append('[');
        int index = 0;
        int entryCount = 0;
        while (entryCount < this.size) {
            if (this.next[index] != 0) {
                if (entryCount > 0) {
                    sBuilder.append(", ");
                }
                sBuilder.append(this.keys[index]);
                ++entryCount;
            }
            ++index;
        }
        sBuilder.append(']');
        return sBuilder.toString();
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        this.allocateBuffers((int)((float)expectedElements / 0.75f));
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return ObjectBufferVisualizer.visualizeKeyDistribution(this.keys, this.next.length - 1, characters);
    }

    @Override
    public long ramBytesAllocated() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8) + RamUsageEstimator.shallowSizeOfArray(this.keys) + RamUsageEstimator.shallowSizeOfArray(this.next);
    }

    @Override
    public long ramBytesUsed() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8) + RamUsageEstimator.shallowUsedSizeOfArray(this.keys, this.size()) + RamUsageEstimator.shallowUsedSizeOfArray(this.next, this.size());
    }

    protected void allocateBuffers(int capacity) {
        capacity = Math.max(capacity, this.size);
        if ((capacity = Math.max(BitUtil.nextHighestPowerOfTwo(capacity), 4)) > 0x40000000) {
            throw new BufferAllocationException("Maximum array size exceeded (capacity: %d)", capacity);
        }
        if (this.keys != null && this.keys.length == capacity) {
            return;
        }
        Object[] oldKeys = this.keys;
        byte[] oldNext = this.next;
        this.keys = new Object[capacity];
        this.next = new byte[capacity];
        if (oldKeys != null) {
            this.putOldEntries(oldKeys, oldNext, this.size);
        }
    }

    private void putOldEntries(KType[] oldKeys, byte[] oldNext, int entryNum) {
        int entryCount = 0;
        int endIndex = oldNext.length;
        for (int index = 0; entryCount < entryNum && index < endIndex; ++index) {
            if (oldNext[index] == 0) continue;
            KType oldKey = oldKeys[index];
            int hashIndex = this.hashMod(oldKey);
            this.putNewEntry(hashIndex, this.next[hashIndex], oldKey);
            ++entryCount;
        }
    }

    private boolean add(KType key, boolean newGuaranteed, boolean sizeIncrease) {
        int hashIndex = this.hashMod(key);
        byte nextOffset = this.next[hashIndex];
        boolean added = false;
        if (nextOffset > 0 && !newGuaranteed) {
            int entryIndex = this.searchInChain(key, hashIndex, nextOffset);
            if (entryIndex >= 0) {
                return false;
            }
            if (this.enlargeIfNeeded()) {
                hashIndex = this.hashMod(key);
                nextOffset = this.next[hashIndex];
            } else {
                if (!this.appendTailOfChain(~entryIndex, key)) {
                    this.enlargeAndPutNewEntry(key);
                }
                added = true;
            }
        } else if (this.enlargeIfNeeded()) {
            hashIndex = this.hashMod(key);
            nextOffset = this.next[hashIndex];
        }
        if (!added) {
            this.putNewEntry(hashIndex, nextOffset, key);
        }
        if (sizeIncrease) {
            ++this.size;
        }
        return true;
    }

    private boolean enlargeIfNeeded() {
        if (this.size >= this.next.length) {
            this.allocateBuffers(this.next.length << 1);
            return true;
        }
        return false;
    }

    private void enlargeAndPutNewEntry(KType key) {
        this.allocateBuffers(this.next.length << 1);
        this.add(key, true, false);
    }

    private void remove(int entryToRemoveIndex, int previousEntryIndex) {
        int lastIndex;
        assert (WormUtil.checkIndex(entryToRemoveIndex, this.next.length));
        assert (previousEntryIndex == Integer.MAX_VALUE || WormUtil.checkIndex(previousEntryIndex, this.next.length));
        byte[] next = this.next;
        byte nextOffset = next[entryToRemoveIndex];
        int beforeLastIndex = WormUtil.findLastOfChain(entryToRemoveIndex, nextOffset, true, next);
        if (beforeLastIndex == -1) {
            lastIndex = entryToRemoveIndex;
            if (nextOffset < 0) {
                beforeLastIndex = previousEntryIndex == Integer.MAX_VALUE ? WormUtil.findPreviousInChain(entryToRemoveIndex, next) : previousEntryIndex;
                next[beforeLastIndex] = (byte)(next[beforeLastIndex] > 0 ? 127 : -127);
            }
        } else {
            byte beforeLastNextOffset = next[beforeLastIndex];
            lastIndex = WormUtil.addOffset(beforeLastIndex, Math.abs(beforeLastNextOffset), next.length);
            assert (entryToRemoveIndex != lastIndex);
            this.keys[entryToRemoveIndex] = this.keys[lastIndex];
            next[beforeLastIndex] = (byte)(beforeLastNextOffset > 0 ? 127 : -127);
        }
        this.keys[lastIndex] = null;
        next[lastIndex] = 0;
        --this.size;
    }

    private boolean appendTailOfChain(int lastEntryIndex, KType key) {
        return this.appendTailOfChain(lastEntryIndex, key, WormUtil.ExcludedIndexes.NONE, 0);
    }

    private boolean appendTailOfChain(int lastEntryIndex, KType key, WormUtil.ExcludedIndexes excludedIndexes, int recursiveCallLevel) {
        int capacity = this.next.length;
        int searchFromIndex = WormUtil.addOffset(lastEntryIndex, 1, capacity);
        int freeIndex = WormUtil.searchFreeBucket(searchFromIndex, WormUtil.maxOffset(capacity), -1, this.next);
        if (freeIndex == -1 && (freeIndex = this.searchAndMoveBucket(searchFromIndex, WormUtil.maxOffset(capacity), excludedIndexes, recursiveCallLevel)) == -1) {
            return false;
        }
        this.keys[freeIndex] = key;
        this.next[freeIndex] = -127;
        int nextOffset = WormUtil.getOffsetBetweenIndexes(lastEntryIndex, freeIndex, this.next.length);
        this.next[lastEntryIndex] = (byte)(this.next[lastEntryIndex] > 0 ? nextOffset : -nextOffset);
        return true;
    }

    private int searchAndMoveBucket(int fromIndex, int range, WormUtil.ExcludedIndexes excludedIndexes, int recursiveCallLevel) {
        assert (WormUtil.checkIndex(fromIndex, this.next.length));
        assert (range >= 0 && range <= WormUtil.maxOffset(this.next.length)) : "range=" + range + ", maxOffset=" + WormUtil.maxOffset(this.next.length);
        int remainingAttempts = WormUtil.RECURSIVE_MOVE_ATTEMPTS[recursiveCallLevel];
        if (remainingAttempts <= 0 || range <= 0) {
            return -1;
        }
        byte[] next = this.next;
        int capacity = next.length;
        int nextRecursiveCallLevel = recursiveCallLevel + 1;
        for (int index = fromIndex + range - 1; index >= fromIndex; --index) {
            byte nextOffset;
            int rolledIndex = index & capacity - 1;
            if (excludedIndexes.isIndexExcluded(rolledIndex) || (nextOffset = next[rolledIndex]) >= 0) continue;
            if (this.moveTailOfChain(rolledIndex, nextOffset, excludedIndexes, nextRecursiveCallLevel)) {
                return rolledIndex;
            }
            if (--remainingAttempts > 0) continue;
            return -1;
        }
        return -1;
    }

    private void putNewEntry(int hashIndex, int nextOffset, KType key) {
        assert (hashIndex == this.hashMod(key)) : "hashIndex=" + hashIndex + ", hashReduce(key)=" + this.hashMod(key);
        assert (WormUtil.checkIndex(hashIndex, this.next.length));
        assert (Math.abs(nextOffset) <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[hashIndex]) : "nextOffset=" + nextOffset + ", next[hashIndex]=" + this.next[hashIndex];
        if (nextOffset > 0) {
            if (!this.appendTailOfChain(WormUtil.findLastOfChain(hashIndex, nextOffset, false, this.next), key)) {
                this.enlargeAndPutNewEntry(key);
            }
        } else {
            if (nextOffset < 0 && !this.moveTailOfChain(hashIndex, nextOffset, WormUtil.ExcludedIndexes.NONE, 0)) {
                this.enlargeAndPutNewEntry(key);
                return;
            }
            this.keys[hashIndex] = key;
            this.next[hashIndex] = 127;
        }
    }

    private boolean moveTailOfChain(int tailIndex, int nextOffset, WormUtil.ExcludedIndexes excludedIndexes, int recursiveCallLevel) {
        boolean nextIndexWithinRange;
        int searchRange;
        int searchFromIndex;
        assert (WormUtil.checkIndex(tailIndex, this.next.length));
        assert (nextOffset < 0 && nextOffset >= -127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[tailIndex]) : "nextOffset=" + nextOffset + ", next[tailIndex]=" + this.next[tailIndex];
        byte[] next = this.next;
        int capacity = next.length;
        int maxOffset = WormUtil.maxOffset(capacity);
        int previousIndex = WormUtil.findPreviousInChain(tailIndex, next);
        int absPreviousOffset = Math.abs(next[previousIndex]);
        int nextIndex = nextOffset == -127 ? -1 : WormUtil.addOffset(tailIndex, -nextOffset, capacity);
        int offsetFromPreviousToNext = absPreviousOffset - nextOffset;
        if (offsetFromPreviousToNext <= maxOffset) {
            searchFromIndex = WormUtil.addOffset(previousIndex, 1, capacity);
            searchRange = offsetFromPreviousToNext - 1;
            nextIndexWithinRange = true;
        } else {
            if (nextIndex == -1) {
                searchFromIndex = WormUtil.addOffset(previousIndex, 1, capacity);
                searchRange = maxOffset;
            } else {
                searchFromIndex = WormUtil.addOffset(nextIndex, -maxOffset, capacity);
                int searchToIndex = WormUtil.addOffset(previousIndex, maxOffset, capacity);
                searchRange = WormUtil.getOffsetBetweenIndexes(searchFromIndex, searchToIndex, capacity) + 1;
            }
            nextIndexWithinRange = false;
        }
        int freeIndex = WormUtil.searchFreeBucket(searchFromIndex, searchRange, tailIndex, next);
        if (freeIndex == -1) {
            if (nextIndexWithinRange && this.appendTailOfChain(WormUtil.findLastOfChain(nextIndex, next[nextIndex], false, next), this.keys[tailIndex], excludedIndexes, recursiveCallLevel)) {
                int previousOffset = WormUtil.getOffsetBetweenIndexes(previousIndex, nextIndex, capacity);
                next[previousIndex] = (byte)(next[previousIndex] > 0 ? previousOffset : -previousOffset);
                return true;
            }
            WormUtil.ExcludedIndexes recursiveExcludedIndexes = excludedIndexes.union(WormUtil.ExcludedIndexes.fromChain(previousIndex, next));
            freeIndex = this.searchAndMoveBucket(searchFromIndex, searchRange, recursiveExcludedIndexes, recursiveCallLevel);
            if (freeIndex == -1) {
                return false;
            }
        }
        this.keys[freeIndex] = this.keys[tailIndex];
        next[freeIndex] = (byte)(nextOffset == -127 ? nextOffset : -WormUtil.getOffsetBetweenIndexes(freeIndex, nextIndex, capacity));
        int previousOffset = WormUtil.getOffsetBetweenIndexes(previousIndex, freeIndex, capacity);
        next[previousIndex] = (byte)(next[previousIndex] > 0 ? previousOffset : -previousOffset);
        assert (next[freeIndex] < 0) : "freeIndex=" + freeIndex + ", next[freeIndex]=" + next[freeIndex];
        return true;
    }

    private int searchInChain(KType key, int index, int nextOffset) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (nextOffset > 0 && nextOffset <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[index]) : "nextOffset=" + nextOffset + ", next[index]=" + this.next[index];
        if (Objects.equals(this.keys[index], key)) {
            return index;
        }
        int capacity = this.next.length;
        while (nextOffset != 127) {
            if (Objects.equals(this.keys[index = WormUtil.addOffset(index, nextOffset, capacity)], key)) {
                return index;
            }
            nextOffset = -this.next[index];
            assert (nextOffset > 0) : "nextOffset=" + nextOffset;
        }
        return ~index;
    }

    private int searchInChainReturnPrevious(KType key, int index, int nextOffset) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (nextOffset > 0 && nextOffset <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[index]) : "nextOffset=" + nextOffset + ", next[index]=" + this.next[index];
        if (Objects.equals(this.keys[index], key)) {
            return Integer.MAX_VALUE;
        }
        int capacity = this.next.length;
        while (nextOffset != 127) {
            int previousIndex = index;
            if (Objects.equals(this.keys[index = WormUtil.addOffset(index, nextOffset, capacity)], key)) {
                return previousIndex;
            }
            nextOffset = -this.next[index];
            assert (nextOffset > 0) : "nextOffset=" + nextOffset;
        }
        return ~index;
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    private class EntryIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = ObjectWormSet.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & ObjectWormSet.this.next.length - 1;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int mask = ObjectWormSet.this.next.length - 1;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (ObjectWormSet.this.next[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = ObjectWormSet.this.keys[this.slot];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

