/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import java.util.Iterator;
import java.util.function.IntBinaryOperator;
import org.teavm.hppc.AbstractIntCollection;
import org.teavm.hppc.AbstractIterator;
import org.teavm.hppc.AbstractLongCollection;
import org.teavm.hppc.IntCollection;
import org.teavm.hppc.IntContainer;
import org.teavm.hppc.IntLongAssociativeContainer;
import org.teavm.hppc.IntLongHashMap;
import org.teavm.hppc.IntLongMap;
import org.teavm.hppc.IntLookupContainer;
import org.teavm.hppc.LongContainer;
import org.teavm.hppc.comparators.IntComparator;
import org.teavm.hppc.comparators.IntLongComparator;
import org.teavm.hppc.cursors.IntCursor;
import org.teavm.hppc.cursors.IntLongCursor;
import org.teavm.hppc.cursors.LongCursor;
import org.teavm.hppc.predicates.IntLongPredicate;
import org.teavm.hppc.predicates.IntPredicate;
import org.teavm.hppc.predicates.LongPredicate;
import org.teavm.hppc.procedures.IntLongProcedure;
import org.teavm.hppc.procedures.IntProcedure;
import org.teavm.hppc.procedures.LongProcedure;
import org.teavm.hppc.sorting.QuickSort;

public class SortedIterationIntLongHashMap
implements IntLongMap {
    public final IntLongHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationIntLongHashMap(IntLongHashMap delegate, IntComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationIntLongHashMap(IntLongHashMap delegate, IntLongComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        int[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != 0) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, IntComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            int[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final IntLongComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final int[] keys;
            final long[] values;
            {
                this.keys = SortedIterationIntLongHashMap.this.delegate.keys;
                this.values = SortedIterationIntLongHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<IntLongCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(int key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(IntContainer container) {
        throw SortedIterationIntLongHashMap.readOnlyException();
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        throw SortedIterationIntLongHashMap.readOnlyException();
    }

    @Override
    public int removeAll(IntLongPredicate predicate) {
        throw SortedIterationIntLongHashMap.readOnlyException();
    }

    @Override
    public <T extends IntLongProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        int[] keys = this.delegate.keys;
        long[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends IntLongPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        int[] keys = this.delegate.keys;
        long[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public IntCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public LongContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public long get(int key) {
        return this.delegate.get(key);
    }

    @Override
    public long getOrDefault(int key, long defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public long put(int key, long value) {
        throw SortedIterationIntLongHashMap.readOnlyException();
    }

    @Override
    public int putAll(IntLongAssociativeContainer container) {
        throw SortedIterationIntLongHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends IntLongCursor> iterable) {
        throw SortedIterationIntLongHashMap.readOnlyException();
    }

    @Override
    public long putOrAdd(int key, long putValue, long incrementValue) {
        throw SortedIterationIntLongHashMap.readOnlyException();
    }

    @Override
    public long addTo(int key, long additionValue) {
        throw SortedIterationIntLongHashMap.readOnlyException();
    }

    @Override
    public long remove(int key) {
        throw SortedIterationIntLongHashMap.readOnlyException();
    }

    @Override
    public int indexOf(int key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public long indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public long indexReplace(int index, long newValue) {
        throw SortedIterationIntLongHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, int key, long value) {
        throw SortedIterationIntLongHashMap.readOnlyException();
    }

    @Override
    public long indexRemove(int index) {
        throw SortedIterationIntLongHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationIntLongHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationIntLongHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<IntLongCursor> {
        private final IntLongCursor cursor = new IntLongCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected IntLongCursor fetch() {
            if (this.index < SortedIterationIntLongHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntLongHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationIntLongHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationIntLongHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (IntLongCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final SortedIterationIntLongHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationIntLongHashMap.this;
        }

        @Override
        public boolean contains(int e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationIntLongHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationIntLongHashMap.readOnlyException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw SortedIterationIntLongHashMap.readOnlyException();
        }

        @Override
        public int removeAll(int e) {
            throw SortedIterationIntLongHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractLongCollection {
        private final SortedIterationIntLongHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationIntLongHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(long value) {
            for (IntLongCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(long e) {
            throw SortedIterationIntLongHashMap.readOnlyException();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            throw SortedIterationIntLongHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationIntLongHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationIntLongHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected LongCursor fetch() {
            if (this.index < SortedIterationIntLongHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntLongHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationIntLongHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected IntCursor fetch() {
            if (this.index < SortedIterationIntLongHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntLongHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationIntLongHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

