/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.teavm.backend.wasm.binary.BinaryWriter;
import org.teavm.backend.wasm.binary.DataPrimitives;
import org.teavm.backend.wasm.binary.DataStructure;
import org.teavm.backend.wasm.binary.DataValue;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.generate.WasmStringPool;
import org.teavm.model.ValueType;
import org.teavm.model.lowlevel.CallSiteDescriptor;
import org.teavm.model.lowlevel.CallSiteLocation;
import org.teavm.model.lowlevel.ExceptionHandlerDescriptor;

public class CallSiteBinaryGenerator {
    private static final int CALL_SITE_HANDLER_COUNT = 0;
    private static final int CALL_SITE_FIRST_HANDLER = 1;
    private static final int CALL_SITE_LOCATION = 2;
    private static final int EXCEPTION_HANDLER_ID = 0;
    private static final int EXCEPTION_HANDLER_CLASS = 1;
    private static final int LOCATION_FILE = 0;
    private static final int LOCATION_CLASS = 1;
    private static final int LOCATION_METHOD = 2;
    private static final int LOCATION_LINE_NUMBER = 3;
    private DataStructure callSiteStructure = new DataStructure(0, DataPrimitives.INT, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS);
    private DataStructure exceptionHandlerStructure = new DataStructure(0, DataPrimitives.INT, DataPrimitives.ADDRESS);
    private DataStructure locationStructure = new DataStructure(0, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.INT);
    private BinaryWriter writer;
    private WasmClassGenerator classGenerator;
    private WasmStringPool stringPool;

    public CallSiteBinaryGenerator(BinaryWriter writer, WasmClassGenerator classGenerator, WasmStringPool stringPool) {
        this.writer = writer;
        this.classGenerator = classGenerator;
        this.stringPool = stringPool;
    }

    public int writeCallSites(List<CallSiteDescriptor> callSites) {
        if (callSites.isEmpty()) {
            return 0;
        }
        int firstCallSite = -1;
        ArrayList<DataValue> binaryCallSites = new ArrayList<DataValue>();
        for (int i = 0; i < callSites.size(); ++i) {
            DataValue binaryCallSite = this.callSiteStructure.createValue();
            int address = this.writer.append(binaryCallSite);
            if (firstCallSite < 0) {
                firstCallSite = address;
            }
            binaryCallSites.add(binaryCallSite);
        }
        HashMap<CallSiteLocation, Integer> locationCache = new HashMap<CallSiteLocation, Integer>();
        for (int callSiteId = 0; callSiteId < callSites.size(); ++callSiteId) {
            int i;
            DataValue binaryCallSite = (DataValue)binaryCallSites.get(callSiteId);
            CallSiteDescriptor callSite = callSites.get(callSiteId);
            binaryCallSite.setInt(0, callSite.getHandlers().size());
            boolean firstHandlerSet = false;
            ArrayList<DataValue> binaryExceptionHandlers = new ArrayList<DataValue>();
            for (i = 0; i < callSite.getHandlers().size(); ++i) {
                DataValue binaryExceptionHandler = this.exceptionHandlerStructure.createValue();
                int address = this.writer.append(binaryExceptionHandler);
                binaryExceptionHandlers.add(binaryExceptionHandler);
                binaryExceptionHandler.setInt(0, callSiteId + i + 1);
                if (firstHandlerSet) continue;
                binaryCallSite.setAddress(1, address);
                firstHandlerSet = true;
            }
            for (i = 0; i < callSite.getHandlers().size(); ++i) {
                ExceptionHandlerDescriptor exceptionHandler = callSite.getHandlers().get(i);
                DataValue binaryExceptionHandler = (DataValue)binaryExceptionHandlers.get(i);
                if (exceptionHandler.getClassName() == null) continue;
                ValueType type = ValueType.object(exceptionHandler.getClassName());
                int classPointer = this.classGenerator.getClassPointer(type);
                binaryExceptionHandler.setAddress(1, classPointer);
            }
            int locationAddress = locationCache.computeIfAbsent(callSite.getLocation(), location -> {
                DataValue binaryLocation = this.locationStructure.createValue();
                int address = this.writer.append(binaryLocation);
                if (location.getFileName() != null) {
                    binaryLocation.setAddress(0, this.stringPool.getStringPointer(location.getFileName()));
                }
                if (location.getClassName() != null) {
                    binaryLocation.setAddress(1, this.stringPool.getStringPointer(location.getClassName()));
                }
                if (location.getMethodName() != null) {
                    binaryLocation.setAddress(2, this.stringPool.getStringPointer(location.getMethodName()));
                }
                binaryLocation.setInt(3, location.getLineNumber());
                return address;
            });
            binaryCallSite.setAddress(2, locationAddress);
        }
        return firstCallSite;
    }
}

