/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics;

import org.teavm.ast.ConstantExpr;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.interop.Structure;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class StructureIntrinsic
implements WasmIntrinsic {
    private WasmClassGenerator classGenerator;

    public StructureIntrinsic(WasmClassGenerator classGenerator) {
        this.classGenerator = classGenerator;
    }

    @Override
    public boolean isApplicable(MethodReference methodReference) {
        return methodReference.getClassName().equals(Structure.class.getName());
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "toAddress": 
            case "cast": {
                return manager.generate(invocation.getArguments().get(0));
            }
            case "sizeOf": {
                ValueType.Object type = (ValueType.Object)((ConstantExpr)invocation.getArguments().get(0)).getValue();
                return new WasmInt32Constant(this.classGenerator.getClassSize(type.getClassName()));
            }
            case "add": {
                WasmExpression base = manager.generate(invocation.getArguments().get(1));
                WasmExpression offset = manager.generate(invocation.getArguments().get(2));
                Object type = ((ConstantExpr)invocation.getArguments().get(0)).getValue();
                String className = ((ValueType.Object)type).getClassName();
                int size = this.classGenerator.getClassSize(className);
                int alignment = this.classGenerator.getClassAlignment(className);
                size = WasmClassGenerator.align(size, alignment);
                offset = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.MUL, offset, new WasmInt32Constant(size));
                return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, base, offset);
            }
        }
        throw new IllegalArgumentException(invocation.getMethod().toString());
    }
}

