/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.ast.ArrayType;
import org.teavm.ast.AssignmentStatement;
import org.teavm.ast.AsyncMethodNode;
import org.teavm.ast.AsyncMethodPart;
import org.teavm.ast.BinaryExpr;
import org.teavm.ast.BinaryOperation;
import org.teavm.ast.BlockStatement;
import org.teavm.ast.BreakStatement;
import org.teavm.ast.CastExpr;
import org.teavm.ast.ConditionalExpr;
import org.teavm.ast.ConditionalStatement;
import org.teavm.ast.ConstantExpr;
import org.teavm.ast.ContinueStatement;
import org.teavm.ast.Expr;
import org.teavm.ast.ExprVisitor;
import org.teavm.ast.GotoPartStatement;
import org.teavm.ast.IdentifiedStatement;
import org.teavm.ast.InitClassStatement;
import org.teavm.ast.InstanceOfExpr;
import org.teavm.ast.InvocationExpr;
import org.teavm.ast.InvocationType;
import org.teavm.ast.MonitorEnterStatement;
import org.teavm.ast.MonitorExitStatement;
import org.teavm.ast.NewArrayExpr;
import org.teavm.ast.NewExpr;
import org.teavm.ast.NewMultiArrayExpr;
import org.teavm.ast.OperationType;
import org.teavm.ast.PrimitiveCastExpr;
import org.teavm.ast.QualificationExpr;
import org.teavm.ast.RegularMethodNode;
import org.teavm.ast.ReturnStatement;
import org.teavm.ast.SequentialStatement;
import org.teavm.ast.Statement;
import org.teavm.ast.StatementVisitor;
import org.teavm.ast.SubscriptExpr;
import org.teavm.ast.SwitchClause;
import org.teavm.ast.SwitchStatement;
import org.teavm.ast.ThrowStatement;
import org.teavm.ast.TryCatchStatement;
import org.teavm.ast.UnaryExpr;
import org.teavm.ast.UnaryOperation;
import org.teavm.ast.UnwrapArrayExpr;
import org.teavm.ast.VariableExpr;
import org.teavm.ast.VariableNode;
import org.teavm.ast.WhileStatement;
import org.teavm.cache.SymbolTable;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;
import org.teavm.model.instructions.ArrayElementType;
import org.teavm.model.util.VariableType;

public class AstIO {
    private static final ElementModifier[] nodeModifiers = ElementModifier.values();
    private static final BinaryOperation[] binaryOperations = BinaryOperation.values();
    private static final UnaryOperation[] unaryOperations = UnaryOperation.values();
    private static final ArrayElementType[] arrayElementTypes = ArrayElementType.values();
    private final SymbolTable symbolTable;
    private final SymbolTable fileTable;
    private final Map<String, IdentifiedStatement> statementMap = new HashMap<String, IdentifiedStatement>();

    public AstIO(SymbolTable symbolTable, SymbolTable fileTable) {
        this.symbolTable = symbolTable;
        this.fileTable = fileTable;
    }

    public void write(DataOutput output, RegularMethodNode method) throws IOException {
        output.writeInt(this.packModifiers(method.getModifiers()));
        output.writeShort(method.getVariables().size());
        for (VariableNode var : method.getVariables()) {
            this.write(output, var);
        }
        try {
            method.getBody().acceptVisitor(new NodeWriter(output));
        }
        catch (IOExceptionWrapper e) {
            throw new IOException("Error writing method body", e.getCause());
        }
    }

    private void write(DataOutput output, VariableNode variable) throws IOException {
        output.writeShort(variable.getIndex());
        output.writeByte(variable.getType().ordinal());
        output.writeUTF(variable.getName() != null ? variable.getName() : "");
    }

    public RegularMethodNode read(DataInput input, MethodReference method) throws IOException {
        RegularMethodNode node = new RegularMethodNode(method);
        node.getModifiers().addAll(this.unpackModifiers(input.readInt()));
        int varCount = input.readShort();
        for (int i = 0; i < varCount; ++i) {
            node.getVariables().add(this.readVariable(input));
        }
        node.setBody(this.readStatement(input));
        return node;
    }

    private VariableNode readVariable(DataInput input) throws IOException {
        short index = input.readShort();
        VariableType type = VariableType.values()[input.readByte()];
        VariableNode variable = new VariableNode(index, type);
        int nameCount = input.readByte();
        for (int i = 0; i < nameCount; ++i) {
            variable.setName(input.readUTF());
            if (!variable.getName().isEmpty()) continue;
            variable.setName(null);
        }
        return variable;
    }

    public void writeAsync(DataOutput output, AsyncMethodNode method) throws IOException {
        output.writeInt(this.packModifiers(method.getModifiers()));
        output.writeShort(method.getVariables().size());
        for (VariableNode var : method.getVariables()) {
            this.write(output, var);
        }
        try {
            output.writeShort(method.getBody().size());
            for (int i = 0; i < method.getBody().size(); ++i) {
                method.getBody().get(i).getStatement().acceptVisitor(new NodeWriter(output));
            }
        }
        catch (IOExceptionWrapper e) {
            throw new IOException("Error writing method body", e.getCause());
        }
    }

    public AsyncMethodNode readAsync(DataInput input, MethodReference method) throws IOException {
        AsyncMethodNode node = new AsyncMethodNode(method);
        node.getModifiers().addAll(this.unpackModifiers(input.readInt()));
        int varCount = input.readShort();
        for (int i = 0; i < varCount; ++i) {
            node.getVariables().add(this.readVariable(input));
        }
        int partCount = input.readShort();
        for (int i = 0; i < partCount; ++i) {
            AsyncMethodPart part = new AsyncMethodPart();
            part.setStatement(this.readStatement(input));
            node.getBody().add(part);
        }
        return node;
    }

    private int packModifiers(Set<ElementModifier> modifiers) {
        int packed = 0;
        for (ElementModifier modifier : modifiers) {
            packed |= 1 << modifier.ordinal();
        }
        return packed;
    }

    private Set<ElementModifier> unpackModifiers(int packed) {
        EnumSet<ElementModifier> modifiers = EnumSet.noneOf(ElementModifier.class);
        while (packed != 0) {
            int shift = Integer.numberOfTrailingZeros(packed);
            modifiers.add(nodeModifiers[shift]);
            packed ^= 1 << shift;
        }
        return modifiers;
    }

    private TextLocation readLocation(DataInput input) throws IOException {
        short fileIndex = input.readShort();
        if (fileIndex == -1) {
            return null;
        }
        return new TextLocation(this.fileTable.at(fileIndex), input.readShort());
    }

    private Statement readStatement(DataInput input) throws IOException {
        byte type = input.readByte();
        switch (type) {
            case 0: {
                AssignmentStatement stmt = new AssignmentStatement();
                stmt.setLocation(this.readLocation(input));
                stmt.setLeftValue(this.readExpr(input));
                stmt.setRightValue(this.readExpr(input));
                stmt.setAsync(input.readBoolean());
                return stmt;
            }
            case 1: {
                AssignmentStatement stmt = new AssignmentStatement();
                stmt.setLocation(this.readLocation(input));
                stmt.setRightValue(this.readExpr(input));
                stmt.setAsync(input.readBoolean());
                return stmt;
            }
            case 2: {
                SequentialStatement stmt = new SequentialStatement();
                this.readSequence(input, stmt.getSequence());
                return stmt;
            }
            case 3: {
                ConditionalStatement stmt = new ConditionalStatement();
                stmt.setCondition(this.readExpr(input));
                this.readSequence(input, stmt.getConsequent());
                this.readSequence(input, stmt.getAlternative());
                return stmt;
            }
            case 4: {
                SwitchStatement stmt = new SwitchStatement();
                stmt.setId(this.readNullableString(input));
                stmt.setValue(this.readExpr(input));
                int clauseCount = input.readShort();
                for (int i = 0; i < clauseCount; ++i) {
                    SwitchClause clause = new SwitchClause();
                    int conditionCount = input.readShort();
                    int[] conditions = new int[conditionCount];
                    for (int j = 0; j < conditionCount; ++j) {
                        conditions[j] = input.readInt();
                    }
                    clause.setConditions(conditions);
                    this.readSequence(input, clause.getBody());
                    stmt.getClauses().add(clause);
                }
                this.readSequence(input, stmt.getDefaultClause());
                return stmt;
            }
            case 5: {
                WhileStatement stmt = new WhileStatement();
                stmt.setId(this.readNullableString(input));
                stmt.setCondition(this.readExpr(input));
                if (stmt.getId() != null) {
                    this.statementMap.put(stmt.getId(), stmt);
                }
                this.readSequence(input, stmt.getBody());
                return stmt;
            }
            case 6: {
                WhileStatement stmt = new WhileStatement();
                stmt.setId(this.readNullableString(input));
                if (stmt.getId() != null) {
                    this.statementMap.put(stmt.getId(), stmt);
                }
                this.readSequence(input, stmt.getBody());
                return stmt;
            }
            case 7: {
                BlockStatement stmt = new BlockStatement();
                stmt.setId(this.readNullableString(input));
                if (stmt.getId() != null) {
                    this.statementMap.put(stmt.getId(), stmt);
                }
                this.readSequence(input, stmt.getBody());
                return stmt;
            }
            case 8: {
                BreakStatement stmt = new BreakStatement();
                stmt.setLocation(this.readLocation(input));
                stmt.setTarget(this.statementMap.get(input.readUTF()));
                return stmt;
            }
            case 9: {
                BreakStatement stmt = new BreakStatement();
                stmt.setLocation(this.readLocation(input));
                return stmt;
            }
            case 10: {
                ContinueStatement stmt = new ContinueStatement();
                stmt.setLocation(this.readLocation(input));
                stmt.setTarget(this.statementMap.get(input.readUTF()));
                return stmt;
            }
            case 11: {
                ContinueStatement stmt = new ContinueStatement();
                stmt.setLocation(this.readLocation(input));
                return stmt;
            }
            case 12: {
                ReturnStatement stmt = new ReturnStatement();
                stmt.setLocation(this.readLocation(input));
                stmt.setResult(this.readExpr(input));
                return stmt;
            }
            case 13: {
                ReturnStatement stmt = new ReturnStatement();
                stmt.setLocation(this.readLocation(input));
                return stmt;
            }
            case 14: {
                ThrowStatement stmt = new ThrowStatement();
                stmt.setLocation(this.readLocation(input));
                stmt.setException(this.readExpr(input));
                return stmt;
            }
            case 15: {
                InitClassStatement stmt = new InitClassStatement();
                stmt.setLocation(this.readLocation(input));
                stmt.setClassName(this.symbolTable.at(input.readInt()));
                return stmt;
            }
            case 16: {
                short exceptionVarIndex;
                TryCatchStatement stmt = new TryCatchStatement();
                this.readSequence(input, stmt.getProtectedBody());
                int exceptionTypeIndex = input.readInt();
                if (exceptionTypeIndex >= 0) {
                    stmt.setExceptionType(this.symbolTable.at(exceptionTypeIndex));
                }
                if ((exceptionVarIndex = input.readShort()) >= 0) {
                    stmt.setExceptionVariable(Integer.valueOf(exceptionVarIndex));
                }
                this.readSequence(input, stmt.getHandler());
                return stmt;
            }
            case 17: {
                GotoPartStatement stmt = new GotoPartStatement();
                stmt.setPart(input.readShort());
                return stmt;
            }
            case 18: {
                MonitorEnterStatement stmt = new MonitorEnterStatement();
                stmt.setLocation(this.readLocation(input));
                stmt.setObjectRef(this.readExpr(input));
                return stmt;
            }
            case 19: {
                MonitorExitStatement stmt = new MonitorExitStatement();
                stmt.setLocation(this.readLocation(input));
                stmt.setObjectRef(this.readExpr(input));
                return stmt;
            }
        }
        throw new RuntimeException("Unexpected statement type: " + type);
    }

    private void readSequence(DataInput input, List<Statement> statements) throws IOException {
        int count = input.readShort();
        for (int i = 0; i < count; ++i) {
            statements.add(this.readStatement(input));
        }
    }

    private String readNullableString(DataInput input) throws IOException {
        return input.readBoolean() ? input.readUTF() : null;
    }

    private Expr readExpr(DataInput input) throws IOException {
        TextLocation location = this.readLocation(input);
        Expr expr = this.readExprWithoutLocation(input);
        expr.setLocation(location);
        return expr;
    }

    private Expr readExprWithoutLocation(DataInput input) throws IOException {
        byte type = input.readByte();
        switch (type) {
            case 0: {
                BinaryExpr expr = new BinaryExpr();
                expr.setOperation(binaryOperations[input.readByte()]);
                byte valueType = input.readByte();
                expr.setType(valueType > 0 ? OperationType.values()[valueType] : null);
                expr.setFirstOperand(this.readExpr(input));
                expr.setSecondOperand(this.readExpr(input));
                return expr;
            }
            case 1: {
                UnaryExpr expr = new UnaryExpr();
                expr.setOperation(unaryOperations[input.readByte()]);
                byte valueType = input.readByte();
                expr.setType(valueType > 0 ? OperationType.values()[valueType] : null);
                expr.setOperand(this.readExpr(input));
                return expr;
            }
            case 2: {
                ConditionalExpr expr = new ConditionalExpr();
                expr.setCondition(this.readExpr(input));
                expr.setConsequent(this.readExpr(input));
                expr.setAlternative(this.readExpr(input));
                return expr;
            }
            case 3: {
                return new ConstantExpr();
            }
            case 4: {
                ConstantExpr expr = new ConstantExpr();
                expr.setValue(input.readInt());
                return expr;
            }
            case 5: {
                ConstantExpr expr = new ConstantExpr();
                expr.setValue(input.readLong());
                return expr;
            }
            case 6: {
                ConstantExpr expr = new ConstantExpr();
                expr.setValue(Float.valueOf(input.readFloat()));
                return expr;
            }
            case 7: {
                ConstantExpr expr = new ConstantExpr();
                expr.setValue(input.readDouble());
                return expr;
            }
            case 8: {
                ConstantExpr expr = new ConstantExpr();
                expr.setValue(input.readUTF());
                return expr;
            }
            case 9: {
                ConstantExpr expr = new ConstantExpr();
                expr.setValue(ValueType.parse(this.symbolTable.at(input.readInt())));
                return expr;
            }
            case 10: {
                VariableExpr expr = new VariableExpr();
                expr.setIndex(input.readShort());
                return expr;
            }
            case 11: {
                SubscriptExpr expr = new SubscriptExpr();
                expr.setArray(this.readExpr(input));
                expr.setIndex(this.readExpr(input));
                expr.setType(ArrayType.values()[input.readByte()]);
                return expr;
            }
            case 12: {
                UnwrapArrayExpr expr = new UnwrapArrayExpr(arrayElementTypes[input.readByte()]);
                expr.setArray(this.readExpr(input));
                return expr;
            }
            case 13: {
                return this.parseInvocationExpr(InvocationType.CONSTRUCTOR, input);
            }
            case 14: {
                return this.parseInvocationExpr(InvocationType.STATIC, input);
            }
            case 15: {
                return this.parseInvocationExpr(InvocationType.SPECIAL, input);
            }
            case 16: {
                return this.parseInvocationExpr(InvocationType.DYNAMIC, input);
            }
            case 17: {
                QualificationExpr expr = new QualificationExpr();
                String className = this.symbolTable.at(input.readInt());
                String fieldName = this.symbolTable.at(input.readInt());
                expr.setField(new FieldReference(className, fieldName));
                return expr;
            }
            case 18: {
                QualificationExpr expr = new QualificationExpr();
                expr.setQualified(this.readExpr(input));
                String className = this.symbolTable.at(input.readInt());
                String fieldName = this.symbolTable.at(input.readInt());
                expr.setField(new FieldReference(className, fieldName));
                return expr;
            }
            case 19: {
                NewExpr expr = new NewExpr();
                expr.setConstructedClass(this.symbolTable.at(input.readInt()));
                return expr;
            }
            case 20: {
                NewArrayExpr expr = new NewArrayExpr();
                expr.setLength(this.readExpr(input));
                expr.setType(ValueType.parse(this.symbolTable.at(input.readInt())));
                return expr;
            }
            case 21: {
                NewMultiArrayExpr expr = new NewMultiArrayExpr();
                int dimensionCount = input.readByte();
                for (int i = 0; i < dimensionCount; ++i) {
                    expr.getDimensions().add(this.readExpr(input));
                }
                expr.setType(ValueType.parse(this.symbolTable.at(input.readInt())));
                return expr;
            }
            case 22: {
                InstanceOfExpr expr = new InstanceOfExpr();
                expr.setExpr(this.readExpr(input));
                expr.setType(ValueType.parse(this.symbolTable.at(input.readInt())));
                return expr;
            }
            case 23: {
                CastExpr expr = new CastExpr();
                expr.setTarget(ValueType.parse(this.symbolTable.at(input.readInt())));
                expr.setValue(this.readExpr(input));
                return expr;
            }
            case 24: {
                PrimitiveCastExpr expr = new PrimitiveCastExpr();
                expr.setSource(OperationType.values()[input.readByte()]);
                expr.setTarget(OperationType.values()[input.readByte()]);
                expr.setValue(this.readExpr(input));
                return expr;
            }
        }
        throw new RuntimeException("Unknown expression type: " + type);
    }

    private InvocationExpr parseInvocationExpr(InvocationType invocationType, DataInput input) throws IOException {
        InvocationExpr expr = new InvocationExpr();
        expr.setType(invocationType);
        String className = this.symbolTable.at(input.readInt());
        MethodDescriptor method = MethodDescriptor.parse(this.symbolTable.at(input.readInt()));
        expr.setMethod(new MethodReference(className, method));
        int argCount = input.readShort();
        for (int i = 0; i < argCount; ++i) {
            expr.getArguments().add(this.readExpr(input));
        }
        return expr;
    }

    private static class IOExceptionWrapper
    extends RuntimeException {
        private static final long serialVersionUID = -7566355431593608333L;

        IOExceptionWrapper(Throwable cause) {
            super(cause);
        }
    }

    private class NodeWriter
    implements ExprVisitor,
    StatementVisitor {
        private final DataOutput output;

        NodeWriter(DataOutput output) {
            this.output = output;
        }

        void writeExpr(Expr expr) throws IOException {
            this.writeLocation(expr.getLocation());
            expr.acceptVisitor(this);
        }

        private void writeLocation(TextLocation location) throws IOException {
            if (location == null || location.getFileName() == null) {
                this.output.writeShort(-1);
            } else {
                this.output.writeShort(AstIO.this.fileTable.lookup(location.getFileName()));
                this.output.writeShort(location.getLine());
            }
        }

        private void writeSequence(List<Statement> sequence) throws IOException {
            this.output.writeShort(sequence.size());
            for (Statement part : sequence) {
                part.acceptVisitor(this);
            }
        }

        private void writeNullableString(String str) throws IOException {
            if (str == null) {
                this.output.writeBoolean(false);
            } else {
                this.output.writeBoolean(true);
                this.output.writeUTF(str);
            }
        }

        @Override
        public void visit(AssignmentStatement statement) {
            try {
                this.output.writeByte(statement.getLeftValue() != null ? 0 : 1);
                this.writeLocation(statement.getLocation());
                if (statement.getLeftValue() != null) {
                    this.writeExpr(statement.getLeftValue());
                }
                this.writeExpr(statement.getRightValue());
                this.output.writeBoolean(statement.isAsync());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(SequentialStatement statement) {
            try {
                this.output.writeByte(2);
                this.writeSequence(statement.getSequence());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(ConditionalStatement statement) {
            try {
                this.output.writeByte(3);
                this.writeExpr(statement.getCondition());
                this.writeSequence(statement.getConsequent());
                this.writeSequence(statement.getAlternative());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(SwitchStatement statement) {
            try {
                this.output.writeByte(4);
                this.writeNullableString(statement.getId());
                this.writeExpr(statement.getValue());
                this.output.writeShort(statement.getClauses().size());
                for (SwitchClause clause : statement.getClauses()) {
                    int[] conditions = clause.getConditions();
                    this.output.writeShort(conditions.length);
                    for (int condition : conditions) {
                        this.output.writeInt(condition);
                    }
                    this.writeSequence(clause.getBody());
                }
                this.writeSequence(statement.getDefaultClause());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(WhileStatement statement) {
            try {
                this.output.writeByte(statement.getCondition() != null ? 5 : 6);
                this.writeNullableString(statement.getId());
                if (statement.getCondition() != null) {
                    this.writeExpr(statement.getCondition());
                }
                this.writeSequence(statement.getBody());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(BlockStatement statement) {
            try {
                this.output.writeByte(7);
                this.writeNullableString(statement.getId());
                this.writeSequence(statement.getBody());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(BreakStatement statement) {
            try {
                this.output.writeByte(statement.getTarget() != null && statement.getTarget().getId() != null ? 8 : 9);
                this.writeLocation(statement.getLocation());
                if (statement.getTarget() != null && statement.getTarget().getId() != null) {
                    this.output.writeUTF(statement.getTarget().getId());
                }
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(ContinueStatement statement) {
            try {
                this.output.writeByte(statement.getTarget() != null && statement.getTarget().getId() != null ? 10 : 11);
                this.writeLocation(statement.getLocation());
                if (statement.getTarget() != null && statement.getTarget().getId() != null) {
                    this.output.writeUTF(statement.getTarget().getId());
                }
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(ReturnStatement statement) {
            try {
                this.output.writeByte(statement.getResult() != null ? 12 : 13);
                this.writeLocation(statement.getLocation());
                if (statement.getResult() != null) {
                    this.writeExpr(statement.getResult());
                }
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(ThrowStatement statement) {
            try {
                this.output.writeByte(14);
                this.writeLocation(statement.getLocation());
                this.writeExpr(statement.getException());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(InitClassStatement statement) {
            try {
                this.output.writeByte(15);
                this.writeLocation(statement.getLocation());
                this.output.writeInt(AstIO.this.symbolTable.lookup(statement.getClassName()));
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(TryCatchStatement statement) {
            try {
                this.output.writeByte(16);
                this.writeSequence(statement.getProtectedBody());
                this.output.writeInt(statement.getExceptionType() != null ? AstIO.this.symbolTable.lookup(statement.getExceptionType()) : -1);
                this.output.writeShort(statement.getExceptionVariable() != null ? statement.getExceptionVariable() : -1);
                this.writeSequence(statement.getHandler());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(GotoPartStatement statement) {
            try {
                this.output.writeByte(17);
                this.output.writeShort(statement.getPart());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(MonitorEnterStatement statement) {
            try {
                this.output.writeByte(18);
                this.writeLocation(statement.getLocation());
                this.writeExpr(statement.getObjectRef());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(MonitorExitStatement statement) {
            try {
                this.output.writeByte(19);
                this.writeLocation(statement.getLocation());
                this.writeExpr(statement.getObjectRef());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(BinaryExpr expr) {
            try {
                this.output.writeByte(0);
                this.output.writeByte(expr.getOperation().ordinal());
                this.output.writeByte(expr.getType() != null ? expr.getType().ordinal() + 1 : 0);
                this.writeExpr(expr.getFirstOperand());
                this.writeExpr(expr.getSecondOperand());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(UnaryExpr expr) {
            try {
                this.output.writeByte(1);
                this.output.writeByte(expr.getOperation().ordinal());
                this.output.writeByte(expr.getType() != null ? expr.getType().ordinal() + 1 : 0);
                this.writeExpr(expr.getOperand());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(ConditionalExpr expr) {
            try {
                this.output.writeByte(2);
                this.writeExpr(expr.getCondition());
                this.writeExpr(expr.getConsequent());
                this.writeExpr(expr.getAlternative());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(ConstantExpr expr) {
            try {
                Object value = expr.getValue();
                if (value == null) {
                    this.output.writeByte(3);
                } else if (value instanceof Integer) {
                    this.output.writeByte(4);
                    this.output.writeInt((Integer)value);
                } else if (value instanceof Long) {
                    this.output.writeByte(5);
                    this.output.writeLong((Long)value);
                } else if (value instanceof Float) {
                    this.output.writeByte(6);
                    this.output.writeFloat(((Float)value).floatValue());
                } else if (value instanceof Double) {
                    this.output.writeByte(7);
                    this.output.writeDouble((Double)value);
                } else if (value instanceof String) {
                    this.output.writeByte(8);
                    this.output.writeUTF((String)value);
                } else if (value instanceof ValueType) {
                    this.output.writeByte(9);
                    this.output.writeInt(AstIO.this.symbolTable.lookup(value.toString()));
                }
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(VariableExpr expr) {
            try {
                this.output.writeByte(10);
                this.output.writeShort(expr.getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(SubscriptExpr expr) {
            try {
                this.output.writeByte(11);
                this.writeExpr(expr.getArray());
                this.writeExpr(expr.getIndex());
                this.output.writeByte(expr.getType().ordinal());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(UnwrapArrayExpr expr) {
            try {
                this.output.writeByte(12);
                this.output.writeByte(expr.getElementType().ordinal());
                this.writeExpr(expr.getArray());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(InvocationExpr expr) {
            try {
                switch (expr.getType()) {
                    case CONSTRUCTOR: {
                        this.output.writeByte(13);
                        break;
                    }
                    case STATIC: {
                        this.output.writeByte(14);
                        break;
                    }
                    case SPECIAL: {
                        this.output.writeByte(15);
                        break;
                    }
                    case DYNAMIC: {
                        this.output.writeByte(16);
                    }
                }
                this.output.writeInt(AstIO.this.symbolTable.lookup(expr.getMethod().getClassName()));
                this.output.writeInt(AstIO.this.symbolTable.lookup(expr.getMethod().getDescriptor().toString()));
                this.output.writeShort(expr.getArguments().size());
                for (int i = 0; i < expr.getArguments().size(); ++i) {
                    this.writeExpr(expr.getArguments().get(i));
                }
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(QualificationExpr expr) {
            try {
                this.output.writeByte(expr.getQualified() != null ? 17 : 18);
                if (expr.getQualified() != null) {
                    this.writeExpr(expr.getQualified());
                }
                this.output.writeInt(AstIO.this.symbolTable.lookup(expr.getField().getClassName()));
                this.output.writeInt(AstIO.this.symbolTable.lookup(expr.getField().getFieldName()));
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(NewExpr expr) {
            try {
                this.output.writeByte(19);
                this.output.writeInt(AstIO.this.symbolTable.lookup(expr.getConstructedClass()));
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(NewArrayExpr expr) {
            try {
                this.output.writeByte(20);
                this.writeExpr(expr.getLength());
                this.output.writeInt(AstIO.this.symbolTable.lookup(expr.getType().toString()));
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(NewMultiArrayExpr expr) {
            try {
                this.output.writeByte(21);
                this.output.writeByte(expr.getDimensions().size());
                for (Expr dimension : expr.getDimensions()) {
                    this.writeExpr(dimension);
                }
                this.output.writeInt(AstIO.this.symbolTable.lookup(expr.getType().toString()));
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(InstanceOfExpr expr) {
            try {
                this.output.writeByte(22);
                this.writeExpr(expr.getExpr());
                this.output.writeInt(AstIO.this.symbolTable.lookup(expr.getType().toString()));
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(CastExpr expr) {
            try {
                this.output.writeByte(23);
                this.output.writeInt(AstIO.this.symbolTable.lookup(expr.getTarget().toString()));
                this.writeExpr(expr.getValue());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(PrimitiveCastExpr expr) {
            try {
                this.output.writeByte(24);
                this.output.writeByte(expr.getSource().ordinal());
                this.output.writeByte(expr.getTarget().ordinal());
                this.writeExpr(expr.getValue());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }
    }
}

