/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.debugging;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.teavm.debugging.Debugger;
import org.teavm.debugging.Value;
import org.teavm.debugging.Variable;
import org.teavm.debugging.javascript.JavaScriptVariable;

class PropertyMap
extends AbstractMap<String, Variable> {
    private String className;
    private AtomicReference<Map<String, Variable>> backingMap = new AtomicReference();
    private Map<String, JavaScriptVariable> jsVariables;
    private Debugger debugger;

    public PropertyMap(String className, Map<String, JavaScriptVariable> jsVariables, Debugger debugger) {
        this.className = className;
        this.jsVariables = jsVariables;
        this.debugger = debugger;
    }

    @Override
    public int size() {
        this.updateBackingMap();
        return this.backingMap.get().size();
    }

    @Override
    public Variable get(Object key) {
        this.updateBackingMap();
        return this.backingMap.get().get(key);
    }

    @Override
    public Set<Map.Entry<String, Variable>> entrySet() {
        this.updateBackingMap();
        return this.backingMap.get().entrySet();
    }

    private void updateBackingMap() {
        if (this.backingMap.get() != null) {
            return;
        }
        HashMap<String, Variable> vars = new HashMap<String, Variable>();
        for (Map.Entry<String, JavaScriptVariable> entry : this.jsVariables.entrySet()) {
            String name;
            JavaScriptVariable jsVar = entry.getValue();
            if (this.className.endsWith("[]")) {
                if (!entry.getKey().equals("data")) continue;
                name = entry.getKey();
            } else if (this.isNumeric(entry.getKey())) {
                name = entry.getKey();
            } else {
                name = this.debugger.mapField(this.className, entry.getKey());
                if (name == null) continue;
            }
            Value value = new Value(this.debugger, jsVar.getValue());
            vars.put(name, new Variable(name, value));
        }
        this.backingMap.compareAndSet(null, vars);
    }

    private boolean isNumeric(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }
}

