/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodHolder;
import org.teavm.model.optimization.UnreachableBasicBlockEliminator;
import org.teavm.model.util.ModelUtils;

class DependencyClassSource
implements ClassHolderSource {
    private ClassReaderSource innerSource;
    private Diagnostics diagnostics;
    private Map<String, ClassHolder> generatedClasses = new LinkedHashMap<String, ClassHolder>();
    private List<ClassHolderTransformer> transformers = new ArrayList<ClassHolderTransformer>();
    private Map<String, ClassHolder> cache = new LinkedHashMap<String, ClassHolder>();

    public DependencyClassSource(ClassReaderSource innerSource, Diagnostics diagnostics) {
        this.innerSource = innerSource;
        this.diagnostics = diagnostics;
    }

    @Override
    public ClassHolder get(String name) {
        return this.cache.computeIfAbsent(name, this::findAndTransformClass);
    }

    public void submit(ClassHolder cls) {
        if (this.innerSource.get(cls.getName()) != null || this.generatedClasses.containsKey(cls.getName())) {
            throw new IllegalArgumentException("Class " + cls.getName() + " is already defined");
        }
        if (!this.transformers.isEmpty()) {
            for (ClassHolderTransformer transformer : this.transformers) {
                transformer.transformClass(cls, this.innerSource, this.diagnostics);
            }
            cls = ModelUtils.copyClass(cls);
        }
        this.generatedClasses.put(cls.getName(), cls);
        for (MethodHolder method : cls.getMethods()) {
            if (method.getProgram() == null || method.getProgram().basicBlockCount() <= 0) continue;
            new UnreachableBasicBlockEliminator().optimize(method.getProgram());
        }
        this.cache.remove(cls.getName());
    }

    private ClassHolder findAndTransformClass(String name) {
        ClassHolder cls = this.findClass(name);
        if (cls != null && !this.transformers.isEmpty()) {
            for (ClassHolderTransformer transformer : this.transformers) {
                transformer.transformClass(cls, this.innerSource, this.diagnostics);
            }
            cls = ModelUtils.copyClass(cls);
        }
        return cls;
    }

    private ClassHolder findClass(String name) {
        ClassReader cls = this.innerSource.get(name);
        if (cls != null) {
            return ModelUtils.copyClass(cls);
        }
        return this.generatedClasses.get(name);
    }

    public Collection<ClassHolder> getGeneratedClasses() {
        return this.generatedClasses.values();
    }

    public void addTransformer(ClassHolderTransformer transformer) {
        this.transformers.add(transformer);
    }
}

