/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import com.carrotsearch.hppc.IntOpenHashSet;
import java.util.ArrayDeque;
import java.util.BitSet;
import org.teavm.common.Graph;
import org.teavm.model.BasicBlock;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.Variable;
import org.teavm.model.util.DefinitionExtractor;
import org.teavm.model.util.ProgramUtils;
import org.teavm.model.util.UsageExtractor;

public class LivenessAnalyzer {
    private BitSet[] liveVars;

    public boolean liveIn(int block, int var) {
        return this.liveVars[block].get(var);
    }

    public BitSet liveIn(int block) {
        return (BitSet)this.liveVars[block].clone();
    }

    public void analyze(Program program) {
        Graph cfg = ProgramUtils.buildControlFlowGraph(program);
        this.liveVars = new BitSet[cfg.size()];
        for (int i = 0; i < this.liveVars.length; ++i) {
            this.liveVars[i] = new BitSet(program.basicBlockCount());
        }
        UsageExtractor usageExtractor = new UsageExtractor();
        DefinitionExtractor defExtractor = new DefinitionExtractor();
        ArrayDeque<Task> stack = new ArrayDeque<Task>();
        int[] definitions = new int[program.variableCount()];
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            if (block.getExceptionVariable() != null) {
                definitions[block.getExceptionVariable().getIndex()] = i;
            }
            for (Instruction insn : block) {
                insn.acceptVisitor(usageExtractor);
                IntOpenHashSet usedVars = new IntOpenHashSet();
                for (Variable var : usageExtractor.getUsedVariables()) {
                    Task task = new Task();
                    task.block = i;
                    task.var = var.getIndex();
                    stack.push(task);
                    usedVars.add(var.getIndex());
                }
                insn.acceptVisitor(defExtractor);
                for (Variable var : defExtractor.getDefinedVariables()) {
                    if (usedVars.contains(var.getIndex())) continue;
                    definitions[var.getIndex()] = i;
                }
            }
            for (Phi phi : block.getPhis()) {
                definitions[phi.getReceiver().getIndex()] = i;
                for (Incoming incoming : phi.getIncomings()) {
                    Task task = new Task();
                    task.block = incoming.getSource().getIndex();
                    task.var = incoming.getValue().getIndex();
                    stack.push(task);
                }
            }
        }
        while (!stack.isEmpty()) {
            Task task = (Task)stack.pop();
            if (this.liveVars[task.block].get(task.var) || definitions[task.var] == task.block) continue;
            this.liveVars[task.block].set(task.var, true);
            for (int pred : cfg.incomingEdges(task.block)) {
                Task nextTask = new Task();
                nextTask.block = pred;
                nextTask.var = task.var;
                stack.push(nextTask);
            }
        }
    }

    private static class Task {
        int block;
        int var;

        private Task() {
        }
    }
}

