/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.teavm.backend.javascript.JavaScriptTarget;
import org.teavm.backend.javascript.rendering.RenderingManager;
import org.teavm.backend.wasm.WasmTarget;
import org.teavm.backend.wasm.render.WasmBinaryVersion;
import org.teavm.cache.DiskCachedClassHolderSource;
import org.teavm.cache.DiskProgramCache;
import org.teavm.cache.DiskRegularMethodNodeCache;
import org.teavm.cache.FileSymbolTable;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.DebugInformationBuilder;
import org.teavm.dependency.DependencyInfo;
import org.teavm.diagnostics.ProblemProvider;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.PreOptimizingClassHolderSource;
import org.teavm.model.ProgramReader;
import org.teavm.parsing.ClasspathClassHolderSource;
import org.teavm.tooling.BaseTeaVMTool;
import org.teavm.tooling.ClassAlias;
import org.teavm.tooling.EmptyTeaVMToolLog;
import org.teavm.tooling.InstructionLocationReader;
import org.teavm.tooling.MethodAlias;
import org.teavm.tooling.RuntimeCopyOperation;
import org.teavm.tooling.TeaVMProblemRenderer;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.tooling.TeaVMToolException;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.tooling.sources.SourceFileProvider;
import org.teavm.tooling.sources.SourceFilesCopier;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.DirectoryBuildTarget;
import org.teavm.vm.TeaVM;
import org.teavm.vm.TeaVMBuilder;
import org.teavm.vm.TeaVMEntryPoint;
import org.teavm.vm.TeaVMOptimizationLevel;
import org.teavm.vm.TeaVMProgressListener;
import org.teavm.vm.TeaVMTarget;
import org.teavm.vm.spi.AbstractRendererListener;

public class TeaVMTool
implements BaseTeaVMTool {
    private File targetDirectory = new File(".");
    private TeaVMTargetType targetType = TeaVMTargetType.JAVASCRIPT;
    private String targetFileName = "";
    private boolean minifying = true;
    private String mainClass;
    private RuntimeCopyOperation runtime = RuntimeCopyOperation.SEPARATE;
    private Properties properties = new Properties();
    private boolean debugInformationGenerated;
    private boolean sourceMapsFileGenerated;
    private boolean sourceFilesCopied;
    private boolean incremental;
    private File cacheDirectory = new File("./teavm-cache");
    private List<ClassHolderTransformer> transformers = new ArrayList<ClassHolderTransformer>();
    private List<ClassAlias> classAliases = new ArrayList<ClassAlias>();
    private List<MethodAlias> methodAliases = new ArrayList<MethodAlias>();
    private TeaVMToolLog log = new EmptyTeaVMToolLog();
    private ClassLoader classLoader = TeaVMTool.class.getClassLoader();
    private DiskCachedClassHolderSource cachedClassSource;
    private DiskProgramCache programCache;
    private DiskRegularMethodNodeCache astCache;
    private FileSymbolTable symbolTable;
    private FileSymbolTable fileTable;
    private boolean cancelled;
    private TeaVMProgressListener progressListener;
    private TeaVM vm;
    private TeaVMOptimizationLevel optimizationLevel = TeaVMOptimizationLevel.SIMPLE;
    private List<SourceFileProvider> sourceFileProviders = new ArrayList<SourceFileProvider>();
    private DebugInformationBuilder debugEmitter;
    private JavaScriptTarget javaScriptTarget;
    private WasmTarget webAssemblyTarget;
    private WasmBinaryVersion wasmVersion = WasmBinaryVersion.V_0x1;
    private Set<File> generatedFiles = new HashSet<File>();
    private AbstractRendererListener runtimeInjector = new AbstractRendererListener(){

        @Override
        public void begin(RenderingManager manager, BuildTarget buildTarget) throws IOException {
            StringWriter writer = new StringWriter();
            TeaVMTool.this.resourceToWriter("org/teavm/backend/javascript/runtime.js", writer);
            writer.close();
            manager.getWriter().append(writer.toString()).newLine();
        }
    };

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    @Override
    public void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public boolean isMinifying() {
        return this.minifying;
    }

    @Override
    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    @Override
    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public RuntimeCopyOperation getRuntime() {
        return this.runtime;
    }

    public void setRuntime(RuntimeCopyOperation runtime) {
        this.runtime = runtime;
    }

    public boolean isDebugInformationGenerated() {
        return this.debugInformationGenerated;
    }

    @Override
    public void setDebugInformationGenerated(boolean debugInformationGenerated) {
        this.debugInformationGenerated = debugInformationGenerated;
    }

    public File getCacheDirectory() {
        return this.cacheDirectory;
    }

    public void setCacheDirectory(File cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    public boolean isSourceMapsFileGenerated() {
        return this.sourceMapsFileGenerated;
    }

    @Override
    public void setSourceMapsFileGenerated(boolean sourceMapsFileGenerated) {
        this.sourceMapsFileGenerated = sourceMapsFileGenerated;
    }

    public boolean isSourceFilesCopied() {
        return this.sourceFilesCopied;
    }

    @Override
    public void setSourceFilesCopied(boolean sourceFilesCopied) {
        this.sourceFilesCopied = sourceFilesCopied;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public List<ClassHolderTransformer> getTransformers() {
        return this.transformers;
    }

    public List<ClassAlias> getClassAliases() {
        return this.classAliases;
    }

    public List<MethodAlias> getMethodAliases() {
        return this.methodAliases;
    }

    public TeaVMToolLog getLog() {
        return this.log;
    }

    @Override
    public void setLog(TeaVMToolLog log) {
        this.log = log;
    }

    public TeaVMTargetType getTargetType() {
        return this.targetType;
    }

    public void setTargetType(TeaVMTargetType targetType) {
        this.targetType = targetType;
    }

    public TeaVMOptimizationLevel getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(TeaVMOptimizationLevel optimizationLevel) {
        this.optimizationLevel = optimizationLevel;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public WasmBinaryVersion getWasmVersion() {
        return this.wasmVersion;
    }

    public void setWasmVersion(WasmBinaryVersion wasmVersion) {
        this.wasmVersion = wasmVersion;
    }

    public void setProgressListener(TeaVMProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public ProblemProvider getProblemProvider() {
        return this.vm != null ? this.vm.getProblemProvider() : null;
    }

    public DependencyInfo getDependencyInfo() {
        return this.vm.getDependencyInfo();
    }

    public Collection<String> getClasses() {
        return this.vm != null ? this.vm.getClasses() : Collections.emptyList();
    }

    public Set<File> getGeneratedFiles() {
        return this.generatedFiles;
    }

    public Collection<String> getUsedResources() {
        if (this.vm == null) {
            return Collections.emptyList();
        }
        HashSet<String> resources = new HashSet<String>();
        ClassReaderSource classSource = this.vm.getDependencyClassSource();
        InstructionLocationReader reader = new InstructionLocationReader(resources);
        for (MethodReference methodRef : this.vm.getMethods()) {
            ProgramReader program;
            MethodReader method;
            ClassReader cls = classSource.get(methodRef.getClassName());
            if (cls == null || (method = cls.getMethod(methodRef.getDescriptor())) == null || (program = method.getProgram()) == null) continue;
            for (int i = 0; i < program.basicBlockCount(); ++i) {
                program.basicBlockAt(i).readAllInstructions(reader);
            }
        }
        return resources;
    }

    @Override
    public void addSourceFileProvider(SourceFileProvider sourceFileProvider) {
        this.sourceFileProviders.add(sourceFileProvider);
    }

    private TeaVMTarget prepareTarget() {
        switch (this.targetType) {
            case JAVASCRIPT: {
                return this.prepareJavaScriptTarget();
            }
            case WEBASSEMBLY: {
                return this.prepareWebAssemblyTarget();
            }
        }
        throw new IllegalStateException("Unknown target type: " + (Object)((Object)this.targetType));
    }

    private TeaVMTarget prepareJavaScriptTarget() {
        this.javaScriptTarget = new JavaScriptTarget();
        this.javaScriptTarget.setMinifying(this.minifying);
        this.debugEmitter = this.debugInformationGenerated || this.sourceMapsFileGenerated ? new DebugInformationBuilder() : null;
        this.javaScriptTarget.setDebugEmitter(this.debugEmitter);
        if (this.incremental) {
            this.javaScriptTarget.setAstCache(this.astCache);
        }
        return this.javaScriptTarget;
    }

    private WasmTarget prepareWebAssemblyTarget() {
        this.webAssemblyTarget = new WasmTarget();
        this.webAssemblyTarget.setDebugging(this.debugInformationGenerated);
        this.webAssemblyTarget.setCEmitted(this.debugInformationGenerated);
        this.webAssemblyTarget.setWastEmitted(this.debugInformationGenerated);
        this.webAssemblyTarget.setVersion(this.wasmVersion);
        return this.webAssemblyTarget;
    }

    public void generate() throws TeaVMToolException {
        try {
            this.cancelled = false;
            this.log.info("Building JavaScript file");
            TeaVMBuilder vmBuilder = new TeaVMBuilder(this.prepareTarget());
            if (this.incremental) {
                this.cacheDirectory.mkdirs();
                this.symbolTable = new FileSymbolTable(new File(this.cacheDirectory, "symbols"));
                this.fileTable = new FileSymbolTable(new File(this.cacheDirectory, "files"));
                ClasspathClassHolderSource innerClassSource = new ClasspathClassHolderSource(this.classLoader);
                PreOptimizingClassHolderSource classSource = new PreOptimizingClassHolderSource(innerClassSource);
                this.cachedClassSource = new DiskCachedClassHolderSource(this.cacheDirectory, this.symbolTable, this.fileTable, classSource, innerClassSource);
                this.programCache = new DiskProgramCache(this.cacheDirectory, this.symbolTable, this.fileTable, innerClassSource);
                if (this.targetType == TeaVMTargetType.JAVASCRIPT) {
                    this.astCache = new DiskRegularMethodNodeCache(this.cacheDirectory, this.symbolTable, this.fileTable, innerClassSource);
                }
                try {
                    this.symbolTable.update();
                    this.fileTable.update();
                }
                catch (IOException e) {
                    this.log.info("Cache is missing");
                }
                vmBuilder.setClassLoader(this.classLoader).setClassSource(this.cachedClassSource);
            } else {
                vmBuilder.setClassLoader(this.classLoader).setClassSource(new PreOptimizingClassHolderSource(new ClasspathClassHolderSource(this.classLoader)));
            }
            this.vm = vmBuilder.build();
            if (this.progressListener != null) {
                this.vm.setProgressListener(this.progressListener);
            }
            this.vm.setProperties(this.properties);
            this.vm.setProgramCache(this.programCache);
            this.vm.setIncremental(this.incremental);
            this.vm.setOptimizationLevel(this.optimizationLevel);
            this.vm.installPlugins();
            for (ClassHolderTransformer transformer : this.transformers) {
                this.vm.add(transformer);
            }
            if (this.mainClass != null) {
                MethodDescriptor mainMethodDesc = new MethodDescriptor("main", String[].class, Void.TYPE);
                this.vm.entryPoint("main", new MethodReference(this.mainClass, mainMethodDesc)).withValue(1, "[java.lang.String").withArrayValue(1, "java.lang.String").async();
            }
            for (ClassAlias alias : this.classAliases) {
                this.vm.exportType(alias.getAlias(), alias.getClassName());
            }
            for (MethodAlias methodAlias : this.methodAliases) {
                MethodReference ref = new MethodReference(methodAlias.getClassName(), methodAlias.getMethodName(), MethodDescriptor.parseSignature(methodAlias.getDescriptor()));
                TeaVMEntryPoint entryPoint = this.vm.entryPoint(methodAlias.getAlias(), ref).async();
                if (methodAlias.getTypes() == null) continue;
                for (int i = 0; i < methodAlias.getTypes().length; ++i) {
                    String types = methodAlias.getTypes()[i];
                    if (types == null) continue;
                    for (String type : types.split(" +")) {
                        if ((type = type.trim()).isEmpty()) continue;
                        entryPoint.withValue(i, type);
                    }
                }
            }
            this.targetDirectory.mkdirs();
            if (this.runtime == RuntimeCopyOperation.MERGED) {
                this.javaScriptTarget.add(this.runtimeInjector);
            }
            DirectoryBuildTarget buildTarget = new DirectoryBuildTarget(this.targetDirectory);
            String outputName = this.getResolvedTargetFileName();
            this.vm.build(buildTarget, outputName);
            if (this.vm.wasCancelled()) {
                this.log.info("Build cancelled");
                this.cancelled = true;
                return;
            }
            ProblemProvider problemProvider = this.vm.getProblemProvider();
            if (problemProvider.getProblems().isEmpty()) {
                this.log.info("Output file successfully built");
            } else if (problemProvider.getSevereProblems().isEmpty()) {
                this.log.info("Output file built with warnings");
                TeaVMProblemRenderer.describeProblems(this.vm, this.log);
            } else {
                this.log.info("Output file built with errors");
                TeaVMProblemRenderer.describeProblems(this.vm, this.log);
            }
            File outputFile = new File(this.targetDirectory, outputName);
            this.generatedFiles.add(outputFile);
            if (this.targetType == TeaVMTargetType.JAVASCRIPT) {
                try (FileOutputStream output = new FileOutputStream(new File(this.targetDirectory, outputName), true);
                     OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, "UTF-8");){
                    this.additionalJavaScriptOutput(writer);
                }
            }
            if (this.incremental) {
                this.programCache.flush();
                if (this.astCache != null) {
                    this.astCache.flush();
                }
                this.cachedClassSource.flush();
                this.symbolTable.flush();
                this.fileTable.flush();
                this.log.info("Cache updated");
            }
        }
        catch (IOException e) {
            throw new TeaVMToolException("IO error occurred", e);
        }
    }

    private String getResolvedTargetFileName() {
        if (this.targetFileName.isEmpty()) {
            switch (this.targetType) {
                case JAVASCRIPT: {
                    return "classes.js";
                }
                case WEBASSEMBLY: {
                    return "classes.wasm";
                }
            }
            return "classes";
        }
        return this.targetFileName;
    }

    private void additionalJavaScriptOutput(Writer writer) throws IOException {
        DebugInformation debugInfo;
        if (this.mainClass != null) {
            writer.append("main = $rt_mainStarter(main);\n");
        }
        if (this.debugInformationGenerated) {
            assert (this.debugEmitter != null);
            debugInfo = this.debugEmitter.getDebugInformation();
            File debugSymbolFile = new File(this.targetDirectory, this.getResolvedTargetFileName() + ".teavmdbg");
            try (BufferedOutputStream debugInfoOut = new BufferedOutputStream(new FileOutputStream(debugSymbolFile));){
                debugInfo.write(debugInfoOut);
            }
            this.generatedFiles.add(debugSymbolFile);
            this.log.info("Debug information successfully written");
        }
        if (this.sourceMapsFileGenerated) {
            assert (this.debugEmitter != null);
            debugInfo = this.debugEmitter.getDebugInformation();
            String sourceMapsFileName = this.getResolvedTargetFileName() + ".map";
            writer.append("\n//# sourceMappingURL=").append(sourceMapsFileName);
            File sourceMapsFile = new File(this.targetDirectory, sourceMapsFileName);
            try (OutputStreamWriter sourceMapsOut = new OutputStreamWriter((OutputStream)new FileOutputStream(sourceMapsFile), "UTF-8");){
                debugInfo.writeAsSourceMaps(sourceMapsOut, "src", this.getResolvedTargetFileName());
            }
            this.generatedFiles.add(sourceMapsFile);
            this.log.info("Source maps successfully written");
        }
        if (this.sourceFilesCopied) {
            this.copySourceFiles();
            this.log.info("Source files successfully written");
        }
        if (this.runtime == RuntimeCopyOperation.SEPARATE) {
            this.resourceToFile("org/teavm/backend/javascript/runtime.js", "runtime.js");
        }
    }

    private void copySourceFiles() {
        if (this.vm.getWrittenClasses() == null) {
            return;
        }
        SourceFilesCopier copier = new SourceFilesCopier(this.sourceFileProviders, this.generatedFiles::add);
        copier.addClasses(this.vm.getWrittenClasses());
        copier.setLog(this.log);
        copier.copy(new File(this.targetDirectory, "src"));
    }

    private void resourceToFile(String resource, String fileName) throws IOException {
        try (InputStream input = TeaVMTool.class.getClassLoader().getResourceAsStream(resource);){
            File outputFile = new File(this.targetDirectory, fileName);
            try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(outputFile));){
                IOUtils.copy((InputStream)new BufferedInputStream(input), (OutputStream)output);
            }
            this.generatedFiles.add(outputFile);
        }
    }

    private void resourceToWriter(String resource, Writer writer) throws IOException {
        try (InputStream input = TeaVMTool.class.getClassLoader().getResourceAsStream(resource);){
            IOUtils.copy((InputStream)new BufferedInputStream(input), (Writer)writer, (String)"UTF-8");
        }
    }
}

