/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.vm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.teavm.cache.NoCache;
import org.teavm.common.ServiceRepository;
import org.teavm.dependency.BootstrapMethodSubstitutor;
import org.teavm.dependency.DependencyChecker;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.Linker;
import org.teavm.diagnostics.AccumulationDiagnostics;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.diagnostics.ProblemProvider;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ListableClassHolderSource;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.MutableClassHolderSource;
import org.teavm.model.Program;
import org.teavm.model.ProgramCache;
import org.teavm.model.optimization.ArrayUnwrapMotion;
import org.teavm.model.optimization.ClassInitElimination;
import org.teavm.model.optimization.ConstantConditionElimination;
import org.teavm.model.optimization.Devirtualization;
import org.teavm.model.optimization.GlobalValueNumbering;
import org.teavm.model.optimization.Inlining;
import org.teavm.model.optimization.LoopInvariantMotion;
import org.teavm.model.optimization.MethodOptimization;
import org.teavm.model.optimization.MethodOptimizationContext;
import org.teavm.model.optimization.RedundantJumpElimination;
import org.teavm.model.optimization.ScalarReplacement;
import org.teavm.model.optimization.UnreachableBasicBlockElimination;
import org.teavm.model.optimization.UnusedVariableElimination;
import org.teavm.model.text.ListingBuilder;
import org.teavm.model.util.MissingItemsProcessor;
import org.teavm.model.util.ModelUtils;
import org.teavm.model.util.ProgramUtils;
import org.teavm.model.util.RegisterAllocator;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.DirectoryBuildTarget;
import org.teavm.vm.TeaVMBuilder;
import org.teavm.vm.TeaVMEntryPoint;
import org.teavm.vm.TeaVMOptimizationLevel;
import org.teavm.vm.TeaVMPhase;
import org.teavm.vm.TeaVMPluginLoader;
import org.teavm.vm.TeaVMProgressFeedback;
import org.teavm.vm.TeaVMProgressListener;
import org.teavm.vm.TeaVMTarget;
import org.teavm.vm.TeaVMTargetController;
import org.teavm.vm.spi.TeaVMHost;
import org.teavm.vm.spi.TeaVMHostExtension;
import org.teavm.vm.spi.TeaVMPlugin;

public class TeaVM
implements TeaVMHost,
ServiceRepository {
    private final ClassReaderSource classSource;
    private final DependencyChecker dependencyChecker;
    private final AccumulationDiagnostics diagnostics = new AccumulationDiagnostics();
    private final ClassLoader classLoader;
    private final Map<String, TeaVMEntryPoint> entryPoints = new HashMap<String, TeaVMEntryPoint>();
    private final Map<String, TeaVMEntryPoint> readonlyEntryPoints = Collections.unmodifiableMap(this.entryPoints);
    private final Map<String, String> exportedClasses = new HashMap<String, String>();
    private final Map<String, String> readonlyExportedClasses = Collections.unmodifiableMap(this.exportedClasses);
    private final Map<Class<?>, Object> services = new HashMap();
    private final Properties properties = new Properties();
    private ProgramCache programCache;
    private boolean incremental;
    private TeaVMOptimizationLevel optimizationLevel = TeaVMOptimizationLevel.SIMPLE;
    private TeaVMProgressListener progressListener;
    private boolean cancelled;
    private ListableClassHolderSource writtenClasses;
    private TeaVMTarget target;
    private Map<Class<?>, TeaVMHostExtension> extensions = new HashMap();
    private TeaVMTargetController targetController = new TeaVMTargetController(){

        @Override
        public boolean wasCancelled() {
            return TeaVM.this.wasCancelled();
        }

        @Override
        public ClassLoader getClassLoader() {
            return TeaVM.this.classLoader;
        }

        @Override
        public ClassReaderSource getUnprocessedClassSource() {
            return TeaVM.this.dependencyChecker.getClassSource();
        }

        @Override
        public DependencyInfo getDependencyInfo() {
            return TeaVM.this.dependencyChecker;
        }

        @Override
        public Diagnostics getDiagnostics() {
            return TeaVM.this.diagnostics;
        }

        @Override
        public Properties getProperties() {
            return TeaVM.this.properties;
        }

        @Override
        public ServiceRepository getServices() {
            return TeaVM.this;
        }

        @Override
        public boolean isIncremental() {
            return TeaVM.this.incremental;
        }

        @Override
        public Map<String, TeaVMEntryPoint> getEntryPoints() {
            return TeaVM.this.readonlyEntryPoints;
        }

        @Override
        public Map<String, String> getExportedClasses() {
            return TeaVM.this.readonlyExportedClasses;
        }

        @Override
        public boolean isFriendlyToDebugger() {
            return TeaVM.this.optimizationLevel == TeaVMOptimizationLevel.SIMPLE;
        }
    };

    TeaVM(TeaVMBuilder builder) {
        this.target = builder.target;
        this.classSource = builder.classSource;
        this.classLoader = builder.classLoader;
        this.dependencyChecker = new DependencyChecker(this.classSource, this.classLoader, this, this.diagnostics);
        this.progressListener = new TeaVMProgressListener(){

            @Override
            public TeaVMProgressFeedback progressReached(int progress) {
                return TeaVMProgressFeedback.CONTINUE;
            }

            @Override
            public TeaVMProgressFeedback phaseStarted(TeaVMPhase phase, int count) {
                return TeaVMProgressFeedback.CONTINUE;
            }
        };
        for (ClassHolderTransformer transformer : this.target.getTransformers()) {
            this.dependencyChecker.addClassTransformer(transformer);
        }
        for (DependencyListener listener : this.target.getDependencyListeners()) {
            this.dependencyChecker.addDependencyListener(listener);
        }
        for (TeaVMHostExtension extension : this.target.getHostExtensions()) {
            for (Class<? extends TeaVMHostExtension> extensionType : this.getExtensionTypes(extension)) {
                this.extensions.put(extensionType, extension);
            }
        }
    }

    @Override
    public void add(DependencyListener listener) {
        this.dependencyChecker.addDependencyListener(listener);
    }

    @Override
    public void add(ClassHolderTransformer transformer) {
        this.dependencyChecker.addClassTransformer(transformer);
    }

    @Override
    public void add(MethodReference methodRef, BootstrapMethodSubstitutor substitutor) {
        this.dependencyChecker.addBootstrapMethodSubstitutor(methodRef, substitutor);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setProperties(Properties properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll((Map<?, ?>)properties);
        }
    }

    @Override
    public Properties getProperties() {
        return new Properties(this.properties);
    }

    public ProgramCache getProgramCache() {
        return this.programCache;
    }

    public void setProgramCache(ProgramCache programCache) {
        this.programCache = programCache;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public TeaVMOptimizationLevel getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(TeaVMOptimizationLevel optimizationLevel) {
        this.optimizationLevel = optimizationLevel;
    }

    public TeaVMProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(TeaVMProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public ProblemProvider getProblemProvider() {
        return this.diagnostics;
    }

    public TeaVMEntryPoint entryPoint(String name, MethodReference ref) {
        if (name != null && this.entryPoints.containsKey(name)) {
            throw new IllegalArgumentException("Entry point with public name `" + name + "' already defined " + "for method " + ref);
        }
        TeaVMEntryPoint entryPoint = new TeaVMEntryPoint(name, ref, this.dependencyChecker.linkMethod(ref, null));
        this.dependencyChecker.linkClass(ref.getClassName(), null).initClass(null);
        if (name != null) {
            this.entryPoints.put(name, entryPoint);
        }
        return entryPoint;
    }

    public TeaVMEntryPoint entryPoint(MethodReference ref) {
        return this.entryPoint(null, ref);
    }

    public TeaVMEntryPoint linkMethod(MethodReference ref) {
        TeaVMEntryPoint entryPoint = new TeaVMEntryPoint("", ref, this.dependencyChecker.linkMethod(ref, null));
        this.dependencyChecker.linkClass(ref.getClassName(), null).initClass(null);
        return entryPoint;
    }

    public void exportType(String name, String className) {
        if (this.exportedClasses.containsKey(name)) {
            throw new IllegalArgumentException("Class with public name `" + name + "' already defined for class " + className);
        }
        this.dependencyChecker.linkClass(className, null).initClass(null);
        this.exportedClasses.put(name, className);
    }

    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    public ClassReaderSource getDependencyClassSource() {
        return this.dependencyChecker.getClassSource();
    }

    public Collection<String> getClasses() {
        return this.dependencyChecker.getReachableClasses();
    }

    public Collection<MethodReference> getMethods() {
        return this.dependencyChecker.getReachableMethods();
    }

    public DependencyInfo getDependencyInfo() {
        return this.dependencyChecker;
    }

    public ListableClassReaderSource getWrittenClasses() {
        return this.writtenClasses;
    }

    public void build(BuildTarget buildTarget, String outputName) {
        ListableClassHolderSource classSet;
        this.target.setController(this.targetController);
        this.reportPhase(TeaVMPhase.DEPENDENCY_CHECKING, 1);
        if (this.wasCancelled()) {
            return;
        }
        this.dependencyChecker.setInterruptor(() -> this.progressListener.progressReached(0) == TeaVMProgressFeedback.CONTINUE);
        this.target.contributeDependencies(this.dependencyChecker);
        this.dependencyChecker.processDependencies();
        if (this.wasCancelled() || !this.diagnostics.getSevereProblems().isEmpty()) {
            return;
        }
        this.reportPhase(TeaVMPhase.LINKING, 1);
        if (this.wasCancelled()) {
            return;
        }
        this.writtenClasses = classSet = this.link(this.dependencyChecker);
        if (this.wasCancelled()) {
            return;
        }
        this.reportPhase(TeaVMPhase.OPTIMIZATION, 1);
        if (!this.incremental) {
            this.devirtualize(classSet, this.dependencyChecker);
            if (this.wasCancelled()) {
                return;
            }
            this.inline(classSet, this.dependencyChecker);
            if (this.wasCancelled()) {
                return;
            }
        }
        this.optimize(classSet);
        if (this.wasCancelled()) {
            return;
        }
        try {
            this.target.emit(classSet, buildTarget, outputName);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating output files", e);
        }
    }

    public ListableClassHolderSource link(DependencyInfo dependency) {
        this.reportPhase(TeaVMPhase.LINKING, dependency.getReachableClasses().size());
        Linker linker = new Linker();
        MutableClassHolderSource cutClasses = new MutableClassHolderSource();
        MissingItemsProcessor missingItemsProcessor = new MissingItemsProcessor(dependency, this.diagnostics);
        if (this.wasCancelled()) {
            return cutClasses;
        }
        int index = 0;
        for (String className : dependency.getReachableClasses()) {
            ClassReader clsReader = dependency.getClassSource().get(className);
            if (clsReader == null) continue;
            ClassHolder cls = ModelUtils.copyClass(clsReader);
            cutClasses.putClassHolder(cls);
            missingItemsProcessor.processClass(cls);
            linker.link(dependency, cls);
            this.progressListener.progressReached(++index);
        }
        return cutClasses;
    }

    private void reportPhase(TeaVMPhase phase, int progressLimit) {
        if (this.progressListener.phaseStarted(phase, progressLimit) == TeaVMProgressFeedback.CANCEL) {
            this.cancelled = true;
        }
    }

    private void devirtualize(ListableClassHolderSource classes, DependencyInfo dependency) {
        if (this.wasCancelled()) {
            return;
        }
        Devirtualization devirtualization = new Devirtualization(dependency, classes);
        for (String className : classes.getClassNames()) {
            ClassHolder cls = classes.get(className);
            for (MethodHolder method : cls.getMethods()) {
                if (method.getProgram() == null) continue;
                devirtualization.apply(method);
            }
            if (!this.wasCancelled()) continue;
            return;
        }
    }

    private void inline(ListableClassHolderSource classes, DependencyInfo dependencyInfo) {
        ClassHolder cls;
        if (this.optimizationLevel != TeaVMOptimizationLevel.FULL) {
            return;
        }
        HashMap<MethodReference, Program> inlinedPrograms = new HashMap<MethodReference, Program>();
        Inlining inlining = new Inlining();
        for (String className : classes.getClassNames()) {
            cls = classes.get(className);
            for (MethodHolder method : cls.getMethods()) {
                if (method.getProgram() == null) continue;
                Program program = ProgramUtils.copy(method.getProgram());
                MethodOptimizationContextImpl context = new MethodOptimizationContextImpl(method, classes);
                inlining.apply(program, method.getReference(), classes, dependencyInfo);
                new UnusedVariableElimination().optimize(context, program);
                inlinedPrograms.put(method.getReference(), program);
            }
            if (!this.wasCancelled()) continue;
            return;
        }
        for (String className : classes.getClassNames()) {
            cls = classes.get(className);
            for (MethodHolder method : cls.getMethods()) {
                if (method.getProgram() == null) continue;
                method.setProgram((Program)inlinedPrograms.get(method.getReference()));
            }
        }
    }

    private void optimize(ListableClassHolderSource classSource) {
        for (String className : classSource.getClassNames()) {
            ClassHolder cls = classSource.get(className);
            for (MethodHolder method : cls.getMethods()) {
                this.processMethod(method, classSource);
            }
            if (!this.wasCancelled()) continue;
            return;
        }
    }

    private void processMethod(MethodHolder method, ListableClassReaderSource classSource) {
        if (method.getProgram() == null) {
            return;
        }
        boolean noCache = method.getAnnotations().get(NoCache.class.getName()) != null;
        Program optimizedProgram = this.incremental && !noCache && this.programCache != null ? this.programCache.get(method.getReference()) : null;
        MethodOptimizationContextImpl context = new MethodOptimizationContextImpl(method, classSource);
        if (optimizedProgram == null) {
            optimizedProgram = ProgramUtils.copy(method.getProgram());
            if (optimizedProgram.basicBlockCount() > 0) {
                boolean changed;
                do {
                    changed = false;
                    for (MethodOptimization optimization : this.getOptimizations()) {
                        try {
                            changed |= optimization.optimize(context, optimizedProgram);
                        }
                        catch (AssertionError | Exception e) {
                            ListingBuilder listingBuilder = new ListingBuilder();
                            String listing = listingBuilder.buildListing(optimizedProgram, "");
                            System.err.println("Error optimizing program for method " + method.getReference() + ":\n" + listing);
                            throw new RuntimeException((Throwable)e);
                        }
                    }
                } while (changed);
                this.target.afterOptimizations(optimizedProgram, method, classSource);
                if (this.target.requiresRegisterAllocation()) {
                    RegisterAllocator allocator = new RegisterAllocator();
                    allocator.allocateRegisters(method, optimizedProgram);
                }
            }
            if (this.incremental && this.programCache != null) {
                this.programCache.store(method.getReference(), optimizedProgram);
            }
        }
        method.setProgram(optimizedProgram);
    }

    private List<MethodOptimization> getOptimizations() {
        ArrayList<MethodOptimization> optimizations = new ArrayList<MethodOptimization>();
        optimizations.add(new RedundantJumpElimination());
        optimizations.add(new ArrayUnwrapMotion());
        if (this.optimizationLevel.ordinal() >= TeaVMOptimizationLevel.ADVANCED.ordinal()) {
            optimizations.add(new ScalarReplacement());
            optimizations.add(new LoopInvariantMotion());
        }
        optimizations.add(new GlobalValueNumbering(this.optimizationLevel == TeaVMOptimizationLevel.SIMPLE));
        if (this.optimizationLevel.ordinal() >= TeaVMOptimizationLevel.ADVANCED.ordinal()) {
            optimizations.add(new ConstantConditionElimination());
            optimizations.add(new RedundantJumpElimination());
            optimizations.add(new UnusedVariableElimination());
        }
        optimizations.add(new ClassInitElimination());
        optimizations.add(new UnreachableBasicBlockElimination());
        optimizations.add(new UnusedVariableElimination());
        return optimizations;
    }

    public void build(File dir, String fileName) {
        this.build(new DirectoryBuildTarget(dir), fileName);
    }

    public void installPlugins() {
        for (TeaVMPlugin plugin : TeaVMPluginLoader.load(this.classLoader)) {
            plugin.install(this);
        }
    }

    @Override
    public <T> T getService(Class<T> type) {
        Object service = this.services.get(type);
        if (service == null) {
            throw new IllegalArgumentException("Service not registered: " + type.getName());
        }
        return type.cast(service);
    }

    @Override
    public <T> void registerService(Class<T> type, T instance) {
        this.services.put(type, instance);
    }

    @Override
    public <T extends TeaVMHostExtension> T getExtension(Class<T> extensionType) {
        TeaVMHostExtension extension = this.extensions.get(extensionType);
        return (T)(extension != null ? (TeaVMHostExtension)extensionType.cast(extension) : null);
    }

    private Collection<Class<? extends TeaVMHostExtension>> getExtensionTypes(TeaVMHostExtension extension) {
        return Arrays.stream(extension.getClass().getInterfaces()).filter(cls -> cls.isInterface() && TeaVMHostExtension.class.isAssignableFrom((Class<?>)cls)).map(cls -> cls.asSubclass(TeaVMHostExtension.class)).collect(Collectors.toSet());
    }

    private class MethodOptimizationContextImpl
    implements MethodOptimizationContext {
        private MethodReader method;
        private ClassReaderSource classSource;

        public MethodOptimizationContextImpl(MethodReader method, ClassReaderSource classSource) {
            this.method = method;
            this.classSource = classSource;
        }

        @Override
        public MethodReader getMethod() {
            return this.method;
        }

        @Override
        public DependencyInfo getDependencyInfo() {
            return TeaVM.this.dependencyChecker;
        }

        @Override
        public ClassReaderSource getClassSource() {
            return this.classSource;
        }
    }
}

