/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.baton.util.pom;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.maven.model.InputLocation;
import org.codehaus.plexus.util.StringUtils;
import org.technologybrewery.baton.util.FileUtils;

public final class PomModifications
extends TreeSet<Modification> {
    public Final finalizeMods() {
        return new Final(this.iterator());
    }

    public static class Replacement
    extends Modification {
        private final InputLocation end;
        private final Function<String, String> contentProducer;
        private final int indentLvl;

        public Replacement(InputLocation start, InputLocation end, String content) {
            this(start, end, 0, l -> content);
        }

        public Replacement(InputLocation start, InputLocation end, int indentLvl, UnaryOperator<String> contentProducer) {
            super(start);
            this.end = end;
            this.contentProducer = contentProducer;
            this.indentLvl = indentLvl;
        }

        public InputLocation getEnd() {
            return this.end;
        }

        public Function<String, String> getContentProducer() {
            return this.contentProducer;
        }

        public int getIndentLvl() {
            return this.indentLvl;
        }

        @Override
        public int apply(BufferedReader in, Writer out, String line) throws IOException {
            int current = this.getStart().getLineNumber();
            String substring = line.substring(0, this.getStart().getColumnNumber() - 1);
            if (StringUtils.isNotBlank((String)substring)) {
                out.write(substring);
            }
            String indent = FileUtils.getIndent(line, this.getIndentLvl());
            out.write(this.getContentProducer().apply(indent));
            while (current < this.getEnd().getLineNumber()) {
                line = in.readLine();
                ++current;
            }
            if (this.getEnd().getColumnNumber() <= line.length()) {
                out.write(line.substring(this.getEnd().getColumnNumber() - 1));
                out.write("\n");
            }
            return current;
        }

        @Override
        public boolean equals(Object obj) {
            boolean match = false;
            if (obj instanceof Replacement) {
                match = this.compareTo((Replacement)obj) == 0;
            }
            return match;
        }
    }

    public static class Insertion
    extends Modification {
        private final Function<String, String> contentProducer;
        private final int currentIndent;

        public Insertion(InputLocation start, int currentIndent, UnaryOperator<String> contentProducer) {
            super(start);
            this.contentProducer = contentProducer;
            this.currentIndent = currentIndent;
        }

        @Override
        public int apply(BufferedReader in, Writer out, String line) throws IOException {
            String indent = FileUtils.getIndent(line, this.currentIndent);
            out.write(this.contentProducer.apply(indent));
            out.write(line);
            out.write("\n");
            return this.getStart().getLineNumber();
        }

        @Override
        public boolean equals(Object obj) {
            boolean match = false;
            if (obj instanceof Insertion) {
                match = this.compareTo((Insertion)obj) == 0;
            }
            return match;
        }
    }

    public static class Deletion
    extends Modification {
        private final InputLocation end;

        public Deletion(InputLocation start, InputLocation end) {
            super(start);
            this.end = end;
        }

        public InputLocation getEnd() {
            return this.end;
        }

        @Override
        public int apply(BufferedReader in, Writer out, String line) throws IOException {
            String substring;
            int current = this.getStart().getLineNumber();
            int startColumn = this.getStart().getColumnNumber();
            String string = substring = startColumn == 0 ? "" : line.substring(0, startColumn - 1);
            if (StringUtils.isNotBlank((String)substring)) {
                out.write(substring);
                out.write("\n");
            }
            while (current < this.getEnd().getLineNumber()) {
                line = in.readLine();
                ++current;
            }
            if (this.getEnd().getColumnNumber() <= line.length()) {
                out.write(line.substring(this.getEnd().getColumnNumber() - 1));
                out.write("\n");
            }
            return current;
        }

        @Override
        public boolean equals(Object obj) {
            boolean match = false;
            if (obj instanceof Deletion) {
                match = this.compareTo((Deletion)obj) == 0;
            }
            return match;
        }
    }

    public static abstract class Modification
    implements Comparable<Modification> {
        private final InputLocation start;

        protected Modification(InputLocation start) {
            this.start = start;
        }

        public InputLocation getStart() {
            return this.start;
        }

        public abstract int apply(BufferedReader var1, Writer var2, String var3) throws IOException;

        @Override
        public int compareTo(Modification o) {
            return Comparator.comparingInt(InputLocation::getLineNumber).thenComparingInt(InputLocation::getColumnNumber).compare(this.getStart(), o.getStart());
        }

        public boolean equals(Object obj) {
            boolean match = false;
            if (obj instanceof Modification) {
                match = this.compareTo((Modification)obj) == 0;
            }
            return match;
        }
    }

    public static class Final {
        private Iterator<Modification> iterator;
        private Modification next;

        private Final(Iterator<Modification> iterator) {
            this.iterator = iterator;
            this.next = iterator.next();
        }

        public boolean appliesTo(int lineNumber) {
            return this.next != null && this.next.getStart().getLineNumber() == lineNumber;
        }

        public int apply(BufferedReader in, Writer out, String line) throws IOException {
            int newInputLine = this.next.apply(in, out, line);
            this.next = this.iterator.hasNext() ? this.iterator.next() : null;
            return newInputLine;
        }
    }
}

