/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="clean", threadSafe=true)
public class CleanMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.basedir}/src/generated")
    private File generatedBasedir;
    @Parameter(required=true, defaultValue="${project.basedir}/src/generated-test")
    private File generatedTestBasedir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.removeDirectory(this.generatedBasedir);
        this.removeDirectory(this.generatedTestBasedir);
    }

    private void removeDirectory(File dir) {
        if (dir != null && dir.exists() && dir.isDirectory()) {
            this.getLog().info((CharSequence)("Deleting " + dir.getAbsolutePath()));
            try {
                FileUtils.deleteDirectory((File)dir);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Problem encountered removing a directory!", (Throwable)e);
            }
        }
    }
}

