/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.technologybrewery.fermenter.mda.PackageManager;
import org.technologybrewery.fermenter.mda.TypeManager;
import org.technologybrewery.fermenter.mda.element.ExpandedFamily;
import org.technologybrewery.fermenter.mda.element.ExpandedProfile;
import org.technologybrewery.fermenter.mda.element.Family;
import org.technologybrewery.fermenter.mda.element.Profile;
import org.technologybrewery.fermenter.mda.element.Target;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.generator.GenerationException;
import org.technologybrewery.fermenter.mda.generator.Generator;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepository;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;
import org.technologybrewery.fermenter.mda.metamodel.ModelRepositoryConfiguration;
import org.technologybrewery.fermenter.mda.util.MessageTracker;
import org.technologybrewery.fermenter.mda.util.PriorityMessage;
import org.technologybrewery.fermenter.mda.util.PriorityMessageService;

public final class GenerateSourcesHelper {
    protected static final String METAMODEL_PROPERTIES = "metamodel.properties";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final PriorityMessageService PRIORITY_MESSAGE_SERVICE = new PriorityMessageService();
    public static LoggerDelegate logger;

    private GenerateSourcesHelper() {
    }

    public static Map<String, ExpandedFamily> loadFamilies(InputStream familiesStream, Map<String, ExpandedFamily> families) throws IOException {
        List loadedFamilies = (List)OBJECT_MAPPER.readValue(familiesStream, (TypeReference)new TypeReference<List<Family>>(){});
        for (Family f : loadedFamilies) {
            families.put(f.getName(), new ExpandedFamily(f));
        }
        return families;
    }

    public static Map<String, Target> loadTargets(InputStream targetsStream, Map<String, Target> targets) throws IOException {
        List loadedTargets = (List)OBJECT_MAPPER.readValue(targetsStream, (TypeReference)new TypeReference<List<Target>>(){});
        for (Target t : loadedTargets) {
            targets.put(t.getName(), t);
        }
        return targets;
    }

    public static Map<String, ExpandedProfile> loadProfiles(InputStream profilesStream, Map<String, ExpandedProfile> profiles) throws IOException {
        List loadedProfiles = (List)OBJECT_MAPPER.readValue(profilesStream, (TypeReference)new TypeReference<List<Profile>>(){});
        for (Profile p : loadedProfiles) {
            profiles.put(p.getName(), new ExpandedProfile(p));
        }
        return profiles;
    }

    public static ModelInstanceRepository loadMetamodelRepository(ModelRepositoryConfiguration config, String modelInstanceRepositoryImplClazz, LoggerDelegate logger) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        GenerateSourcesHelper.logger = logger;
        long start = System.currentTimeMillis();
        logger.log(LoggerDelegate.LogLevel.INFO, String.format("START: loading metamodel repository implementation: %s ...", modelInstanceRepositoryImplClazz));
        Class<?> repoImplClass = Class.forName(modelInstanceRepositoryImplClazz);
        Class[] constructorParamTypes = new Class[]{ModelRepositoryConfiguration.class};
        Constructor<?> constructor = repoImplClass.getConstructor(constructorParamTypes);
        Object[] params = new Object[]{config};
        ModelInstanceRepository repository = (ModelInstanceRepository)constructor.newInstance(params);
        ModelInstanceRepositoryManager.setRepository(repository);
        repository.load();
        MessageTracker.getInstance().emitMessages(logger);
        if (MessageTracker.getInstance().hasErrors()) {
            throw new GenerationException("Errors encountered!");
        }
        long stop = System.currentTimeMillis();
        logger.log(LoggerDelegate.LogLevel.INFO, String.format("COMPLETE: metamodel repository loading in %d ms", stop - start));
        return repository;
    }

    public static void validateMetamodelRepository(ModelInstanceRepository metamodelRepository, LoggerDelegate logger) {
        long start = System.currentTimeMillis();
        logger.log(LoggerDelegate.LogLevel.INFO, "START: validating metamodel repository...");
        metamodelRepository.validate();
        long stop = System.currentTimeMillis();
        logger.log(LoggerDelegate.LogLevel.INFO, "COMPLETE: validation of metamodel repository in " + (stop - start) + "ms");
    }

    public static void performSourceGeneration(String targetProfile, Map<String, ExpandedProfile> profiles, Function<Target, GenerationContext> createGenerationContext, BiFunction<String, Collection<ExpandedProfile>, Exception> handleInvalidProfile, LoggerDelegate logger, File projectDir) throws Exception {
        long start = System.currentTimeMillis();
        ExpandedProfile profile = profiles.get(targetProfile);
        if (profile == null) {
            Exception invalidProfileException = handleInvalidProfile.apply(targetProfile, profiles.values());
            if (invalidProfileException != null) {
                throw invalidProfileException;
            }
        } else {
            if (profile.isDeprecated()) {
                PriorityMessage priorityMessage = new PriorityMessage();
                priorityMessage.setFilePath(projectDir.toString() + "/pom.xml");
                if (profile.getWarningMessage() == null || profile.getWarningMessage().isBlank()) {
                    String warningMessage = "The profile '" + profile.getName() + "' is deprecated, please replace all references to it.";
                    logger.log(LoggerDelegate.LogLevel.WARN, warningMessage);
                    priorityMessage.setMessage(warningMessage);
                } else {
                    logger.log(LoggerDelegate.LogLevel.WARN, profile.getWarningMessage());
                    priorityMessage.setMessage(profile.getWarningMessage());
                }
                PRIORITY_MESSAGE_SERVICE.addPriorityMessage(priorityMessage);
            }
            logger.log(LoggerDelegate.LogLevel.INFO, "Generating code for profile '" + profile.getName() + "'");
            for (Target target : profile.getTargets()) {
                logger.log(LoggerDelegate.LogLevel.DEBUG, "\tExecuting target '" + target.getName() + "'");
                GenerationContext context = createGenerationContext.apply(target);
                Class<?> clazz = Class.forName(target.getGenerator());
                Generator generator = (Generator)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                generator.setMetadataContext(target.getMetadataContext());
                generator.generate(context);
            }
            long stop = System.currentTimeMillis();
            logger.log(LoggerDelegate.LogLevel.INFO, "Generation completed in " + (stop - start) + "ms");
        }
    }

    public static void suppressKrauseningWarnings() {
        if (System.getProperty("KRAUSENING_BASE") == null) {
            File tempKrauseningLocation = Files.createTempDir();
            File tempBaseLocation = new File(tempKrauseningLocation, "base");
            tempBaseLocation.mkdir();
            File tempExtLocation = new File(tempKrauseningLocation, "ext");
            tempExtLocation.mkdir();
            try {
                Properties p = new Properties();
                String comments = "default file to suppress warnings";
                p.store(new FileWriter(new File(tempBaseLocation, METAMODEL_PROPERTIES)), comments);
                p.store(new FileWriter(new File(tempExtLocation, METAMODEL_PROPERTIES)), comments);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.setProperty("KRAUSENING_BASE", tempBaseLocation.getAbsolutePath());
            System.setProperty("KRAUSENING_EXTENSIONS", tempExtLocation.getAbsolutePath());
        }
        if (System.getProperty("KRAUSENING_PASSWORD") == null) {
            System.setProperty("KRAUSENING_PASSWORD", "stub");
        }
    }

    public static void cleanUp() {
        PackageManager.cleanUp();
        TypeManager.cleanUp();
        MessageTracker.cleanUp();
    }

    public static interface LoggerDelegate {
        public void log(LogLevel var1, String var2);

        public static enum LogLevel {
            TRACE,
            DEBUG,
            INFO,
            WARN,
            ERROR;

        }
    }
}

