/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.technologybrewery.fermenter.mda.GenerateSourcesHelper;
import org.technologybrewery.fermenter.mda.PackageManager;
import org.technologybrewery.fermenter.mda.TypeManager;
import org.technologybrewery.fermenter.mda.element.ExpandedFamily;
import org.technologybrewery.fermenter.mda.element.ExpandedProfile;
import org.technologybrewery.fermenter.mda.element.Target;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepository;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceUrl;
import org.technologybrewery.fermenter.mda.metamodel.ModelRepositoryConfiguration;
import org.technologybrewery.fermenter.mda.notification.NotificationService;
import org.technologybrewery.fermenter.mda.reporting.StatisticsService;
import org.technologybrewery.fermenter.mda.util.MessageTracker;

@Mojo(name="generate-sources", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class GenerateSourcesMojo
extends AbstractMojo {
    private static final org.apache.commons.logging.Log LOG = LogFactory.getLog(GenerateSourcesMojo.class);
    private Map<String, ExpandedProfile> profiles = new HashMap<String, ExpandedProfile>();
    private Map<String, Target> targets = new HashMap<String, Target>();
    private Map<String, ExpandedFamily> families = new HashMap<String, ExpandedFamily>();
    @Inject
    private StatisticsService statisticsService;
    @Inject
    private NotificationService notificationService;
    @Parameter(required=true, readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor plugin;
    @Parameter(required=true)
    private String profile;
    @Parameter
    private List<String> metadataDependencies;
    @Parameter
    private String basePackage;
    @Parameter
    private List<String> suppressedMessages;
    @Parameter(required=true, defaultValue="java")
    private String language;
    private String targetsFileLocation = "targets.json";
    private String profilesFileLocation = "profiles.json";
    private String familiesFileLocation = "families.json";
    @Parameter(required=false)
    private List<String> targetModelInstances;
    @Parameter(required=true, defaultValue="${project.basedir}/src/main")
    private File mainSourceRoot;
    @Parameter(required=true, defaultValue="${project.basedir}/src/generated")
    private File generatedSourceRoot;
    @Parameter(required=true, defaultValue="${project.basedir}/src/test")
    private File testSourceRoot;
    @Parameter(required=true, defaultValue="${project.basedir}/src/generated-test")
    private File generatedTestSourceRoot;
    @Parameter
    private File localMetadataRoot;
    @Parameter(required=true, defaultValue="${project.basedir}/src/main/resources/types.json")
    private File localTypes;
    @Parameter(required=true, defaultValue="org.technologybrewery.fermenter.mda.metamodel.DefaultModelInstanceRepository")
    private String metadataRepositoryImpl;
    @Parameter
    private Map<String, String> propertyVariables;
    private VelocityEngine engine;
    @Parameter(property="session", required=true, readonly=true)
    protected MavenSession session;
    protected GenerateSourcesHelper.LoggerDelegate mavenLoggerDelegate = new GenerateSourcesHelper.LoggerDelegate(){

        @Override
        public void log(GenerateSourcesHelper.LoggerDelegate.LogLevel level, String message) {
            Log log = GenerateSourcesMojo.this.getLog();
            switch (level) {
                case TRACE: 
                case DEBUG: {
                    log.debug((CharSequence)message);
                    break;
                }
                case INFO: {
                    log.info((CharSequence)message);
                    break;
                }
                case WARN: {
                    log.warn((CharSequence)message);
                    break;
                }
                case ERROR: {
                    log.error((CharSequence)message);
                    break;
                }
                default: {
                    log.info((CharSequence)message);
                }
            }
        }
    };

    public void execute() throws MojoExecutionException {
        GenerateSourcesHelper.suppressKrauseningWarnings();
        try {
            this.setup();
            GenerateSourcesHelper.performSourceGeneration(this.profile, this.profiles, this::createGenerationContext, this::handleInvalidProfile, this.mavenLoggerDelegate, this.project.getBasedir());
        }
        catch (Exception e) {
            String message = "Error while performing source generation";
            this.getLog().error((CharSequence)message, (Throwable)e);
            throw new MojoExecutionException(message, e);
        }
        finally {
            GenerateSourcesHelper.cleanUp();
        }
        this.notificationService.recordNotifications(this.getProject(), this.suppressedMessages);
    }

    private void setup() throws MojoExecutionException {
        if (this.metadataDependencies == null) {
            this.metadataDependencies = new ArrayList<String>();
        }
        this.updateMojoConfigsBasedOnLanguage();
        this.validateMojoConfigs();
        this.loadTargets();
        this.loadProfiles();
        this.loadFamilies();
        TypeManager.getInstance().loadLocalTypes(this.localTypes);
        if (this.isGeneratingJavaProject()) {
            try {
                this.project.addCompileSourceRoot(this.getJavaCompilePathForGeneratedSource());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not add generated Java source root to project compilation path list", (Exception)e);
            }
        }
        try {
            ModelRepositoryConfiguration config = this.createMetadataConfiguration();
            ModelInstanceRepository newRepository = GenerateSourcesHelper.loadMetamodelRepository(config, this.metadataRepositoryImpl, this.mavenLoggerDelegate);
            GenerateSourcesHelper.validateMetamodelRepository(newRepository, this.mavenLoggerDelegate);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | MalformedURLException e) {
            throw new MojoExecutionException("Could not successfully load metamodel repository", e);
        }
        this.engine = new VelocityEngine();
        this.engine.setProperty("resource.loaders", (Object)"classpath");
        this.engine.setProperty("resource.loader.classpath.class", (Object)ClasspathResourceLoader.class.getName());
        this.engine.init();
    }

    public void loadFamilies() throws MojoExecutionException {
        Enumeration<URL> familyEnumeration = null;
        try {
            familyEnumeration = ((Object)((Object)this)).getClass().getClassLoader().getResources(this.familiesFileLocation);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to find families", (Exception)ioe);
        }
        while (familyEnumeration.hasMoreElements()) {
            URL familiesResource = familyEnumeration.nextElement();
            this.getLog().info((CharSequence)String.format("Loading families from: %s", familiesResource.toString()));
            try {
                InputStream familiesStream = familiesResource.openStream();
                try {
                    this.families = GenerateSourcesHelper.loadFamilies(familiesStream, this.families);
                }
                finally {
                    if (familiesStream == null) continue;
                    familiesStream.close();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to parse " + this.familiesFileLocation, (Exception)e);
            }
        }
        for (ExpandedFamily f : this.families.values()) {
            f.dereference(this.families, this.profiles);
        }
    }

    public void loadTargets() throws MojoExecutionException {
        Enumeration<URL> targetEnumeration = null;
        try {
            targetEnumeration = ((Object)((Object)this)).getClass().getClassLoader().getResources(this.targetsFileLocation);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to find targets", (Exception)ioe);
        }
        while (targetEnumeration.hasMoreElements()) {
            URL targetsResource = targetEnumeration.nextElement();
            this.getLog().info((CharSequence)String.format("Loading targets from: %s", targetsResource.toString()));
            try {
                InputStream targetsStream = targetsResource.openStream();
                try {
                    this.targets = GenerateSourcesHelper.loadTargets(targetsStream, this.targets);
                }
                finally {
                    if (targetsStream == null) continue;
                    targetsStream.close();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to parse " + this.targetsFileLocation, (Exception)e);
            }
        }
    }

    public void loadProfiles() throws MojoExecutionException {
        Enumeration<URL> profileEnumeration = null;
        try {
            profileEnumeration = ((Object)((Object)this)).getClass().getClassLoader().getResources(this.profilesFileLocation);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to find profiles", (Exception)ioe);
        }
        while (profileEnumeration.hasMoreElements()) {
            URL profilesResource = profileEnumeration.nextElement();
            this.getLog().info((CharSequence)String.format("Loading profiles from: %s", profilesResource.toString()));
            try {
                InputStream profilesStream = profilesResource.openStream();
                try {
                    this.profiles = GenerateSourcesHelper.loadProfiles(profilesStream, this.profiles);
                }
                finally {
                    if (profilesStream == null) continue;
                    profilesStream.close();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to parse " + this.profilesFileLocation, (Exception)e);
            }
        }
        for (ExpandedProfile p : this.profiles.values()) {
            p.dereference(this.profiles, this.targets);
        }
    }

    private ModelRepositoryConfiguration createMetadataConfiguration() throws MalformedURLException {
        ModelRepositoryConfiguration config = new ModelRepositoryConfiguration();
        config.setArtifactId(this.project.getArtifactId());
        config.setBasePackage(this.basePackage);
        List<Object> targetedArtifactIds = new ArrayList<String>();
        if (CollectionUtils.isEmpty(this.targetModelInstances)) {
            targetedArtifactIds.add(this.project.getArtifactId());
        } else {
            targetedArtifactIds = this.targetModelInstances;
        }
        if (targetedArtifactIds.size() > 1 || !targetedArtifactIds.contains(this.project.getArtifactId())) {
            LOG.info((Object)("Generation targets (" + targetedArtifactIds.size() + ") are different from project's local metadata (" + targetedArtifactIds.toString() + ")"));
        }
        config.setTargetModelInstances(targetedArtifactIds);
        Map<String, ModelInstanceUrl> metadataUrls = config.getMetamodelInstanceLocations();
        String projectUrl = this.getLocalMetadataRoot().toURI().toURL().toString();
        metadataUrls.put(this.project.getArtifactId(), new ModelInstanceUrl(this.project.getArtifactId(), projectUrl));
        PackageManager.addMapping(this.project.getArtifactId(), this.basePackage);
        if (this.metadataDependencies != null) {
            this.metadataDependencies.add(this.project.getArtifactId());
            List artifacts = this.plugin.getArtifacts();
            for (Artifact a : artifacts) {
                if (!this.metadataDependencies.contains(a.getArtifactId())) continue;
                URL url = a.getFile().toURI().toURL();
                metadataUrls.put(a.getArtifactId(), new ModelInstanceUrl(a.getArtifactId(), url.toString()));
                PackageManager.addMapping(a.getArtifactId(), url, a.getGroupId());
                LOG.info((Object)("Adding metadataDependency to current set of metadata: " + a.getArtifactId()));
            }
        }
        return config;
    }

    protected void updateMojoConfigsBasedOnLanguage() {
        if (this.isGeneratingPythonProject()) {
            String pythonPackageFolder = this.getPythonPackageFolderForProject();
            this.mainSourceRoot = new File(this.project.getBasedir(), String.format("src/%s", pythonPackageFolder));
            this.generatedSourceRoot = new File(this.project.getBasedir(), String.format("src/%s/generated", pythonPackageFolder));
            this.testSourceRoot = new File(this.project.getBasedir(), "tests");
            this.generatedTestSourceRoot = new File(this.project.getBasedir(), "tests");
            this.localTypes = new File(this.mainSourceRoot, "resources/types.json");
            if (StringUtils.isEmpty((CharSequence)this.basePackage)) {
                this.basePackage = pythonPackageFolder;
            }
        }
    }

    protected void validateMojoConfigs() throws MojoExecutionException {
        MessageTracker messageTracker = MessageTracker.getInstance();
        if (this.isGeneratingJavaProject() && StringUtils.isEmpty((CharSequence)this.basePackage)) {
            messageTracker.addErrorMessage("<basePackage> must be specified for Java-based projects");
        }
        if (messageTracker.hasErrors()) {
            messageTracker.emitMessages(this.mavenLoggerDelegate);
            throw new MojoExecutionException("Provided configuration was invalid!");
        }
    }

    private Exception handleInvalidProfile(String targetProfile, Collection<ExpandedProfile> allProfiles) {
        StringBuilder sb = new StringBuilder();
        TreeSet<ExpandedProfile> orderedProfiles = new TreeSet<ExpandedProfile>(allProfiles);
        for (ExpandedProfile profileValue : orderedProfiles) {
            sb.append("\t- ").append(profileValue.getName()).append("\n");
        }
        this.getLog().error((CharSequence)("\n<plugin>\n\t<groupId>org.technologybrewery.fermenter</groupId>\n\t<artifactId>fermenter-mda</artifactId>\n\t...\n\t<configuration>\n\t\t<profile>" + targetProfile + "</profile>   <-----------  INVALID PROFILE!\n\t\t...\n\t</configuration>\n</plugin>\nProfile '" + targetProfile + "' is invalid.  Please choose one of the following valid profiles:\n" + sb.toString()));
        return new MojoExecutionException("Invalid profile specified: '" + targetProfile + "'");
    }

    protected GenerationContext createGenerationContext(Target target) {
        GenerationContext context = new GenerationContext(target);
        context.setStatisticsService(this.statisticsService);
        context.setBasePackage(this.basePackage);
        context.setProjectDirectory(this.project.getBasedir());
        context.setGeneratedSourceDirectory(this.generatedSourceRoot);
        context.setMainSourceDirectory(this.mainSourceRoot);
        context.setTestSourceDirectory(this.testSourceRoot);
        context.setGeneratedTestSourceDirectory(this.generatedTestSourceRoot);
        context.setEngine(this.engine);
        context.setGroupId(this.project.getGroupId());
        context.setArtifactId(this.project.getArtifactId());
        context.setVersion(this.project.getVersion());
        context.setDescriptiveName(this.project.getName());
        if (this.project.getScm() != null) {
            context.setScmUrl(this.project.getScm().getUrl());
        }
        context.setPropertyVariables(this.propertyVariables);
        context.setExecutionRootDirectory(new File(this.session.getExecutionRootDirectory()));
        String rootArtifactId = this.getRootArtifactId();
        context.setRootArtifactId(rootArtifactId);
        return context;
    }

    protected boolean isGeneratingJavaProject() {
        return "java".equalsIgnoreCase(this.language) && !"habushu".equals(this.getProject().getPackaging());
    }

    protected boolean isGeneratingPythonProject() {
        return "python".equalsIgnoreCase(this.language) || "habushu".equals(this.project.getPackaging()) && !this.isLegacyHabushuProject();
    }

    protected boolean isLegacyHabushuProject() {
        Plugin habushuMavenPlugin = this.project.getPlugin("org.bitbucket.cpointe.habushu:habushu-maven-plugin");
        if (habushuMavenPlugin != null) {
            ComparableVersion habushuVersion = new ComparableVersion(habushuMavenPlugin.getVersion());
            return habushuVersion.compareTo(new ComparableVersion("2.0.0")) < 0;
        }
        return false;
    }

    protected String getPythonPackageFolderForProject() {
        return StringUtils.replace((String)this.getProject().getArtifactId(), (String)"-", (String)"_");
    }

    protected String getJavaCompilePathForGeneratedSource() throws IOException {
        return new File(this.generatedSourceRoot, "java").getCanonicalPath();
    }

    protected File getLocalMetadataRoot() {
        return this.localMetadataRoot != null ? this.localMetadataRoot : new File(this.mainSourceRoot, "resources");
    }

    public Map<String, ExpandedFamily> getFamilies() {
        return this.families;
    }

    public Map<String, ExpandedProfile> getProfiles() {
        return this.profiles;
    }

    public Map<String, Target> getTargets() {
        return this.targets;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public Map<String, String> getPropertyVariables() {
        return this.propertyVariables;
    }

    public void setPropertyVariables(Map<String, String> propertyVariables) {
        this.propertyVariables = propertyVariables;
    }

    public String getTargetsFileLocation() {
        return this.targetsFileLocation;
    }

    public void setTargetsFileLocation(String targetsFileLocation) {
        this.targetsFileLocation = targetsFileLocation;
    }

    public String getProfilesFileLocation() {
        return this.profilesFileLocation;
    }

    public void setProfilesFileLocation(String profilesFileLocation) {
        this.profilesFileLocation = profilesFileLocation;
    }

    public MavenProject getProject() {
        return this.project;
    }

    protected File getMainSourceRoot() {
        return this.mainSourceRoot;
    }

    protected File getGeneratedSourceRoot() {
        return this.generatedSourceRoot;
    }

    public String getRootArtifactId() {
        MavenProject topLevelProject = this.session.getTopLevelProject();
        String rootArtifactId = topLevelProject.getArtifactId();
        return rootArtifactId;
    }
}

