/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageManager {
    private static final Logger logger = LoggerFactory.getLogger(PackageManager.class);
    private static ThreadLocal<PackageManager> threadBoundInstance = ThreadLocal.withInitial(PackageManager::new);
    private Map<String, String> artifactIdToBasePackage = new HashMap<String, String>();

    private PackageManager() {
    }

    private static PackageManager getInstance() {
        return threadBoundInstance.get();
    }

    public static String getBasePackage(String artifactId) {
        return PackageManager.getInstance().artifactIdToBasePackage.get(artifactId);
    }

    public static void addMapping(String artifactId, URL url, String defaultPackageName) {
        try (InputStream stream = PackageManager.processURL(url);){
            Properties props = new Properties();
            props.load(stream);
            PackageManager.getInstance().artifactIdToBasePackage.put(artifactId, props.getProperty("basePackage"));
        }
        catch (IOException ex) {
            logger.debug("Could not find package properties for artifactId '{}' at URL {}", (Object)artifactId, (Object)url.getPath());
            logger.debug("Using default package name ('{}') for artifactId '{}' instead", (Object)defaultPackageName, (Object)artifactId);
            PackageManager.getInstance().artifactIdToBasePackage.put(artifactId, defaultPackageName);
        }
    }

    public static void addMapping(String artifactId, String basePackage) {
        PackageManager.getInstance().artifactIdToBasePackage.put(artifactId, basePackage);
    }

    private static InputStream processURL(URL url) throws IOException {
        Object sUrl = url.toString();
        if (((String)sUrl).indexOf(".jar") != -1) {
            sUrl = "jar:" + url + "!/package.properties";
            URL jarUrl = new URL((String)sUrl);
            JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
            return jarConnection.getInputStream();
        }
        return url.openStream();
    }

    public static void cleanUp() {
        threadBoundInstance.remove();
    }
}

