/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.mda.element.Type;
import org.technologybrewery.fermenter.mda.generator.GenerationException;
import org.technologybrewery.fermenter.mda.util.JsonUtils;

public class TypeManager {
    private static final String UNDEFINED_TYPE = "<undefined type>";
    private static final Logger logger = LoggerFactory.getLogger(TypeManager.class);
    private static ThreadLocal<TypeManager> threadBoundInstance = ThreadLocal.withInitial(TypeManager::new);
    private Map<String, Type> types = new HashMap<String, Type>();

    public static TypeManager getInstance() {
        return threadBoundInstance.get();
    }

    public static void cleanUp() {
        threadBoundInstance.remove();
    }

    private TypeManager() {
        this.load();
    }

    protected void load() {
        try {
            Enumeration<URL> urls = this.getClass().getClassLoader().getResources("types.json");
            while (urls.hasMoreElements()) {
                URL typesResource = urls.nextElement();
                logger.info("Loading types from: {}", (Object)typesResource);
                this.processTypesFile(typesResource);
            }
        }
        catch (IOException e) {
            throw new GenerationException("Could not load types.json!", e);
        }
    }

    public void loadLocalTypes(File localTypes) {
        try {
            logger.info("Checking for local types at: {}...", (Object)localTypes.getCanonicalFile());
            if (localTypes.exists()) {
                URL localTypeUrl = localTypes.toURI().toURL();
                logger.info("Loading types from: {}", (Object)localTypeUrl);
                this.processTypesFile(localTypeUrl);
            }
        }
        catch (IOException e) {
            throw new GenerationException("Could not load local types!", e);
        }
    }

    private void processTypesFile(URL typesResource) {
        ObjectMapper objectMapper = JsonUtils.getObjectMapper();
        try (InputStream typesStream = typesResource.openStream();){
            List loadedTypes = (List)objectMapper.readValue(typesStream, (TypeReference)new TypeReference<List<Type>>(){});
            for (Type type : loadedTypes) {
                this.types.put(type.getName(), type);
            }
        }
        catch (IOException e) {
            throw new GenerationException("Unable to parse types.json", e);
        }
    }

    protected Map<String, Type> getTypeMap() {
        return this.types;
    }

    public static String getFullyQualifiedType(String name) {
        String fullyQualifiedType = null;
        Type type = TypeManager.getInstance().getTypeMap().get(name);
        if (type == null) {
            logger.error("Type {} could not be found during a request for fullyQualifiedImplementation!", (Object)name);
            fullyQualifiedType = UNDEFINED_TYPE;
        } else {
            fullyQualifiedType = type.getFullyQualifiedImplementation();
        }
        return fullyQualifiedType;
    }

    public static String getShortType(String name) {
        String shortType = null;
        Type type = TypeManager.getInstance().getTypeMap().get(name);
        if (type == null) {
            logger.error("Type {} could not be found during a request for shortImplementation!", (Object)name);
            shortType = UNDEFINED_TYPE;
        } else {
            shortType = type.getShortImplementation();
        }
        return shortType;
    }
}

