/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.element;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.technologybrewery.fermenter.mda.element.ExpandedProfile;
import org.technologybrewery.fermenter.mda.element.Family;
import org.technologybrewery.fermenter.mda.element.Profile;
import org.technologybrewery.fermenter.mda.element.ProfileReference;
import org.technologybrewery.fermenter.mda.util.MessageTracker;

public class ExpandedFamily {
    private static MessageTracker messageTracker = MessageTracker.getInstance();
    protected Family Family;
    protected Map<String, Profile> profiles = new HashMap<String, Profile>();
    protected Map<String, ExpandedFamily> includes = new HashMap<String, ExpandedFamily>();
    protected boolean isDereferenced;

    public ExpandedFamily(Family Family2) {
        this.Family = Family2;
    }

    public String getName() {
        return this.Family.getName();
    }

    public void addProfile(Profile profile) {
        this.profiles.put(profile.getName(), profile);
    }

    public List<Profile> getProfiles() {
        return ImmutableList.copyOf(this.profiles.values());
    }

    public void addReferencedFamily(ExpandedFamily Family2) {
        this.includes.put(Family2.getName(), Family2);
    }

    public List<ExpandedFamily> getReferencedFamilies() {
        return ImmutableList.copyOf(this.includes.values());
    }

    public void dereference(Map<String, ExpandedFamily> families, Map<String, ExpandedProfile> profiles) {
        if (!this.isDereferenced) {
            this.isDereferenced = true;
            for (ProfileReference profileRef : this.Family.getProfileReferences()) {
                ExpandedProfile profile = profiles.get(profileRef.getName());
                if (profile != null) {
                    this.addProfile(profile.profile);
                    continue;
                }
                messageTracker.addErrorMessage("Could not find profile '" + profileRef.getName() + "' referenced by Family '" + this.getName() + "'!");
            }
        }
    }
}

