/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.element;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.technologybrewery.fermenter.mda.element.Profile;
import org.technologybrewery.fermenter.mda.element.ProfileReference;
import org.technologybrewery.fermenter.mda.element.Target;
import org.technologybrewery.fermenter.mda.element.TargetReference;
import org.technologybrewery.fermenter.mda.util.MessageTracker;

public class ExpandedProfile
implements Comparable<ExpandedProfile> {
    private static MessageTracker messageTracker = MessageTracker.getInstance();
    protected Profile profile;
    protected Map<String, Target> targets = new HashMap<String, Target>();
    protected Map<String, ExpandedProfile> includes = new HashMap<String, ExpandedProfile>();
    protected boolean isDereferenced;

    public ExpandedProfile(Profile profile) {
        this.profile = profile;
    }

    public String getName() {
        return this.profile.getName();
    }

    public boolean isDeprecated() {
        return this.profile.isDeprecated();
    }

    public String getWarningMessage() {
        return this.profile.getWarningMessage();
    }

    public void addTarget(Target target) {
        this.targets.put(target.getName(), target);
    }

    public List<Target> getTargets() {
        return ImmutableList.copyOf(this.targets.values());
    }

    public void addReferencedProfile(ExpandedProfile profile) {
        this.includes.put(profile.getName(), profile);
    }

    public List<ExpandedProfile> getReferencedProfiles() {
        return ImmutableList.copyOf(this.includes.values());
    }

    public void dereference(Map<String, ExpandedProfile> profiles, Map<String, Target> targets) {
        if (!this.isDereferenced) {
            this.isDereferenced = true;
            for (TargetReference targetRef : this.profile.getTargetReferences()) {
                Target target = targets.get(targetRef.getName());
                if (target != null) {
                    this.addTarget(target);
                    continue;
                }
                messageTracker.addErrorMessage("Could not find target '" + targetRef.getName() + "' referenced by profile '" + this.getName() + "'!");
            }
            this.dereferenceProfilesReferences(profiles, targets);
        }
    }

    private void transferTargetsFromProfile(String profileName, Map<String, ExpandedProfile> profiles, Map<String, Target> targets) {
        ExpandedProfile extendsProfile;
        ExpandedProfile expandedProfile = extendsProfile = profiles != null ? profiles.get(profileName) : null;
        if (extendsProfile != null) {
            if (!extendsProfile.isDereferenced) {
                extendsProfile.dereference(profiles, targets);
            }
            List<Target> extendsTargets = extendsProfile.getTargets();
            for (Target t : extendsTargets) {
                this.addTarget(t);
            }
        } else {
            messageTracker.addErrorMessage("Profile '" + profileName + "' does not exist in profile '" + this.getName() + "'!");
        }
    }

    private void dereferenceProfilesReferences(Map<String, ExpandedProfile> profiles, Map<String, Target> targets) {
        for (ProfileReference nameOnlyProfile : this.profile.profileReferences) {
            String profileName = nameOnlyProfile.getName();
            if (!StringUtils.isNotBlank((CharSequence)profileName)) continue;
            if (profileName.equals(this.getName())) {
                messageTracker.addWarningMessage("Profile '" + this.getName() + "' cannot include itself!");
                continue;
            }
            this.transferTargetsFromProfile(profileName, profiles, targets);
        }
    }

    @Override
    public int compareTo(ExpandedProfile other) {
        CompareToBuilder compareToBuilder = new CompareToBuilder().append((Object)this.getName(), (Object)other.getName());
        return compareToBuilder.toComparison();
    }
}

