/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.generator;

import com.google.common.base.CaseFormat;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.generator.GenerationException;
import org.technologybrewery.fermenter.mda.generator.Generator;
import org.technologybrewery.fermenter.mda.reporting.StatisticsService;

public abstract class AbstractGenerator
implements Generator {
    protected static final String VERSION = "version";
    protected static final String ARTIFACT_ID = "artifactId";
    protected static final String GROUP_ID = "groupId";
    protected static final String CAPITALIZED_CAMEL_CASED_ARTIFACT_ID = "capitalizedCamelCasedArtifactId";
    protected static final String CAMEL_CASED_ARTIFACT_ID = "camelCasedArtifactId";
    private static final String UPPER_UNDERSCORE_ARTIFACT_ID = "upperUnderscoreArtifactId";
    private static final String TEMPLATE_NAME = "templateName";
    protected String metadataContext;

    protected final void generateFile(GenerationContext gc, VelocityContext vc) {
        try {
            Template template = gc.getEngine().getTemplate(gc.getTemplateName());
            long templateLastModified = template.getLastModified();
            File baseFile = this.getBaseFile(gc);
            String baseFileName = this.getOutputSubFolder() + gc.getOutputFile();
            String tempFileName = baseFileName + ".tmp";
            File destinationFile = new File(baseFile, baseFileName);
            File tempFile = new File(baseFile, tempFileName);
            StatisticsService statisticsService = gc.getStatisticsService();
            statisticsService.recordStats(template, destinationFile, vc);
            boolean isCleanWrite = false;
            if (destinationFile.exists()) {
                if (!gc.isOverwritable()) {
                    return;
                }
                if (destinationFile.lastModified() < templateLastModified) {
                    isCleanWrite = true;
                }
            } else {
                isCleanWrite = true;
            }
            File outputFile = isCleanWrite || gc.isAppend() ? destinationFile : tempFile;
            outputFile.getParentFile().mkdirs();
            FileWriter fw = new FileWriter(outputFile, true);
            template.merge((Context)vc, (Writer)fw);
            ((Writer)fw).close();
            if (!isCleanWrite) {
                if (gc.isAppend()) {
                    return;
                }
                boolean isContentEqual = FileUtils.contentEquals((File)destinationFile, (File)tempFile);
                if (!isContentEqual) {
                    destinationFile.delete();
                    tempFile.renameTo(destinationFile);
                } else {
                    tempFile.deleteOnExit();
                }
            }
        }
        catch (Exception ex) {
            throw new GenerationException("Unable to generate file", ex);
        }
    }

    protected File getBaseFile(GenerationContext gc) {
        boolean isTest = "test".equalsIgnoreCase(gc.getArtifactType());
        File baseFile = gc.isOverwritable() ? (isTest ? gc.getGeneratedTestSourceDirectory() : gc.getGeneratedSourceDirectory()) : (isTest ? gc.getTestSourceDirectory() : gc.getMainSourceDirectory());
        return baseFile;
    }

    protected VelocityContext getNewVelocityContext(GenerationContext gc) {
        VelocityContext vc = new VelocityContext();
        vc.put(GROUP_ID, (Object)gc.getGroupId());
        vc.put(ARTIFACT_ID, (Object)gc.getArtifactId());
        vc.put(VERSION, (Object)gc.getVersion());
        vc.put(TEMPLATE_NAME, (Object)gc.getTemplateName());
        String camelCasedArtifactId = this.getCamelCasedArtifactId(gc);
        vc.put(CAMEL_CASED_ARTIFACT_ID, (Object)camelCasedArtifactId);
        vc.put(CAPITALIZED_CAMEL_CASED_ARTIFACT_ID, (Object)StringUtils.capitalize((String)camelCasedArtifactId));
        vc.put(UPPER_UNDERSCORE_ARTIFACT_ID, (Object)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, camelCasedArtifactId));
        return vc;
    }

    @Override
    public void setMetadataContext(String metadataContext) {
        this.metadataContext = metadataContext;
    }

    protected String deriveArtifactIdFromCamelCase(String camelCasedString) {
        StringBuilder artifactId = new StringBuilder();
        String[] splitStrings = StringUtils.splitByCharacterTypeCamelCase((String)camelCasedString);
        boolean isFirst = true;
        for (String segment : splitStrings) {
            if (isFirst) {
                isFirst = false;
            } else {
                artifactId.append('-');
            }
            artifactId.append(StringUtils.uncapitalize((String)segment));
        }
        return artifactId.toString();
    }

    private String getCamelCasedArtifactId(GenerationContext gc) {
        String upperCaseSubsequentWords = WordUtils.capitalizeFully((String)gc.getArtifactId(), (char[])new char[]{'-'});
        String lowerCaseFirstLetter = WordUtils.uncapitalize((String)upperCaseSubsequentWords);
        return lowerCaseFirstLetter.replace("-", "");
    }

    protected abstract String getOutputSubFolder();

    protected final String replace(String targetVariableName, String original, String replacement) {
        return StringUtils.replace((String)original, (String)("${" + targetVariableName + "}"), (String)replacement);
    }

    protected final String replaceBasePackage(String original, String basePackage) {
        return StringUtils.replace((String)original, (String)"${basePackage}", (String)basePackage);
    }

    @Deprecated
    protected final String replaceEntityName(String original, String entityName) {
        return StringUtils.replace((String)original, (String)"${entityName}", (String)entityName);
    }

    @Deprecated
    protected final String replaceServiceName(String original, String serviceName) {
        return StringUtils.replace((String)original, (String)"${serviceName}", (String)serviceName);
    }

    @Deprecated
    protected final String replaceRuleName(String original, String ruleName) {
        return StringUtils.replace((String)original, (String)"${ruleName}", (String)ruleName);
    }

    @Deprecated
    protected final String replaceRuleGroup(String original, String ruleGroupName) {
        return StringUtils.replace((String)original, (String)"${ruleGroupName}", (String)ruleGroupName);
    }

    @Deprecated
    protected final String replaceEnumerationName(String original, String enumerationName) {
        return StringUtils.replace((String)original, (String)"${enumerationName}", (String)enumerationName);
    }

    @Deprecated
    protected final String replaceMessageGroupName(String original, String messageGroupName) {
        return StringUtils.replace((String)original, (String)"${messageGroupName}", (String)messageGroupName);
    }

    protected final String replaceArtifactId(String original, String artifactId) {
        return StringUtils.replace((String)original, (String)"${artifactId}", (String)artifactId);
    }

    protected final String replaceCapitalizedCamelCasedArtifactId(String original, String capitalizedCamelCaseArtifactId) {
        return StringUtils.replace((String)original, (String)"${capitalizedCamelCasedArtifactId}", (String)capitalizedCamelCaseArtifactId);
    }
}

