/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.generator.entity;

import java.util.Iterator;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.AbstractGenerator;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.generator.GenerationException;
import org.technologybrewery.fermenter.mda.metamodel.DefaultModelInstanceRepository;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;
import org.technologybrewery.fermenter.mda.metamodel.element.Entity;

public abstract class AbstractEntityGenerator
extends AbstractGenerator {
    @Override
    public void generate(GenerationContext context) throws GenerationException {
        DefaultModelInstanceRepository metamodelRepository = ModelInstanceRepositoryManager.getMetamodelRepository(DefaultModelInstanceRepository.class);
        Map<String, Entity> entityMap = metamodelRepository.getEntitiesByContext(this.metadataContext);
        Iterator<Entity> entities = entityMap.values().iterator();
        String basefileName = context.getOutputFile();
        basefileName = this.replaceBasePackage(basefileName, context.getBasePackageAsPath());
        while (entities.hasNext()) {
            Entity entity = entities.next();
            if (this.generatePersistentEntitiesOnly() && (!this.generatePersistentEntitiesOnly() || entity.isTransient().booleanValue() || entity.isNonPersistentParentEntity().booleanValue())) continue;
            VelocityContext vc = new VelocityContext();
            this.populateVelocityContext(vc, entity, context);
            String fileName = this.replaceEntityName(basefileName, entity.getName());
            context.setOutputFile(fileName);
            this.generateFile(context, vc);
        }
    }

    protected abstract void populateVelocityContext(VelocityContext var1, Entity var2, GenerationContext var3);

    protected abstract boolean generatePersistentEntitiesOnly();
}

