/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.aeonbits.owner.KrauseningConfigFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.mda.exception.FermenterException;
import org.technologybrewery.fermenter.mda.generator.GenerationException;
import org.technologybrewery.fermenter.mda.metamodel.MetamodelConfig;
import org.technologybrewery.fermenter.mda.metamodel.ModelContext;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceUrl;
import org.technologybrewery.fermenter.mda.metamodel.ModelRepositoryConfiguration;
import org.technologybrewery.fermenter.mda.metamodel.element.Metamodel;
import org.technologybrewery.fermenter.mda.metamodel.element.MetamodelElement;
import org.technologybrewery.fermenter.mda.metamodel.element.NamespacedMetamodel;
import org.technologybrewery.fermenter.mda.util.JsonUtils;
import org.technologybrewery.fermenter.mda.util.MessageTracker;

public abstract class AbstractMetamodelManager<T extends NamespacedMetamodel> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMetamodelManager.class);
    private static final String METAMODEL_SUFFIX = "json";
    private Map<String, Map<String, T>> metadataByPackageMap = new HashMap<String, Map<String, T>>();
    private Map<String, Map<String, T>> metadataByArtifactIdMap = new HashMap<String, Map<String, T>>();
    private Map<String, T> completeMetadataMap = new HashMap<String, T>();
    private static MessageTracker messageTracker = MessageTracker.getInstance();
    protected ModelRepositoryConfiguration repoConfiguration;
    protected MetamodelConfig config = (MetamodelConfig)KrauseningConfigFactory.create(MetamodelConfig.class, (Map[])new Map[0]);
    protected boolean hasDirectoryModels;
    protected boolean hasJarModels;
    protected String delayedLocalDirectoryWarning;

    public void reset() {
        this.metadataByPackageMap = new HashMap<String, Map<String, T>>();
        this.metadataByArtifactIdMap = new HashMap<String, Map<String, T>>();
        this.completeMetadataMap = new HashMap<String, T>();
    }

    protected final void validate() {
        for (String packageName : this.metadataByPackageMap.keySet()) {
            Collection<T> metadataItems = this.getMetadataMap(packageName).values();
            AbstractMetamodelManager.validateElements(metadataItems);
        }
    }

    protected static <T extends Metamodel> void validateElements(Collection<T> elements) {
        if (!CollectionUtils.isEmpty(elements)) {
            for (Metamodel element : elements) {
                element.validate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMetadata(ModelInstanceUrl modelInstanceUrl, ModelRepositoryConfiguration repoConfiguration) {
        this.repoConfiguration = repoConfiguration;
        if (StringUtils.isBlank((CharSequence)modelInstanceUrl.getUrl())) {
            messageTracker.addErrorMessage("Model instance for artifactId '" + modelInstanceUrl.getArtifactId() + "' can not be found!  Please ensure the proper jar is on your classpath.");
        } else {
            List<URL> resources = null;
            try {
                resources = this.getMetadataResources(modelInstanceUrl.getUrl());
            }
            catch (IOException | URISyntaxException e) {
                logger.error("Problem encountered loading model instances for " + modelInstanceUrl.getArtifactId(), (Throwable)e);
                messageTracker.addWarningMessage("No " + this.getMetadataLocation() + " metadata found for '" + modelInstanceUrl.getArtifactId() + "', skipping...");
            }
            if (resources == null || !this.hasJarModels && !this.hasDirectoryModels) {
                if (this.delayedLocalDirectoryWarning != null) {
                    logger.warn(this.delayedLocalDirectoryWarning);
                }
                return;
            }
            for (URL resource : resources) {
                InputStream is = null;
                try {
                    is = resource.openStream();
                    this.loadMetamodelFile(is, modelInstanceUrl.getArtifactId(), resource);
                }
                catch (IOException | GenerationException e) {
                    logger.error("Problem encountered loading model instance " + resource.toExternalForm(), (Throwable)e);
                    messageTracker.addErrorMessage("Problem loading" + resource.toExternalForm() + " model instance found in '" + modelInstanceUrl.getArtifactId() + "', skipping...");
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            this.postLoadMetamodel();
        }
    }

    protected List<URL> getMetadataResources(String name) throws IOException, URISyntaxException {
        List<URL> metadataResources = null;
        metadataResources = name.contains(".jar") ? this.getMetadataResourceFromJar(name) : this.getMetadataResourcesFromDirectory(name);
        return metadataResources;
    }

    private List<URL> getMetadataResourceFromJar(String name) throws IOException {
        ArrayList<URL> metadataResources = new ArrayList<URL>();
        name = "jar:" + (String)name + "!/";
        URL jarUrl = new URL((String)name);
        JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
        JarFile file = jarConnection.getJarFile();
        Enumeration<JarEntry> e = file.entries();
        while (e.hasMoreElements()) {
            JarEntry newEntry = e.nextElement();
            String entryName = newEntry.getName();
            if (!entryName.startsWith(this.getMetadataLocation()) || !entryName.endsWith(".json")) continue;
            metadataResources.add(new URL((String)name + newEntry.getName()));
            this.hasJarModels = true;
        }
        return metadataResources;
    }

    private List<URL> getMetadataResourcesFromDirectory(String name) throws URISyntaxException, IOException {
        File metamodelDir;
        ArrayList<URL> metadataResources = new ArrayList<URL>();
        if (!((String)name).endsWith("/")) {
            name = (String)name + "/";
        }
        if ((metamodelDir = new File(new URI((String)name + this.getMetadataLocation()))).isDirectory()) {
            String[] suffixFilter = new String[]{METAMODEL_SUFFIX};
            Collection files = FileUtils.listFiles((File)metamodelDir, (String[])suffixFilter, (boolean)true);
            if (CollectionUtils.isNotEmpty((Collection)files)) {
                for (File file : files) {
                    metadataResources.add(file.toURI().toURL());
                    this.hasDirectoryModels = true;
                }
            }
        } else {
            this.delayedLocalDirectoryWarning = metamodelDir.getCanonicalPath() + " is not a valid directory!";
        }
        return metadataResources;
    }

    protected abstract String getMetadataLocation();

    private void loadMetamodelFile(InputStream stream, String artifactId, URL resource) {
        ObjectMapper objectMapper = JsonUtils.getObjectMapper();
        try {
            NamespacedMetamodel instance = (NamespacedMetamodel)objectMapper.readValue(stream, this.getMetamodelClass());
            ((MetamodelElement)((Object)instance)).setFileUrl(resource);
            this.addMetadataElement(instance, artifactId);
        }
        catch (IOException e) {
            throw new FermenterException("Problem reading metamodel!", e);
        }
    }

    protected abstract Class<? extends T> getMetamodelClass();

    protected abstract String getMetamodelDescription();

    protected void postLoadMetamodel() {
        if (logger.isInfoEnabled()) {
            logger.info("Loaded " + this.completeMetadataMap.size() + " " + this.getMetamodelDescription() + "(s)");
        }
    }

    protected Map<String, T> getMetadataMap(String packageName) {
        return this.metadataByPackageMap.get(packageName);
    }

    public Map<String, T> getMetadataByArtifactIdMap(String artifactId) {
        return this.metadataByArtifactIdMap.get(artifactId);
    }

    protected Map<String, T> getCompleteMetadataMap() {
        return this.completeMetadataMap;
    }

    protected void addMetadataElement(T element, String artifactId) {
        String packageName = element.getPackage();
        String name = element.getName();
        Map<String, T> packageMap = this.getMetadataMap(packageName);
        if (packageMap == null) {
            packageMap = new HashMap<String, T>();
            this.metadataByPackageMap.put(packageName, packageMap);
        } else if (packageMap.containsKey(name)) {
            logger.warn("Metamodel " + name + " exists for package " + packageName + ". Replacing...");
            messageTracker.addWarningMessage("Metamodel " + name + " exists for package " + packageName + ". Replacing...");
        }
        packageMap.put(name, element);
        Map<String, T> artifactIdMap = this.getMetadataByArtifactIdMap(artifactId);
        if (artifactIdMap == null) {
            artifactIdMap = new HashMap<String, T>();
            this.metadataByArtifactIdMap.put(artifactId, artifactIdMap);
        } else if (artifactIdMap.containsKey(name)) {
            logger.warn("Metamodel " + name + " exists for artifact Id " + artifactId + ". Replacing...");
            messageTracker.addWarningMessage("Metamodel " + name + " exists for artifact Id " + artifactId + ". Replacing...");
        }
        artifactIdMap.put(name, element);
        if (this.getCompleteMetadataMap().containsKey(name)) {
            logger.warn("Metamodel " + name + " exists. Replacing...");
            messageTracker.addWarningMessage("Metamodel " + name + " exists. Replacing...");
        }
        this.completeMetadataMap.put(name, element);
    }

    public T getMetadataElementByPackageAndName(String packageName, String name) {
        Map<String, T> metadataMap = this.getMetadataMap(packageName);
        return (T)(metadataMap != null ? (NamespacedMetamodel)metadataMap.get(name) : null);
    }

    public T getMetadataElementByArtifactIdAndName(String artifactId, String name) {
        Map<String, T> metadataMap = this.getMetadataByArtifactIdMap(artifactId);
        return (T)(metadataMap != null ? (NamespacedMetamodel)metadataMap.get(name) : null);
    }

    public Map<String, T> getMetadataElementByPackage(String packageName) {
        Map<String, T> byPackageMap = this.getMetadataMap(packageName);
        return byPackageMap != null ? byPackageMap : Collections.emptyMap();
    }

    public Map<String, T> getMetadataElementWithoutPackage() {
        return this.completeMetadataMap;
    }

    public Map<String, T> getMetadataElementByContext(String context) {
        Map<String, Object> metamodelInstanceMap;
        if (ModelContext.useLocalModelInstancesOnly(context)) {
            metamodelInstanceMap = this.getMetadataByArtifactIdMap(this.repoConfiguration.getArtifactId());
        } else if (ModelContext.useTargetedModelInstances(context)) {
            metamodelInstanceMap = new HashMap<String, T>();
            List<String> targetedArtifactIds = this.repoConfiguration.getTargetModelInstances();
            for (String artifactId : targetedArtifactIds) {
                Map<String, T> targetedModelMap = this.getMetadataByArtifactIdMap(artifactId);
                if (targetedModelMap == null || targetedModelMap.size() == 0) {
                    logger.debug("No instances were found for targeted artifactId '" + artifactId + "'");
                    continue;
                }
                metamodelInstanceMap.putAll(targetedModelMap);
            }
        } else {
            throw new GenerationException("Invalid context being requested '" + context + "'!");
        }
        if (metamodelInstanceMap == null) {
            metamodelInstanceMap = Collections.emptyMap();
        }
        return metamodelInstanceMap;
    }
}

