/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.technologybrewery.fermenter.mda.generator.GenerationException;
import org.technologybrewery.fermenter.mda.metamodel.AbstractModelInstanceRepository;
import org.technologybrewery.fermenter.mda.metamodel.DictionaryModelInstanceManager;
import org.technologybrewery.fermenter.mda.metamodel.EntityModelInstanceManager;
import org.technologybrewery.fermenter.mda.metamodel.EnumerationModelInstanceManager;
import org.technologybrewery.fermenter.mda.metamodel.MessageGroupModelInstanceManager;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceUrl;
import org.technologybrewery.fermenter.mda.metamodel.ModelRepositoryConfiguration;
import org.technologybrewery.fermenter.mda.metamodel.RuleModelInstanceManager;
import org.technologybrewery.fermenter.mda.metamodel.ServiceModelInstanceManager;
import org.technologybrewery.fermenter.mda.metamodel.element.DictionaryType;
import org.technologybrewery.fermenter.mda.metamodel.element.Entity;
import org.technologybrewery.fermenter.mda.metamodel.element.Enumeration;
import org.technologybrewery.fermenter.mda.metamodel.element.MessageGroup;
import org.technologybrewery.fermenter.mda.metamodel.element.Rule;
import org.technologybrewery.fermenter.mda.metamodel.element.Service;
import org.technologybrewery.fermenter.mda.util.MessageTracker;

public class DefaultModelInstanceRepository
extends AbstractModelInstanceRepository {
    private static final Log log = LogFactory.getLog(DefaultModelInstanceRepository.class);
    private EnumerationModelInstanceManager enumerationManager = EnumerationModelInstanceManager.getInstance();
    private EntityModelInstanceManager entityManager = EntityModelInstanceManager.getInstance();
    private ServiceModelInstanceManager serviceManager = ServiceModelInstanceManager.getInstance();
    private DictionaryModelInstanceManager dictionaryManager = DictionaryModelInstanceManager.getInstance();
    private MessageGroupModelInstanceManager messageGroupManager = MessageGroupModelInstanceManager.getInstance();
    private RuleModelInstanceManager ruleManager = RuleModelInstanceManager.getInstance();

    public DefaultModelInstanceRepository(ModelRepositoryConfiguration config) {
        super(config);
    }

    @Override
    public void load() {
        this.enumerationManager.reset();
        this.dictionaryManager.reset();
        this.serviceManager.reset();
        this.entityManager.reset();
        this.messageGroupManager.reset();
        this.ruleManager.reset();
        Collection<ModelInstanceUrl> modelInstanceUrls = this.config.getMetamodelInstanceLocations().values();
        for (ModelInstanceUrl modelInstanceUrl : modelInstanceUrls) {
            long start = System.currentTimeMillis();
            this.enumerationManager.loadMetadata(modelInstanceUrl, this.config);
            this.dictionaryManager.loadMetadata(modelInstanceUrl, this.config);
            this.serviceManager.loadMetadata(modelInstanceUrl, this.config);
            this.entityManager.loadMetadata(modelInstanceUrl, this.config);
            this.messageGroupManager.loadMetadata(modelInstanceUrl, this.config);
            this.ruleManager.loadMetadata(modelInstanceUrl, this.config);
            if (!log.isInfoEnabled()) continue;
            long stop = System.currentTimeMillis();
            log.info((Object)("Metamodel instances for artifactId '" + modelInstanceUrl.getArtifactId() + "' have been loaded - " + (stop - start) + "ms"));
        }
    }

    public Set<String> getArtifactIds() {
        HashSet<String> artifactIds = new HashSet<String>();
        Collection<ModelInstanceUrl> urls = this.config.getMetamodelInstanceLocations().values();
        for (ModelInstanceUrl url : urls) {
            artifactIds.add(url.getArtifactId());
        }
        return artifactIds;
    }

    @Override
    public void validate() {
        for (Enumeration enumeration : this.enumerationManager.getMetadataElementWithoutPackage().values()) {
            enumeration.validate();
        }
        for (DictionaryType dictionaryType : this.dictionaryManager.getMetadataElementWithoutPackage().values()) {
            dictionaryType.validate();
        }
        for (Service service : this.serviceManager.getMetadataElementWithoutPackage().values()) {
            service.validate();
        }
        for (Entity entity : this.entityManager.getMetadataElementWithoutPackage().values()) {
            entity.validate();
        }
        for (MessageGroup messageGroup : this.messageGroupManager.getMetadataElementWithoutPackage().values()) {
            messageGroup.validate();
        }
        for (Rule rule : this.ruleManager.getMetadataElementWithoutPackage().values()) {
            rule.validate();
        }
        MessageTracker messageTracker = MessageTracker.getInstance();
        messageTracker.emitMessages(log);
        if (messageTracker.hasErrors()) {
            throw new GenerationException("Encountered one or more error!  Please check your Maven output for details.");
        }
    }

    public Enumeration getEnumeration(String name) {
        return (Enumeration)this.enumerationManager.getMetadataElementByPackageAndName(this.config.getBasePackage(), name);
    }

    public Enumeration getEnumeration(String packageName, String name) {
        return (Enumeration)this.enumerationManager.getMetadataElementByPackageAndName(packageName, name);
    }

    public Map<String, Enumeration> getEnumerations(String packageName) {
        return this.enumerationManager.getMetadataElementByPackage(packageName);
    }

    public Map<String, Enumeration> getEnumerationsByArtifactId(String artifactId) {
        return this.enumerationManager.getMetadataByArtifactIdMap(artifactId);
    }

    public Map<String, Enumeration> getEnumerationsByContext(String context) {
        return this.enumerationManager.getMetadataElementByContext(context);
    }

    public DictionaryType getDictionaryType(String name) {
        return (DictionaryType)this.dictionaryManager.getMetadataElementByPackageAndName(this.config.getBasePackage(), name);
    }

    public Map<String, DictionaryType> getDictionaryTypes() {
        return this.dictionaryManager.getMetadataElementWithoutPackage();
    }

    public Map<String, DictionaryType> getDictionaryTypesByArtifactId(String artifactId) {
        return this.dictionaryManager.getMetadataByArtifactIdMap(artifactId);
    }

    public Map<String, DictionaryType> getDictionaryTypesByContext(String context) {
        return this.dictionaryManager.getMetadataElementByContext(context);
    }

    public Service getService(String name) {
        return (Service)this.serviceManager.getMetadataElementByPackageAndName(this.config.getBasePackage(), name);
    }

    public Service getService(String packageName, String name) {
        return (Service)this.serviceManager.getMetadataElementByPackageAndName(packageName, name);
    }

    public Map<String, Service> getServices(String packageName) {
        return this.serviceManager.getMetadataElementByPackage(packageName);
    }

    public Map<String, Service> getServicesByArtifactId(String artifactId) {
        return this.serviceManager.getMetadataByArtifactIdMap(artifactId);
    }

    public Map<String, Service> getServicesByContext(String context) {
        return this.serviceManager.getMetadataElementByContext(context);
    }

    public Entity getEntity(String name) {
        return (Entity)this.entityManager.getMetadataElementByPackageAndName(this.config.getBasePackage(), name);
    }

    public Entity getEntity(String packageName, String name) {
        return (Entity)this.entityManager.getMetadataElementByPackageAndName(packageName, name);
    }

    public Map<String, Entity> getEntities(String packageName) {
        return this.entityManager.getMetadataElementByPackage(packageName);
    }

    public Map<String, Entity> getEntitiesByArtifactId(String artifactId) {
        return this.entityManager.getMetadataByArtifactIdMap(artifactId);
    }

    public Map<String, Entity> getEntitiesByContext(String context) {
        return this.entityManager.getMetadataElementByContext(context);
    }

    public Set<Entity> getEntitiesByDependencyOrder(String context) {
        return this.entityManager.getNamesByDependencyOrder(context);
    }

    public MessageGroup getMessageGroup(String name) {
        return (MessageGroup)this.messageGroupManager.getMetadataElementByPackageAndName(this.config.getBasePackage(), name);
    }

    public MessageGroup getMessageGroup(String packageName, String name) {
        return (MessageGroup)this.messageGroupManager.getMetadataElementByPackageAndName(packageName, name);
    }

    public Map<String, MessageGroup> getMessageGroups(String packageName) {
        return this.messageGroupManager.getMetadataElementByPackage(packageName);
    }

    public Map<String, MessageGroup> getMessageGroupsByArtifactId(String artifactId) {
        return this.messageGroupManager.getMetadataByArtifactIdMap(artifactId);
    }

    public Map<String, MessageGroup> getMessageGroupsByContext(String context) {
        return this.messageGroupManager.getMetadataElementByContext(context);
    }

    public Rule getRule(String name) {
        return (Rule)this.ruleManager.getMetadataElementByPackageAndName(this.config.getBasePackage(), name);
    }

    public Rule getRule(String packageName, String name) {
        return (Rule)this.ruleManager.getMetadataElementByPackageAndName(packageName, name);
    }

    public Map<String, Rule> getRules(String packageName) {
        return this.ruleManager.getMetadataElementByPackage(packageName);
    }

    public Map<String, Rule> getRulesByArtifactId(String artifactId) {
        return this.ruleManager.getMetadataByArtifactIdMap(artifactId);
    }

    public Map<String, Rule> getRulesByContext(String context) {
        return this.ruleManager.getMetadataElementByContext(context);
    }
}

