/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.Entity;
import org.technologybrewery.fermenter.mda.metamodel.element.Reference;
import org.technologybrewery.fermenter.mda.metamodel.element.Relation;

public class EntityComparator
implements Comparator<Entity> {
    private Map<String, List<String>> referencedObjects;

    public EntityComparator(Map<String, List<String>> referencedObjects) {
        this.referencedObjects = referencedObjects;
    }

    @Override
    public int compare(Entity o1, Entity o2) {
        int compareValue = 0;
        if (o1 != o2) {
            if (this.referencedObjects.containsKey(o1.getName()) && !this.referencedObjects.containsKey(o2.getName())) {
                compareValue = -1;
            } else if (this.referencedObjects.containsKey(o2.getName()) && !this.referencedObjects.containsKey(o1.getName())) {
                compareValue = 1;
            } else {
                compareValue = this.compareAgainstReference(o1, o2, compareValue);
                compareValue = this.compareAgainstRelations(o1, o2, compareValue);
                compareValue = this.orderAlphabetically(o1, o2, compareValue);
            }
        }
        return compareValue;
    }

    protected int orderAlphabetically(Entity o1, Entity o2, int compareValue) {
        if (compareValue == 0) {
            compareValue = o1.getName().compareTo(o2.getName());
        }
        return compareValue;
    }

    protected int compareAgainstRelations(Entity o1, Entity o2, int compareValue) {
        compareValue = this.compareRelationsAssumingO1IsParent(o1, o2, compareValue);
        compareValue = this.compareRelationsAssumingO1IsChild(o1, o2, compareValue);
        return compareValue;
    }

    protected int compareRelationsAssumingO1IsChild(Entity o1, Entity o2, int compareValue) {
        List<Relation> o2Relations;
        if (compareValue == 0 && CollectionUtils.isNotEmpty(o2Relations = o2.getRelations())) {
            for (Relation relation : o2Relations) {
                if (!relation.getPackage().equals(o1.getPackage()) || !relation.getType().equals(o1.getName())) continue;
                compareValue = 1;
                break;
            }
        }
        return compareValue;
    }

    protected int compareRelationsAssumingO1IsParent(Entity o1, Entity o2, int compareValue) {
        List<Relation> o1Relations = o1.getRelations();
        if (CollectionUtils.isNotEmpty(o1Relations)) {
            for (Relation relation : o1Relations) {
                if (!relation.getPackage().equals(o2.getPackage()) || !relation.getType().equals(o2.getName())) continue;
                compareValue = -1;
                break;
            }
        }
        return compareValue;
    }

    protected int compareAgainstReference(Entity o1, Entity o2, int compareValue) {
        List referencesToEntity = this.referencedObjects.getOrDefault(o1.getName(), Collections.emptyList());
        if (referencesToEntity.contains(o2.getName())) {
            compareValue = -1;
        } else {
            List<Reference> o1References = o1.getReferences();
            if (CollectionUtils.isNotEmpty(o1References)) {
                for (Reference reference : o1References) {
                    if (!reference.getPackage().equals(o2.getPackage()) || !reference.getType().equals(o2.getName())) continue;
                    compareValue = 1;
                    break;
                }
            }
        }
        return compareValue;
    }
}

