/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.technologybrewery.fermenter.mda.generator.GenerationException;
import org.technologybrewery.fermenter.mda.metamodel.AbstractMetamodelManager;
import org.technologybrewery.fermenter.mda.metamodel.EntityComparator;
import org.technologybrewery.fermenter.mda.metamodel.element.Entity;
import org.technologybrewery.fermenter.mda.metamodel.element.EntityElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Reference;
import org.technologybrewery.fermenter.mda.metamodel.element.Relation;
import org.technologybrewery.fermenter.mda.metamodel.element.RelationElement;

class EntityModelInstanceManager
extends AbstractMetamodelManager<Entity> {
    private static ThreadLocal<EntityModelInstanceManager> threadBoundInstance = ThreadLocal.withInitial(EntityModelInstanceManager::new);

    public static EntityModelInstanceManager getInstance() {
        return threadBoundInstance.get();
    }

    @Override
    public void reset() {
        super.reset();
        threadBoundInstance.remove();
    }

    private EntityModelInstanceManager() {
    }

    @Override
    protected String getMetadataLocation() {
        return this.config.getEntitiesRelativePath();
    }

    @Override
    protected Class<EntityElement> getMetamodelClass() {
        return EntityElement.class;
    }

    @Override
    protected String getMetamodelDescription() {
        return Entity.class.getSimpleName();
    }

    public Set<Entity> getNamesByDependencyOrder(String context) {
        HashMap<String, List<String>> referencedObjects = new HashMap<String, List<String>>();
        Map rawEntities = this.getMetadataElementByContext(context);
        for (Entity rawEntity : rawEntities.values()) {
            List<Reference> references = rawEntity.getReferences();
            for (Reference reference : references) {
                String type = reference.getType();
                List inboundReferences = referencedObjects.computeIfAbsent(type, f -> new ArrayList());
                inboundReferences.add(rawEntity.getName());
            }
        }
        TreeSet<Entity> dependencyOrderedEntities = new TreeSet<Entity>(new EntityComparator(referencedObjects));
        for (Entity rawEntity : rawEntities.values()) {
            dependencyOrderedEntities.add(rawEntity);
        }
        return dependencyOrderedEntities;
    }

    @Override
    protected void postLoadMetamodel() {
        Iterator entityMapIterator;
        super.postLoadMetamodel();
        Map<String, Entity> entityMap = this.getTargetMetadataMap();
        Iterator<Object> iterator = entityMapIterator = entityMap != null ? entityMap.values().iterator() : Collections.emptyIterator();
        while (entityMapIterator.hasNext()) {
            Iterator<Object> relationValueInterator;
            EntityElement entity = (EntityElement)entityMapIterator.next();
            List<Relation> relationMap = entity.getRelations();
            Iterator<Object> iterator2 = relationValueInterator = relationMap != null ? relationMap.iterator() : Collections.emptyIterator();
            while (relationValueInterator.hasNext()) {
                RelationElement relation = (RelationElement)relationValueInterator.next();
                String relationType = relation.getType();
                EntityElement childEntity = (EntityElement)entityMap.get(relationType);
                if (childEntity != null) {
                    childEntity.addInverseRelation(entity);
                    continue;
                }
                throw new GenerationException("Could not find a relation to entity: " + relationType);
            }
        }
    }

    private Map<String, Entity> getTargetMetadataMap() {
        HashMap<String, Entity> entityMap = new HashMap<String, Entity>();
        List<String> targetedArtifactIds = this.repoConfiguration.getTargetModelInstances();
        for (String artifactId : targetedArtifactIds) {
            Map targetedModelMap = this.getMetadataByArtifactIdMap(artifactId);
            if (targetedModelMap == null) continue;
            entityMap.putAll(targetedModelMap);
        }
        return entityMap;
    }
}

