/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel.element;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.DictionaryType;
import org.technologybrewery.fermenter.mda.metamodel.element.ValidationElement;

@JsonPropertyOrder(value={"name"})
public class DictionaryTypeElement
extends ValidationElement
implements DictionaryType {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> formats = new ArrayList<String>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String type;

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public List<String> getFormats() {
        return this.formats;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setFormats(List<String> formats) {
        this.formats.addAll(formats);
    }

    @Override
    public void validate() {
        super.validate();
        if (null == this.getName()) {
            messageTracker.addErrorMessage("Dictionary type name is not specified.");
        }
        if (null == this.getType()) {
            messageTracker.addErrorMessage("Dictionary base type is not specified.");
        }
        if (null != this.getMinLength() && this.getMinLength() < 0) {
            messageTracker.addErrorMessage("Dictionary type min length is less than zero.");
        }
        if (null != this.getMaxLength() && this.getMaxLength() <= 0) {
            messageTracker.addErrorMessage("Dictionary type max length is less than or equal to zero.");
        }
        if (null != this.getMinLength() && null != this.getMaxLength() && this.getMaxLength() < this.getMinLength()) {
            messageTracker.addErrorMessage("Dictionary type max length is less than min length.");
        }
        for (String format : this.getFormats()) {
            if (!StringUtils.isBlank((CharSequence)format)) continue;
            messageTracker.addErrorMessage("Dictionary type format is empty.");
        }
    }

    @Override
    public String getSchemaFileName() {
        return "fermenter-2-type-dictionary-schema.json";
    }

    @Override
    public boolean hasValue() {
        return this.getMaxLength() != null || this.getMinLength() != null || this.getMaxValue() != null || this.getMinValue() != null || this.getScale() != null || this.getDocumentation() != null || this.getType() != null || this.getFormats() != null;
    }
}

