/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel.element;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.DefaultModelInstanceRepository;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;
import org.technologybrewery.fermenter.mda.metamodel.element.Entity;
import org.technologybrewery.fermenter.mda.metamodel.element.Field;
import org.technologybrewery.fermenter.mda.metamodel.element.NamespacedMetamodelElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Parent;
import org.technologybrewery.fermenter.mda.metamodel.element.Reference;
import org.technologybrewery.fermenter.mda.metamodel.element.Relation;

@JsonPropertyOrder(value={"package", "name", "transient", "table", "lockStrategy", "documentation", "parent", "identifier", "fields", "references", "relations"})
public class EntityElement
extends NamespacedMetamodelElement
implements Entity {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String documentation;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String table;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Entity.LockStrategy lockStrategy;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="transient")
    protected Boolean transientEntity;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Parent parent;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Field identifier;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected List<Field> fields = new ArrayList<Field>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected List<Reference> references = new ArrayList<Reference>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected List<Relation> relations = new ArrayList<Relation>();
    @JsonIgnore
    protected List<Entity> inverseRelations = new ArrayList<Entity>();

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public Entity.LockStrategy getLockStrategy() {
        return this.lockStrategy;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean isTransient() {
        return this.transientEntity;
    }

    @Override
    @JsonIgnore
    public Boolean isNonPersistentParentEntity() {
        DefaultModelInstanceRepository metadataRepository = ModelInstanceRepositoryManager.getMetamodelRepository(DefaultModelInstanceRepository.class);
        for (String artifactId : metadataRepository.getArtifactIds()) {
            Map<String, Entity> allEntities = metadataRepository.getEntitiesByArtifactId(artifactId);
            if (allEntities == null) continue;
            for (Entity entity : allEntities.values()) {
                Parent foundParent = entity.getParent();
                if (foundParent == null || !this.getName().equals(foundParent.getType()) || !Parent.InheritanceStrategy.MAPPED_SUPERCLASS.equals((Object)foundParent.getInheritanceStrategy())) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @Override
    @JsonIgnore
    public Boolean isChildOfNonPersistentParentEntity() {
        return this.getParent() == null ? Boolean.FALSE.booleanValue() : Parent.InheritanceStrategy.MAPPED_SUPERCLASS.equals((Object)this.getParent().getInheritanceStrategy());
    }

    @Override
    public Parent getParent() {
        return this.parent;
    }

    @Override
    public Field getIdentifier() {
        return this.identifier;
    }

    @Override
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public List<Reference> getReferences() {
        return this.references;
    }

    @Override
    public List<Relation> getRelations() {
        return this.relations;
    }

    @Override
    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.getName())) {
            messageTracker.addErrorMessage("A service has been specified without a name!");
        }
        if (this.lockStrategy == null) {
            this.lockStrategy = Entity.LockStrategy.OPTIMISTIC;
        }
        if (this.transientEntity == null) {
            this.transientEntity = Boolean.FALSE;
        }
        if (this.parent != null) {
            this.parent.validate();
        }
        for (Field field : this.fields) {
            field.validate();
        }
        for (Reference reference : this.references) {
            reference.validate();
        }
        for (Relation relation : this.relations) {
            relation.validate();
        }
    }

    @Override
    public String getSchemaFileName() {
        return "fermenter-2-entity-schema.json";
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setLockStrategy(String strategy) {
        this.lockStrategy = Entity.LockStrategy.fromString(strategy);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{strategy}) && this.lockStrategy == null) {
            messageTracker.addErrorMessage("Could not map lock strategy '" + strategy + "' to one of the known lock strategy types! (" + Entity.LockStrategy.options() + ") ");
        }
    }

    public void setTransient(Boolean tranientEntity) {
        this.transientEntity = tranientEntity;
    }

    public void setParent(Parent parent) {
        this.parent = parent;
    }

    public void setIdentifier(Field identifier) {
        this.identifier = identifier;
    }

    public void addField(Field field) {
        this.fields.add(field);
    }

    public void addReference(Reference reference) {
        this.references.add(reference);
    }

    public void addRelation(Relation relation) {
        this.relations.add(relation);
    }

    @Override
    public List<Entity> getInverseRelations() {
        if (this.inverseRelations == null) {
            this.inverseRelations = new ArrayList<Entity>();
        }
        return this.inverseRelations;
    }

    public void addInverseRelation(Entity reverseRelation) {
        this.getInverseRelations().add(reverseRelation);
    }

    @Override
    public Relation getRelation(String type) {
        for (Relation relation : this.getRelations()) {
            if (!relation.getType().equals(type)) continue;
            return relation;
        }
        return null;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("package", (Object)this.getPackage()).add("name", (Object)this.name).toString();
    }
}

