/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel.element;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.Enum;
import org.technologybrewery.fermenter.mda.metamodel.element.EnumElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Enumeration;
import org.technologybrewery.fermenter.mda.metamodel.element.NamespacedMetamodelElement;

@JsonPropertyOrder(value={"package", "name"})
public class EnumerationElement
extends NamespacedMetamodelElement
implements Enumeration {
    @JsonProperty(required=true)
    protected List<Enum> enums = new ArrayList<Enum>();
    protected Integer maxLength;
    protected boolean isNamed = true;

    @Override
    @JsonIgnore
    public Integer getMaxLength() {
        if (this.maxLength == null) {
            List<Enum> enumList = this.getEnums();
            int maxiumLength = 0;
            for (Enum e : enumList) {
                String name = e.getName();
                int currentLength = name.length();
                if (currentLength <= maxiumLength) continue;
                maxiumLength = currentLength;
            }
            this.maxLength = maxiumLength;
        }
        return this.maxLength;
    }

    @Override
    public List<Enum> getEnums() {
        return this.enums;
    }

    public void addEnums(EnumElement contant) {
        this.enums.add(contant);
    }

    @Override
    @JsonIgnore
    public boolean isNamed() {
        return this.isNamed;
    }

    @Override
    @JsonIgnore
    public boolean isValued() {
        return !this.isNamed;
    }

    @Override
    public void validate() {
        super.validate();
        if (CollectionUtils.isEmpty(this.enums)) {
            messageTracker.addWarningMessage("Enumeration " + this.getName() + " does NOT contain any enum constants!");
        }
        for (Enum enumInstance : this.enums) {
            if (enumInstance.getValue() == null) continue;
            this.isNamed = false;
            break;
        }
    }

    @Override
    public String getSchemaFileName() {
        return "fermenter-2-enumeration-schema.json";
    }
}

