/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel.element;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.Field;
import org.technologybrewery.fermenter.mda.metamodel.element.MetamodelElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Validation;

@JsonPropertyOrder(value={"package", "name", "documentation", "type", "transient"})
public class FieldElement
extends MetamodelElement
implements Field {
    protected String packageName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String column;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Validation validation;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String documentation;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Boolean required;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Field.Generator generator;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String defaultValue;
    protected Boolean isTransient;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String label;

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="package", required=false)
    public String getPackage() {
        return this.packageName;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    @Override
    public Validation getValidation() {
        return this.validation;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean isRequired() {
        return this.required;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public Field.Generator getGenerator() {
        return this.generator;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="transient", required=false)
    public Boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void validate() {
    }

    public void setPackage(String packageName) {
        this.packageName = packageName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public void setType(Validation validation) {
        this.validation = validation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public void setValidation(Validation validation) {
        this.validation = validation;
    }

    public void setTransient(Boolean transientValue) {
        this.isTransient = transientValue != null ? transientValue : Boolean.FALSE;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setGenerator(String generator) {
        this.generator = Field.Generator.fromString(generator);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{generator}) && this.generator == null) {
            messageTracker.addErrorMessage("Could not map generator '" + generator + "' to one of the known generator types! (" + Field.Generator.options() + ") ");
        }
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }
}

