/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel.element;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.Metamodel;
import org.technologybrewery.fermenter.mda.util.MessageTracker;

public abstract class MetamodelElement
implements Metamodel {
    protected static MessageTracker messageTracker = MessageTracker.getInstance();
    @JsonProperty(required=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String name;
    @JsonIgnore
    protected URL fileUrl;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFileUrl(URL file) {
        this.fileUrl = file;
    }

    @Override
    @JsonIgnore
    public String getFileName() {
        return this.fileUrl != null ? this.fileUrl.getFile() : null;
    }

    @Override
    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.getName())) {
            messageTracker.addErrorMessage("Name is a required attribute!");
        } else {
            String localFileName = this.getFileName();
            if (localFileName != null) {
                String strippedFileName = localFileName.substring(localFileName.lastIndexOf("/") + 1, localFileName.lastIndexOf(46));
                if (!this.getName().equals(strippedFileName)) {
                    messageTracker.addErrorMessage("The file name must match the element name!  Expected: '" + this.getName() + "', but found: '**" + strippedFileName + "**.json' (file: " + localFileName + ")");
                }
            }
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public boolean equals(Object obj) {
        boolean areEqual;
        if (obj == null) {
            areEqual = false;
        } else if (obj == this) {
            areEqual = true;
        } else if (obj.getClass() != this.getClass()) {
            areEqual = false;
        } else {
            Metamodel other = (Metamodel)obj;
            areEqual = Objects.equals(this.name, other.getName());
        }
        return areEqual;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }
}

