/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel.element;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.MetamodelElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Operation;
import org.technologybrewery.fermenter.mda.metamodel.element.Parameter;
import org.technologybrewery.fermenter.mda.metamodel.element.ParameterElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Return;
import org.technologybrewery.fermenter.mda.metamodel.element.Transaction;

@JsonPropertyOrder(value={"name"})
public class OperationElement
extends MetamodelElement
implements Operation {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String documentation;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String transactionAttribute;
    @JsonProperty(value="return", required=true)
    protected Return returnElement;
    protected List<Parameter> parameters = new ArrayList<Parameter>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Boolean compressedWithGZip;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Boolean pagedResponse;

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public String getTransactionAttribute() {
        return this.transactionAttribute;
    }

    @Override
    public Return getReturn() {
        return this.returnElement;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public Boolean isCompressedWithGZip() {
        return this.compressedWithGZip;
    }

    @Override
    public void validate() {
        this.defaultTransactionAttribute();
        this.defaultCompressedWithGZip();
        this.defaultPagedResponse();
        this.defaultPageIndexAndSizeParamForPagedResponse();
        if (this.returnElement != null) {
            this.returnElement.validate();
        }
        for (Parameter parameter : this.parameters) {
            parameter.validate();
        }
        this.validateTransactionAttribute();
    }

    private void defaultPageIndexAndSizeParamForPagedResponse() {
        if (this.getReturn().isPagedResponse().booleanValue()) {
            ParameterElement pageIndexParam = new ParameterElement();
            pageIndexParam.setName("startPage");
            pageIndexParam.setType("integer");
            pageIndexParam.setDocumentation("The index of the page being requested. Base zero. Must be a positive integer.");
            pageIndexParam.setMany(false);
            this.parameters.add(pageIndexParam);
            ParameterElement pageSizeParam = new ParameterElement();
            pageSizeParam.setName("count");
            pageSizeParam.setType("integer");
            pageSizeParam.setMany(false);
            pageSizeParam.setDocumentation("The number of elements being requested. Must be a positive integer.");
            this.parameters.add(pageSizeParam);
        }
    }

    private void defaultPagedResponse() {
        if (this.pagedResponse == null) {
            this.pagedResponse = Boolean.FALSE;
        }
    }

    private void defaultCompressedWithGZip() {
        if (this.compressedWithGZip == null) {
            this.compressedWithGZip = Boolean.FALSE;
        }
    }

    private void validateTransactionAttribute() {
        if (!Transaction.isValidTransaction(this.getTransactionAttribute())) {
            messageTracker.addErrorMessage("Transaction attribute must be '" + Transaction.REQUIRED + "', '" + Transaction.REQUIRES_NEW + "', '" + Transaction.MANDATORY + "', '" + Transaction.NOT_SUPPORTED + "', '" + Transaction.SUPPORTS + "' or '" + Transaction.NEVER + "'");
        }
    }

    private void defaultTransactionAttribute() {
        if (StringUtils.isBlank((CharSequence)this.transactionAttribute)) {
            this.transactionAttribute = this.name.startsWith("find") || this.name.startsWith("query") || this.name.startsWith("load") ? Transaction.SUPPORTS.toString() : Transaction.REQUIRED.toString();
        }
    }

    public void setReturn(Return returnElement) {
        this.returnElement = returnElement;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public void setTransactionAttribute(String transactionAttribute) {
        this.transactionAttribute = transactionAttribute;
    }

    public void setCompressedWithGZip(Boolean compress) {
        this.compressedWithGZip = compress;
    }
}

