/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel.element;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.NamespacedMetamodelElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Parameter;

@JsonPropertyOrder(value={"name", "package", "type"})
public class ParameterElement
extends NamespacedMetamodelElement
implements Parameter {
    @JsonProperty(required=true)
    protected String type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Boolean many;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String documentation;

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="package", required=false)
    public String getPackage() {
        return super.getPackage();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Boolean isMany() {
        return this.many;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.getName())) {
            messageTracker.addErrorMessage("A parameter has been specified without a name!");
        }
        if (StringUtils.isBlank((CharSequence)this.type)) {
            messageTracker.addErrorMessage("Parameter " + this.getName() + " has been specified without a type!");
        }
        if (this.many == null) {
            this.many = Boolean.FALSE;
        }
    }

    @Override
    public String getSchemaFileName() {
        return "fermenter-2-service-schema.json";
    }

    public void setMany(Boolean many) {
        this.many = many;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("package", (Object)this.getPackage()).add("name", (Object)this.name).toString();
    }
}

