/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel.element;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.DefaultModelInstanceRepository;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;
import org.technologybrewery.fermenter.mda.metamodel.element.Entity;
import org.technologybrewery.fermenter.mda.metamodel.element.NamespacedMetamodelElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Parent;

@JsonPropertyOrder(value={"package", "type"})
public class ParentElement
extends NamespacedMetamodelElement
implements Parent {
    @JsonProperty(required=true)
    protected String type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Parent.InheritanceStrategy inheritanceStrategy;

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="package", required=false)
    public String getPackage() {
        return super.getPackage();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Parent.InheritanceStrategy getInheritanceStrategy() {
        return this.inheritanceStrategy;
    }

    @Override
    public void validate() {
        DefaultModelInstanceRepository modelRespository;
        Entity parentEntity;
        if (this.inheritanceStrategy == null) {
            this.inheritanceStrategy = Parent.InheritanceStrategy.MAPPED_SUPERCLASS;
        }
        if ((parentEntity = (modelRespository = ModelInstanceRepositoryManager.getMetamodelRepository(DefaultModelInstanceRepository.class)).getEntity(this.packageName, this.type)) == null) {
            messageTracker.addErrorMessage("Parent type of '" + this.type + "' could not be found!");
        }
    }

    @Override
    public String getSchemaFileName() {
        return "fermenter-2-entity-schema.json";
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setInheritanceStrategy(String inheritanceStrategy) {
        this.inheritanceStrategy = Parent.InheritanceStrategy.fromString(inheritanceStrategy);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{inheritanceStrategy}) && this.inheritanceStrategy == null) {
            messageTracker.addErrorMessage("Could not map inheritance strategy '" + inheritanceStrategy + "' to one of the known inheritance strategy types! (" + Parent.InheritanceStrategy.options() + ") ");
        }
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("package", (Object)this.getPackage()).add("type", (Object)this.type).add("inheritanceStrategy", (Object)this.inheritanceStrategy).toString();
    }
}

