/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel.element;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.technologybrewery.fermenter.mda.metamodel.DefaultModelInstanceRepository;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;
import org.technologybrewery.fermenter.mda.metamodel.element.Entity;
import org.technologybrewery.fermenter.mda.metamodel.element.Field;
import org.technologybrewery.fermenter.mda.metamodel.element.FieldElement;
import org.technologybrewery.fermenter.mda.metamodel.element.NamespacedMetamodelElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Reference;

@JsonPropertyOrder(value={"name", "type", "package", "localColumn", "documentation", "required"})
public class ReferenceElement
extends NamespacedMetamodelElement
implements Reference {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String documentation;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Boolean required;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String localColumn;
    @JsonIgnore
    private List<Field> foreignKeys;

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean isRequired() {
        return this.required;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public String getLocalColumn() {
        return this.localColumn;
    }

    @Override
    public void validate() {
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public void setLocalColumn(String localColumn) {
        this.localColumn = localColumn;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    @Override
    public String getSchemaFileName() {
        return "fermenter-2-service-schema.json";
    }

    @Override
    @JsonIgnore
    public List<Field> getForeignKeyFields() {
        if (this.foreignKeys == null) {
            this.foreignKeys = new ArrayList<Field>();
            DefaultModelInstanceRepository metadataRepository = ModelInstanceRepositoryManager.getMetamodelRepository(DefaultModelInstanceRepository.class);
            Map<String, Entity> referenceEntities = metadataRepository.getEntities(this.getPackage());
            Entity entity = referenceEntities.get(this.getType());
            if (entity == null) {
                throw new NullPointerException("Reference to '" + this.type + "' not found!");
            }
            Field fkidentifier = entity.getIdentifier();
            if (fkidentifier != null) {
                FieldElement newId = new FieldElement();
                newId.setType(fkidentifier.getType());
                newId.setName(fkidentifier.getName());
                if (entity.isTransient() == null || !entity.isTransient().booleanValue()) {
                    newId.setColumn(this.localColumn != null ? this.localColumn : fkidentifier.getColumn());
                }
                this.foreignKeys.add(newId);
            } else if (entity.isTransient() == null || !entity.isTransient().booleanValue()) {
                throw new NullPointerException("Reference to '" + this.type + "' does not have a Identifier!");
            }
        }
        return this.foreignKeys;
    }
}

